<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * @package : Champions Montessori Academy
 * @version : 7.0
 * @developed by : GreatCoder Tech
 * @support : dreddavid150@gmail.com
 * @author url : https://web.facebook.com/dreddavid
 * @copyright : Reserved GreatCoder Technologies
 */

class Newsletter extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Newsletter_model');
        $this->load->library('email');
    }

    public function subscribe() {
        $email = $this->input->post('email', true);

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            echo "Invalid email address.";
            return;
        }

        if ($this->Newsletter_model->add_subscriber($email)) {
            echo "You have successfully subscribed!";
        } else {
            echo "We have your email already subscribed!";
        }
    }

    // ADMIN FUNCTION - Send Newsletter
    public function send() {
        $this->load->view('admin/newsletter_send');
    }

    public function send_process() {
        $subject = $this->input->post('subject');
        $message = $this->input->post('message');
        $subscribers = $this->Newsletter_model->get_all_subscribers();

        foreach ($subscribers as $subscriber) {
            $this->email->from('your@email.com', 'Your Site Name');
            $this->email->to($subscriber->email);
            $this->email->subject($subject);
            $this->email->message($message);
            $this->email->send();
        }

        $this->session->set_flashdata('success', 'Newsletter sent successfully!');
        redirect('newsletter/send');
    }
}
