<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Dashboard_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getMonthlyBookIssued($id = '')
    {
        $this->db->select('id');
        $this->db->from('leave_application');
        $this->db->where("start_date BETWEEN DATE_SUB(CURDATE() ,INTERVAL 1 MONTH) AND CURDATE() AND status = '2' AND role_id = '7' AND user_id = " . $this->db->escape($id));
        return $this->db->get()->num_rows();
    }

    public function getStaffCounter($role = '', $branchID = '')
    {
        $this->db->select('COUNT(staff.id) as snumber');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id', 'inner');
        $this->db->where_not_in('login_credential.role', 1);
        if (!empty($role)) {
            $this->db->where('login_credential.role', $role);
        } else {
            $this->db->where_not_in('login_credential.role', array(1, 3, 6, 7));
        }
        if (!empty($branchID)) {
            $this->db->where('staff.branch_id', $branchID);
        }
        return $this->db->get()->row_array();
    }

    public function getMonthlyPayment($id = '')
    {
        $this->db->select('IFNULL(sum(h.amount),0) as amount');
        $this->db->from('fee_allocation as fa');
        $this->db->join('fee_payment_history as h', 'h.allocation_id = fa.id', 'left');
        $this->db->where("h.date BETWEEN DATE_SUB(CURDATE(),INTERVAL 1 MONTH) AND CURDATE() AND fa.student_id = " . $this->db->escape($id) . " AND fa.session_id = " . $this->db->escape(get_session_id()));
        return $this->db->get()->row()->amount;
    }

    public function annualFeessummaryCharts($branchID = '', $studentID = '')
    {
        $total_fee = [];
        $total_paid = [];
        $total_due = [];
        $year = date("Y");
        $sessionID = get_session_id();

        for ($month = 1; $month <= 12; $month++) {

            // 1️⃣ Total fees allocated in this month (based on due date)
            $alloc_sql = "SELECT SUM(`gd`.`amount`) AS `total_allocated`
                      FROM `fee_allocation` AS `fa`
                      INNER JOIN `fee_groups_details` AS `gd` ON `gd`.`fee_groups_id` = `fa`.`group_id`
                      WHERE MONTH(`gd`.`due_date`) = ? AND YEAR(`gd`.`due_date`) = ? 
                      AND `fa`.`session_id` = ?";
            $params = [$month, $year, $sessionID];

            if (!empty($branchID)) {
                $alloc_sql .= " AND `fa`.`branch_id` = ?";
                $params[] = $branchID;
            }
            if (!empty($studentID)) {
                $alloc_sql .= " AND `fa`.`student_id` = ?";
                $params[] = $studentID;
            }

            $alloc_query = $this->db->query($alloc_sql, $params);
            $total_fee_month = 0;
            if ($alloc_query && $alloc_query->num_rows() > 0) {
                $total_fee_month = floatval($alloc_query->row()->total_allocated ?? 0);
            }

            // 2️⃣ Total payments made in this month (based on payment date)
            $paid_sql = "SELECT SUM(`amount`) AS `total_paid`, SUM(`discount`) AS `total_discount`
                     FROM `fee_payment_history`
                     WHERE MONTH(`date`) = ? AND YEAR(`date`) = ?";
            $paid_params = [$month, $year];

            if (!empty($branchID)) {
                $paid_sql .= " AND `branch_id` = ?";
                $paid_params[] = $branchID;
            }
            if (!empty($studentID)) {
                $paid_sql .= " AND `student_id` = ?";
                $paid_params[] = $studentID;
            }

            $paid_query = $this->db->query($paid_sql, $paid_params);
            $total_paid_month = 0;
            $total_discount_month = 0;
            if ($paid_query && $paid_query->num_rows() > 0) {
                $paid_row = $paid_query->row();
                $total_paid_month = floatval($paid_row->total_paid ?? 0);
                $total_discount_month = floatval($paid_row->total_discount ?? 0);
            }

            // 3️⃣ Total due = total allocated - payments collected this month
            $total_due_month = ($total_fee_month) - ($total_paid_month + $total_discount_month);

            $total_fee[]  = $total_fee_month;
            $total_paid[] = $total_paid_month + $total_discount_month; // total collected
            $total_due[]  = $total_due_month;
        }

        return [
            'total_fee'  => $total_fee,
            'total_paid' => $total_paid,
            'total_due'  => $total_due,
        ];
    }





/* student annual attendance charts */
/* student annual attendance charts */
public function getStudentAttendance($studentID = '')
{
    $total_present = array();
    $total_absent  = array();
    $total_late    = array();

    // Get student enroll ID
    $enroll = $this->db->select('id')
        ->where(['student_id' => $studentID, 'session_id' => get_session_id()])
        ->get('enroll')
        ->row();

    if (!$enroll) {
        return [
            'total_present' => array_fill(0, 12, 0),
            'total_absent'  => array_fill(0, 12, 0),
            'total_late'    => array_fill(0, 12, 0),
        ];
    }

    $enrollID = $enroll->id;

    // LOOP MONTHS
    for ($month = 1; $month <= 12; $month++) {

        // Get all attendance for the month
        $query = $this->db->query("
            SELECT 
                DATE(date) AS att_date,
                status_morning,
                status_afternoon
            FROM student_attendance
            WHERE MONTH(date) = {$this->db->escape($month)}
            AND YEAR(date) = YEAR(CURDATE())
            AND enroll_id = {$this->db->escape($enrollID)}
            GROUP BY DATE(date)
        ");

        $present = 0;
        $absent  = 0;
        $late    = 0;

        foreach ($query->result_array() as $row) {

            $m = $row['status_morning'];
            $a = $row['status_afternoon'];

            /** MORNING COUNT **/
            if ($m == 'P') $present++;
            elseif ($m == 'A') $absent++;
            elseif ($m == 'L') $late++;

            /** AFTERNOON COUNT **/
            if ($a == 'P') $present++;
            elseif ($a == 'A') $absent++;
            elseif ($a == 'L') $late++;
        }

        // Save monthly totals
        $total_present[] = $present;
        $total_absent[]  = $absent;
        $total_late[]    = $late;
    }

    return [
        'total_present' => $total_present,
        'total_absent'  => $total_absent,
        'total_late'    => $total_late
    ];
}



    public function get_monthly_attachments($id = '')
    {
        $branchID = get_loggedin_branch_id();
        $classID = $this->db->select('class_id')->where('student_id', $id)->get('enroll')->row()->class_id;
        $this->db->select('id');
        $this->db->from('attachments');
        $this->db->where("date BETWEEN DATE_SUB(CURDATE() ,INTERVAL 1 MONTH) AND CURDATE() AND (class_id = " . $this->db->escape($classID) . " OR class_id = 'unfiltered') AND branch_id = " . $this->db->escape($branchID));
        return $this->db->get()->num_rows();
    }

    /* annual academic fees summary charts */
    public function getWeekendAttendance($branchID = '')
    {
        $days = array();
        $employee_att = array();
        $student_att = array();
        $now = new DateTime("6 days ago");
        $interval = new DateInterval('P1D'); // 1 Day interval
        $period = new DatePeriod($now, $interval, 6); // 7 Days
        foreach ($period as $day) {
            $days[] = $day->format("d-M");
            $this->db->select('id');
            if (!empty($branchID)) {
                $this->db->where('branch_id', $branchID);
            }

            $this->db->where('date', $day->format('Y-m-d'));
            $this->db->group_start(); // open parentheses
            $this->db->where('status_morning', 'P');
            $this->db->or_where('status_morning', 'L');
            $this->db->or_where('status_afternoon', 'P');
            $this->db->or_where('status_afternoon', 'L');
            $this->db->group_end(); // close parentheses

            $student_att[]['y'] = $this->db->get('student_attendance')->num_rows();


            $this->db->select('id');
            if (!empty($branchID)) {
                $this->db->where('branch_id', $branchID);
            }

            $this->db->where('date = "' . $day->format('Y-m-d') . '" AND (status = "P" OR status = "L")');
            $employee_att[]['y'] = $this->db->get('staff_attendance')->num_rows();
        }
        return array(
            'days' => $days,
            'employee_att' => $employee_att,
            'student_att' => $student_att,
        );
    }


    public function getDaymonth($branchID = '')
    {
        $monthdays = array();
        $employee_att = array();
        $total_fee_days = array();
        $now = new DateTime("6 days ago");
        $interval = new DateInterval('P1D'); // 1 Day interval
        $period = new DatePeriod($now, $interval, 12); // 7 Days
        foreach ($period as $day) {
            $monthdays[] = $day->format("d-M");
            //$this->db->select('SUM(amount) as total_payment');
            if (!empty($branchID)) {
                $this->db->where('branch_id', $branchID);
            }

            //  $this->db->where('date = "' . $day->format('Y-m-d') . '" AND (pay_via = "1" OR pay_via = "2" OR pay_via = "3"  OR pay_via = "4"  OR pay_via = "5"  OR pay_via = "6"  OR pay_via = "7"  OR pay_via = "8"  OR pay_via = "9"  OR pay_via = "10")');

            //$total_fee_da[]['y'] 
            //$this->db->get('fee_payment_history');



            $this->db->select('SUM(h.amount) as total_payment');
            $this->db->from('fee_payment_history as h');
            $this->db->join('fee_allocation as fa', 'h.allocation_id = fa.id', 'left');
            $this->db->where('h.date', $day->format('Y-m-d') . '" AND (h.allocation_id = fa.id)');
            //    $this->db->where('fa.session_id', $this->db->escape(get_session_id()));
            // $this->db->where('h.date', $day->format('Y-m-d'));
            //$this->db->where('h.allocation_id', 'fa.id');
            $total_fee_days[]['y'] = $this->db->get()->row()->total_payment;

            //   // $this->db->select('id');
            //     if (!empty($branchID)) {
            //         $this->db->where('branch_id', $branchID);
            //     }

            // $this->db->where('date = "' . $day->format('Y-m-d') . '" AND (status = "P" OR status = "L")');
            // $employee_att[]['y'] = $this->db->get('staff_attendance')->num_rows();
        }
        return array(
            'monthdays' => $monthdays,
            'employee_att' => $employee_att,
            'total_fee_days' => $total_fee_days,
        );
    }

    /* monthly academic cash book transaction charts */
    public function getIncomeVsExpense($branchID = '')
    {
        $query = "SELECT IFNULL(SUM(dr),0) as dr, IFNULL(SUM(cr),0) as cr FROM transactions WHERE month(DATE) = MONTH(now()) AND year(DATE) = YEAR(now())";
        if (!empty($branchID)) {
            $query .= " AND branch_id = " . $this->db->escape($branchID);
        }
        $r = $this->db->query($query)->row_array();
        return array(['name' => translate("expense"), 'value' => $r['dr']], ['name' => translate("income"), 'value' => $r['cr']]);
    }

    /* total academic students strength classes divided into charts */
    public function getStudentByClass($branchID = '')
    {
        $this->db->select('IFNULL(COUNT(e.student_id), 0) as total_student, c.name as class_name');
        $this->db->from('enroll as e');
        $this->db->join('class as c', 'c.id = e.class_id', 'inner');
        $this->db->group_by('e.class_id');
        if (!empty($branchID)) {
            $this->db->where('e.branch_id', $branchID);
        }

        $query = $this->db->get();
        $data = array();
        if ($query->num_rows() > 0) {
            $students = $query->result();
            foreach ($students as $row) {
                $data[] = ['value' => floatval($row->total_student), 'name' => $row->class_name];
            }
        } else {
            $data[] = ['value' => 0, 'name' => translate('not_found_anything')];
        }
        return $data;
    }

    public function get_total_student($branchID = '')
    {
        $sessionID = get_session_id();
        $this->db->select('IFNULL(COUNT(enroll.id), 0) as total_student');
        $this->db->from('enroll');
        $this->db->join('student', 'student.id = enroll.student_id', 'inner');
        $this->db->where('enroll.session_id', $sessionID);
        if (!empty($branchID)) {
            $this->db->where('enroll.branch_id', $branchID);
        }
        return $this->db->get()->row()->total_student;
    }


    public function get_total_current_student($branchID = '')
    {
        $sessionID = get_session_id();
        $this->db->select('IFNULL(COUNT(enroll.id), 0) as total_current_student');
        $this->db->from('enroll');
        $this->db->join('student', 'student.id = enroll.student_id', 'inner');
        $this->db->where('enroll.session_id', $sessionID);
        if (!empty($branchID)) {
            $this->db->where('enroll.branch_id', $branchID);
        }

        return $this->db->get()->row()->total_current_student;
    }



    public function get_total_alumni_student($branchID = '')
    {

        $this->db->select('IFNULL(COUNT(enroll.id), 0) as total_alumni_student');
        $this->db->from('enroll');
        $this->db->join('student', 'student.id = enroll.student_id', 'inner');
        $this->db->where('enroll.is_alumni = 1 AND student.id = enroll.student_id');
        $this->db->where('enroll.branch_id', $branchID);


        return $this->db->get()->row()->total_alumni_student;
    }



    public function get_total_deactive_student($role = '')
    {
        $this->db->select('COUNT(active) as total_deactive_student');
        $this->db->from('login_credential');
        $this->db->where('login_credential.role = 7 AND login_credential.active = 0');


        if (!empty($role)) {
            $this->db->where('login_credential.role', 7);
        }
        return $this->db->get()->row()->total_deactive_student;
    }




    public function getMonthlyAdmission($branchID = '')
    {
        $this->db->select('s.id');
        $this->db->from('student as s');
        $this->db->join('enroll as e', 'e.student_id = s.id', 'inner');
        $this->db->where('s.admission_date BETWEEN DATE_SUB(CURDATE() ,INTERVAL 1 MONTH) AND CURDATE()');
        if (!empty($branchID)) {
            $this->db->where('e.branch_id', $branchID);
        }
        return $this->db->get()->num_rows();
    }

    public function getVoucher($branchID = '')
    {
        $this->db->select('id');
        if (!empty($branchID)) {
            $this->db->where('branch_id', $branchID);
        }
        $this->db->where('date BETWEEN DATE_SUB(CURDATE() ,INTERVAL 1 MONTH) AND CURDATE()');
        return $this->db->get('transactions')->num_rows();
    }

    public function get_transport_route($branchID = '')
    {
        if (!empty($branchID)) {
            $this->db->where('branch_id', $branchID);
        }
        return $this->db->get('transport_route')->num_rows();
    }


    public function languageShortCodes($lang = '')
    {
        $codes = array(
            'english' => 'en',
            'bengali' => 'bn',
            'arabic' => 'ar',
            'french' => 'fr',
            'hindi' => 'hi',
            'indonesian' => 'id',
            'italian' => 'it',
            'japanese' => 'ja',
            'korean' => 'ko',
            'portuguese' => 'pt',
            'thai' => 'th',
            'turkish' => 'tr',
            'urdu' => 'ur',
            'chinese' => 'zh',
            'afrikaans' => 'af',
            'german' => 'de',
            'nepali' => 'ne',
            'russian' => 'ru',
            'danish' => 'da',
            'armenian' => 'hy',
            'georgian' => 'ka',
            'marathi' => 'mr',
            'malay' => 'ms',
            'tamil' => 'ta',
            'telugu' => 'te',
            'swedish' => 'sv',
            'dutch' => 'nl',
            'greek' => 'el',
            'spanish' => 'es',
            'punjabi' => 'pa',
        );
        return empty($codes[$lang]) ? '' : $codes[$lang];
    }
}
