<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Exam_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getExamByID($id = null)
    {
        $sql = "SELECT `e`.*, `exam_term`.`name` as `term_name`, `b`.`name` as `branch_name` FROM `exam` as `e` INNER JOIN `branch` as `b` ON `b`.`id` = `e`.`branch_id` LEFT JOIN `exam_term` ON `exam_term`.`id` = `e`.`term_id` WHERE `e`.`id` = {$this->db->escape($id)}";
        return $this->db->query($sql)->row();
    }

    public function searchExamPrincipalStudentsByRank($class_ID = '', $section_ID = '', $session_ID = '', $exam_ID = '', $branch_ID = '')
    {
        $is_alumni = 0;

        $this->db->select('
        e.*,
        CONCAT_WS(" ", first_name, last_name) as fullname,
        register_no,
        c.name as class_name,
        se.name as section_name,
        princi.comment as principal_comment,
        cma_principal_comment.rank,
        cma_principal_comment.principal_comment,
        cma_principal_comment.teacher_comment,
        cma_principal_comment.resumption_date,
        behav.teachers_comment
    ');
        $this->db->from('enroll as e');
        $this->db->join('student as s', 'e.student_id = s.id', 'inner');
        $this->db->join('mark as mrk', 'e.student_id = mrk.student_id', 'left');
        $this->db->join('login_credential as l', 'l.user_id = mrk.student_id and l.role = 7 and l.active = 1', 'inner');
        $this->db->join('class as c', 'e.class_id = c.id', 'left');
        $this->db->join('exam as ex', 'ex.id = mrk.exam_id', 'inner');
        $this->db->join('exam_principal_comment as princi', 'princi.id = e.branch_id', 'left');
        $this->db->join('section as se', 'e.section_id = se.id', 'left');
        $this->db->join('cma_principal_comment', 'cma_principal_comment.enroll_id = e.id AND cma_principal_comment.exam_id = ' . $this->db->escape($exam_ID), 'left');
        $this->db->join('cmas_behaviour as behav', 'behav.enroll_id = e.id AND behav.exam_id = ' . $this->db->escape($exam_ID), 'left');

        $this->db->where('e.class_id', $class_ID);
        $this->db->where('e.section_id', $section_ID);
        $this->db->where('e.branch_id', $branch_ID);
        $this->db->where('e.is_alumni', $is_alumni);
        $this->db->where('e.session_id', $session_ID);
        $this->db->where('l.active', 1);

        if (is_array($exam_ID)) {
            $this->db->where_in('mrk.exam_id', $exam_ID);
        } else {
            $this->db->where('mrk.exam_id', $exam_ID);
        }

        $this->db->group_by('mrk.student_id');
        $this->db->order_by('cma_principal_comment.rank', 'ASC');

        return $this->db->get()->result();
    }





    public function searchExamClassStudentsByRank($class_ID = '', $session_ID = '', $exam_ID = '', $branch_id = '')
    {

        $is_alumni = 0;
        $this->db->select('e.*,CONCAT_WS(" ",first_name, last_name) as fullname,register_no,c.name as class_name,s.photo,se.name as class_name,exam_class_rank.rank');
        $this->db->from('enroll as e');
        $this->db->join('student as s', 'e.student_id = s.id', 'inner');
        $this->db->join('mark as mrk', 'e.student_id=mrk.student_id', 'left');
        $this->db->join('login_credential as l', 'l.user_id = s.id and l.role = 7 and l.active = 1', 'inner');
        $this->db->join('class as c', 'e.class_id = c.id', 'left');
        $this->db->join('exam as ex', 'ex.id = mrk.exam_id', 'inner');
        $this->db->join('section as se', 'e.section_id=se.id', 'left');
        $this->db->join('exam_class_rank', 'exam_class_rank.enroll_id=e.id and exam_class_rank.exam_id = ' . $this->db->escape($exam_ID), 'left');
        $this->db->where('e.class_id', $class_ID);
        $this->db->where('e.branch_id', $branch_id);
        $this->db->where('e.session_id', $session_ID);
        $this->db->where('e.is_alumni', $is_alumni);
        $this->db->where_in('mrk.exam_id', $exam_ID);
        $this->db->order_by('mrk.exam_id', 'ASC');
        $this->db->group_by('mrk.student_id');
        $this->db->where('mrk.class_id', $class_ID);

        return $this->db->get()->result();
    }



    public function searchExamSectionStudentsByRank($class_ID = '', $section_ID = '', $session_ID = '', $exam_ID = '', $branch_id = '')
    {
        $is_alumni = 0;
        $this->db->select('e.*,CONCAT_WS(" ",first_name, last_name) as fullname,register_no,c.name as class_name,se.name as section_name,exam_section_rank.rank');
        $this->db->from('enroll as e');
        $this->db->join('student as s', 'e.student_id = s.id', 'inner');
        $this->db->join('login_credential as l', 'l.user_id = s.id and l.role = 7 and l.active = 1', 'inner');
        $this->db->join('class as c', 'e.class_id = c.id', 'left');
        $this->db->join('section as se', 'e.section_id=se.id', 'left');
        $this->db->join('exam_section_rank', 'exam_section_rank.enroll_id=e.id and exam_section_rank.exam_id = ' . $this->db->escape($exam_ID), 'left');
        $this->db->where('e.class_id', $class_ID);
        if (!empty($section_ID)) {
            $this->db->where('e.section_id', $section_ID);
        }
        $this->db->where('e.branch_id', $branch_id);
        $this->db->where('e.session_id', $session_ID);
        $this->db->where('e.is_alumni', $is_alumni);
        $this->db->order_by('exam_section_rank.rank', 'ASC');
        $this->db->where('l.active', 1);
        $this->db->group_by('s.id');
        return $this->db->get()->result();
    }


    public function getExamList()
    {
        $this->db->select('e.*,b.name as branch_name');
        $this->db->from('exam as e');
        $this->db->join('branch as b', 'b.id = e.branch_id', 'left');
        if (!is_superadmin_loggedin()) {
            $this->db->where('e.branch_id', get_loggedin_branch_id());
        }
        $this->db->where('e.session_id', get_session_id());
        $this->db->order_by('e.id', 'asc');
        return $this->db->get()->result_array();
    }

    public function exam_save($data)
    {
        $arrayExam = array(
            'name' => $data['name'],
            'branch_id' => $this->application_model->get_branch_id(),
            'term_id' => $data['term_id'],
            'type_id' => $data['type_id'],
            'mark_distribution' => json_encode($data['mark_distribution']),
            'remark' => $data['remark'],
            'session_id' => get_session_id(),
            'status' => (isset($_POST['exam_publish']) ? 1 : 0),
            'publish_result' => 0,
        );
        if (!isset($data['exam_id'])) {
            $this->db->insert('exam', $arrayExam);
        } else {
            $this->db->where('id', $data['exam_id']);
            $this->db->update('exam', $arrayExam);
        }
    }


    public function PrincipalCommentSave($post)
    {
        $arrayPrincipal = array(
            'comment' => $post['comment'],
            'branch_id' => $this->application_model->get_branch_id(),
            'session' => get_session_id(),
        );
        if (!isset($post['comment_id'])) {
            $this->db->insert('exam_principal_comment', $arrayPrincipal);
        } else {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('id', $post['comment_id']);
            $this->db->update('exam_principal_comment', $arrayPrincipal);
        }
    }

    public function termSave($post)
    {
        $arrayTerm = array(
            'name' => $post['term_name'],
            'branch_id' => $this->application_model->get_branch_id(),
            'session_id' => get_session_id(),
        );
        if (!isset($post['term_id'])) {
            $this->db->insert('exam_term', $arrayTerm);
        } else {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('id', $post['term_id']);
            $this->db->update('exam_term', $arrayTerm);
        }
    }

    public function hallSave($post)
    {
        $arrayHall = array(
            'hall_no' => $post['hall_no'],
            'seats' => $post['no_of_seats'],
            'branch_id' => $this->application_model->get_branch_id(),
        );
        if (!isset($post['hall_id'])) {
            $this->db->insert('exam_hall', $arrayHall);
        } else {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('id', $post['hall_id']);
            $this->db->update('exam_hall', $arrayHall);
        }
    }

    public function gradeSave($data)
    {
        $arrayData = array(
            'branch_id' => $this->application_model->get_branch_id(),
            'name' => $data['name'],
            'grade_point' => $data['grade_point'],
            'lower_mark' => $data['lower_mark'],
            'upper_mark' => $data['upper_mark'],
            'remark' => $data['remark'],
        );
        // posted all data XSS filtering
        if (!isset($data['grade_id'])) {
            $this->db->insert('grade', $arrayData);
        } else {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('id', $data['grade_id']);
            $this->db->update('grade', $arrayData);
        }
    }



public function getExamClassAverage($examID, $sessionID, $subjectID = '')
{
    $this->db->select('m.mark as get_mark, IFNULL(m.subject_status, "present") as subject_status');
    $this->db->from('mark as m');

    if (is_array($examID)) {
        $this->db->where_in('m.exam_id', $examID);
    } else {
        $this->db->where('m.exam_id', $examID);
    }

    $this->db->where('m.session_id', $sessionID);
    $this->db->where('m.subject_id', $subjectID);

    $getMarksList = $this->db->get()->result_array();
    $grand_obtain_marks = 0;
    $valid_students = 0; // only count students who actually have marks

    foreach ($getMarksList as $row) {
        // Skip if student was absent or subject not offered
        if ($row['subject_status'] === 'absent' || $row['subject_status'] === 'not_offered') {
            continue;
        }

        $obtainedMark = !empty($row['get_mark']) ? json_decode($row['get_mark'], true) : [];
        $total_obtain_marks = 0;

        if (is_array($obtainedMark)) {
            foreach ($obtainedMark as $val) {
                $total_obtain_marks += floatval($val);
            }
        }

        $grand_obtain_marks += $total_obtain_marks;
        $valid_students++; // increment only for valid students
    }

    // Calculate average using only valid students
    $grand_percentage = ($valid_students > 0) ? ($grand_obtain_marks / $valid_students) : 0;

    return number_format($grand_percentage, 2, '.', '');
}






 public function getSubjectPosition($classID = '', $sectionID = '', $examID = [], $sessionID = '', $subjectID = '', $mark = 0)
{
    if (!is_array($examID)) {
        $examID = [$examID];
    }

    $enroll = $this->db
        ->select('student_id as id')
        ->where('class_id', $classID)
        ->where('section_id', $sectionID)
        ->where('session_id', $sessionID)
        ->get('enroll')
        ->result();

    $student_marks = [];

    foreach ($enroll as $student) {
        $marks = $this->db
            ->select('m.mark as get_mark, IFNULL(m.subject_status, "present") as subject_status')
            ->from('mark as m')
            ->where_in('m.exam_id', $examID)
            ->where('m.student_id', $student->id)
            ->where('m.session_id', $sessionID)
            ->where('m.subject_id', $subjectID)
            ->get()
            ->result_array();

        $total_marks = 0;

        if (empty($marks)) {
            $student_marks[$student->id] = 0;
            continue;
        }

        foreach ($marks as $row) {
            if ($row['subject_status'] === 'absent' || $row['subject_status'] === 'not_offered') {
                continue;
            }

            $decoded = json_decode($row['get_mark'] ?? '[]', true);
            if (!is_array($decoded)) $decoded = [];

            foreach ($decoded as $value) {
                $total_marks += floatval($value);
            }
        }

        $student_marks[$student->id] = $total_marks;
    }

    arsort($student_marks);

    $rank = 'N/A';
    $position = 1;
    $prevScore = null;
    $actualRank = 1;
    $tolerance = 0.001;

    foreach ($student_marks as $student_id => $total) {
        if ($prevScore !== null && $total < $prevScore) {
            $position = $actualRank;
        }

        if (abs($total - $mark) < $tolerance) {
            $rank = $this->ordinal($position);
            break;
        }

        $prevScore = $total;
        $actualRank++;
    }

    return $rank;
}

private function ordinal($number)
{
    $ends = ['th', 'st', 'nd', 'rd', 'th', 'th', 'th', 'th', 'th', 'th'];
    if ((($number % 100) >= 11) && (($number % 100) <= 13)) {
        return $number . 'th';
    } else {
        return $number . $ends[$number % 10];
    }
}






    public function getExam_grade($mark, $branch_id)
    {
        $this->db->where('branch_id', $branch_id);
        $query = $this->db->get('grade');
        $grades = $query->result_array();
        foreach ($grades as $row) {
            if ($mark >= $row['lower_mark'] && $mark <= $row['upper_mark']) {
                return $row;
            }
        }
    }

    public function getSubjectList($examID, $classID, $sectionID, $sessionID)
    {
        $branchID = $this->application_model->get_branch_id();
        $this->db->select('t.*,s.name as subject_name');
        $this->db->from('timetable_exam as t');
        $this->db->join('subject as s', 's.id = t.subject_id', 'inner');
        $this->db->where('t.exam_id', $examID);
        $this->db->where('t.class_id', $classID);
        $this->db->where('t.section_id', $sectionID);
        $this->db->where('t.session_id', $sessionID);
        $this->db->where('t.branch_id', $branchID);
        $this->db->group_by('t.subject_id');
        return $this->db->get()->result_array();
    }


        public function getClassSubjectList($examID, $classID, $sessionID)
    {
        $branchID = $this->application_model->get_branch_id();
        $this->db->select('t.*,s.name as subject_name');
        $this->db->from('timetable_exam as t');
        $this->db->join('subject as s', 's.id = t.subject_id', 'inner');
        $this->db->where('t.exam_id', $examID);
        $this->db->where('t.class_id', $classID);
        $this->db->where('t.session_id', $sessionID);
        $this->db->where('t.branch_id', $branchID);
        $this->db->group_by('t.subject_id');
        return $this->db->get()->result_array();
    }

    public function getTimetableDetail($classID, $sectionID, $examID, $subjectID)
    {
        $this->db->select('timetable_exam.mark_distribution');
        $this->db->where('class_id', $classID);
        $this->db->where('section_id', $sectionID);
        $this->db->where('exam_id', $examID);
        $this->db->where('subject_id', $subjectID);
        $this->db->where('session_id', get_session_id());
        return $this->db->get('timetable_exam')->row_array();
    }

public function getMarkAndStudent($branchID, $classID, $sectionID, $examID, $subjectID)
{
    $is_alumni = 0;
    $sessionID = get_session_id();

    $this->db->select('
        en.*,
        st.first_name,
        st.last_name,
        st.register_no,
        st.category_id,
        m.mark as get_mark,
        IFNULL(m.subject_status, "present") as subject_status,
        subject.name as subject_name
    ');
    $this->db->from('enroll as en');
    $this->db->join('student as st', 'st.id = en.student_id', 'inner');
    $this->db->join('login_credential as l', 'l.user_id = st.id AND l.role = 7 AND l.active = 1', 'inner');

    // Safe LEFT JOIN with multiple conditions
    $joinMark = "m.student_id = en.student_id
                 AND m.exam_id = " . $this->db->escape($examID) . "
                 AND m.subject_id = " . $this->db->escape($subjectID);
    $this->db->join('mark as m', $joinMark, 'left');

    $this->db->join('subject', 'subject.id = ' . $this->db->escape($subjectID), 'left');

    $this->db->where('en.class_id', $classID);
    $this->db->where('en.section_id', $sectionID);
    $this->db->where('en.branch_id', $branchID);
    $this->db->where('en.session_id', $sessionID);
    $this->db->where('en.is_alumni', $is_alumni);
    $this->db->order_by('en.roll', 'ASC');

    $result = $this->db->get()->result_array();

    // Handle marks for absent / not offered
    foreach ($result as &$row) {
        if ($row['subject_status'] == 'absent') {
            // absent = mark 0
            if (!empty($row['get_mark'])) {
                $marks = json_decode($row['get_mark'], true);
                foreach ($marks as $k => $v) {
                    $marks[$k] = 0;
                }
                $row['get_mark'] = json_encode($marks);
            }
        } elseif ($row['subject_status'] == 'not_offered') {
            // not offered = no marks
            $row['get_mark'] = null;
        }
    }

    return $result;
}



public function getStudentReportCard($studentID, $examID, $sessionID, $classID = '', $sectionID = '')
{
    // --------------------------------------------------
    // 1. STUDENT DETAILS
    // --------------------------------------------------
    $this->db->select('
        s.*,
        CONCAT_WS(" ", s.first_name, s.last_name) AS name,
        s.photo,

        e.id AS enrollID,
        e.branch_id,
        e.session_id,
        e.class_id,
        e.section_id,
        e.is_alumni,

        c.name AS class,
        se.name AS section,
        sc.name AS category,

        IFNULL(p.father_name, "N/A") AS father_name,
        IFNULL(p.mother_name, "N/A") AS mother_name,

        br.name AS institute_name,
        br.email AS institute_email,
        br.address AS institute_address,
        br.mobileno AS institute_mobile_no,

        attend.total_days AS student_days,
        attend.total_present AS student_present,
        attend.total_absent AS student_absent,
        attend.total_late AS student_late,

        attend.total_days AS days,
        attend.total_present AS attendance,

        beha.cmaskill1 AS behav_cmaskill1,
        beha.cmaskill2 AS behav_cmaskill2,
        beha.cmaskill3 AS behav_cmaskill3,
        beha.cmaskill4 AS behav_cmaskill4,
        beha.cmaskill5 AS behav_cmaskill5,
        beha.cmaskill6 AS behav_cmaskill6,

        beha.cmabehav1 AS behav_cmabehav1,
        beha.cmabehav2 AS behav_cmabehav2,
        beha.cmabehav3 AS behav_cmabehav3,
        beha.cmabehav4 AS behav_cmabehav4,
        beha.cmabehav5 AS behav_cmabehav5,
        beha.cmabehav6 AS behav_cmabehav6,

        beha.behavcontd1 AS behav_behavcontd1,
        beha.behavcontd2 AS behav_behavcontd2,
        beha.behavcontd3 AS behav_behavcontd3,
        beha.teachers_comment AS behav_teachers_comment,

        classrank.rank AS clrank,
        sectionrank.rank AS secrank,

        commprincipal.teacher_comment AS teacher_comment,
        commprincipal.resumption_date AS resumption_date,
        commcreate.comment AS principal_comment,

        l.username AS student_username
    ');

    $this->db->from('enroll as e');
    $this->db->join('student as s', 'e.student_id = s.id', 'inner');
    $this->db->join('class as c', 'e.class_id = c.id', 'left');
    $this->db->join('section as se', 'e.section_id = se.id', 'left');
    $this->db->join('student_category as sc', 's.category_id = sc.id', 'left');
    $this->db->join('parent as p', 'p.id = s.parent_id', 'left');
    $this->db->join('branch as br', 'br.id = e.branch_id', 'left');

    $this->db->join(
        'cmas_behaviour as beha',
        'e.id = beha.enroll_id AND beha.exam_id = ' . $this->db->escape($examID),
        'left'
    );

    // Attendance subquery
    $attendanceSubQuery = "
        (
            SELECT
                sa.enroll_id,
                COUNT(DISTINCT DATE(sa.date)) * 2 AS total_days,
                SUM(
                    (sa.status_morning = 'P') + (sa.status_morning = 'L') +
                    (sa.status_afternoon = 'P') + (sa.status_afternoon = 'L')
                ) AS total_present,
                SUM((sa.status_morning = 'A') + (sa.status_afternoon = 'A')) AS total_absent,
                SUM((sa.status_morning = 'L') + (sa.status_afternoon = 'L')) AS total_late
            FROM student_attendance sa
            INNER JOIN enroll en ON en.id = sa.enroll_id
            WHERE en.session_id = " . $this->db->escape($sessionID) . "
            GROUP BY sa.enroll_id
        ) AS attend
    ";

    $this->db->join($attendanceSubQuery, 'attend.enroll_id = e.id', 'left');

    $this->db->join('login_credential as l', 'l.user_id = s.id AND l.role = 7 AND l.active = 1', 'inner');

    $this->db->join(
        'exam_class_rank as classrank',
        'classrank.enroll_id = e.id AND classrank.exam_id = ' . $this->db->escape($examID),
        'left'
    );
    $this->db->join(
        'exam_section_rank as sectionrank',
        'sectionrank.enroll_id = e.id AND sectionrank.exam_id = ' . $this->db->escape($examID),
        'left'
    );

    $this->db->join(
        'cma_principal_comment as commprincipal',
        'commprincipal.enroll_id = e.id AND commprincipal.exam_id = ' . $this->db->escape($examID),
        'left'
    );
    $this->db->join(
        'exam_principal_comment as commcreate',
        'commprincipal.principal_comment = commcreate.id',
        'left'
    );

    $this->db->where('s.id', $studentID);
    if (!empty($classID)) $this->db->where('e.class_id', $classID);
    if (!empty($sectionID)) $this->db->where('e.section_id', $sectionID);

    $student = $this->db->get()->row_array();
    if (!$student) return ['student' => null, 'exams' => []];

    if (!empty($student['resumption_date'])) {
        $student['resumption_date'] = date('M d Y', strtotime($student['resumption_date']));
    }

    // --------------------------------------------------
    // 2. MARKS (SUBJECT_STATUS BASED)
    // --------------------------------------------------
    $this->db->select('
        m.mark AS get_mark,
        m.subject_status,
        subject.name AS subject_name,
        te.mark_distribution,
        m.subject_id
    ');

    $this->db->from('mark as m');
    $this->db->join('subject', 'subject.id = m.subject_id', 'left');
    $this->db->join(
        'timetable_exam as te',
        'te.exam_id = m.exam_id
         AND te.class_id = m.class_id
         AND te.section_id = m.section_id
         AND te.subject_id = m.subject_id',
        'left'
    );

    $this->db->where([
        'm.exam_id'    => $examID,
        'm.student_id' => $studentID,
        'm.session_id' => $sessionID
    ]);

    if (!empty($classID)) $this->db->where('m.class_id', $classID);
    if (!empty($sectionID)) $this->db->where('m.section_id', $sectionID);

    // 🔥 REMOVE NOT OFFERED SUBJECTS COMPLETELY
    $this->db->where('m.subject_status !=', 'not_offered');

    $this->db->group_by('m.subject_id');
    $this->db->order_by('subject.id', 'ASC');

    $marks = $this->db->get()->result_array();

    return [
        'student' => $student,
        'exams'   => $marks
    ];
}







public function AdmingetStudentReportCard($studentID, $examID, $sessionID, $classID = '', $sectionID = '')
{
    $result = [];
    $is_alumni = 0;

    /* --------------------------------------------------------
     * ATTENDANCE SUBQUERY (MUST COME FIRST)
     * -------------------------------------------------------- */
    $attendanceSubQuery = "
        (
            SELECT
                sa.enroll_id,
                COUNT(DISTINCT DATE(sa.date)) * 2 AS total_days,
                SUM(
                    (sa.status_morning IN ('P','L')) +
                    (sa.status_afternoon IN ('P','L'))
                ) AS total_present,
                SUM((sa.status_morning = 'A') + (sa.status_afternoon = 'A')) AS total_absent,
                SUM((sa.status_morning = 'L') + (sa.status_afternoon = 'L')) AS total_late
            FROM student_attendance sa
            INNER JOIN enroll en ON en.id = sa.enroll_id
            WHERE en.session_id = " . $this->db->escape($sessionID) . "
            GROUP BY sa.enroll_id
        ) AS attend
    ";

    /* --------------------------------------------------------
     * STUDENT DETAILS
     * -------------------------------------------------------- */
    $this->db->select("
        s.*, CONCAT_WS(' ', s.first_name, s.last_name) AS name, s.photo,
        e.id AS enrollID, e.roll, e.branch_id, e.session_id, e.class_id, e.section_id, e.is_alumni,
        c.name AS class, se.name AS section,
        sc.name AS category,
        IFNULL(p.father_name,'N/A') AS father_name,
        IFNULL(p.mother_name,'N/A') AS mother_name,
        br.name AS institute_name, br.email AS institute_email,
        br.address AS institute_address, br.mobileno AS institute_mobile_no,

        attend.total_days AS student_days,
        attend.total_present AS student_present,
        attend.total_absent AS student_absent,
        attend.total_late AS student_late,

         beha.cmaskill1 AS behav_cmaskill1,
        beha.cmaskill2 AS behav_cmaskill2,
        beha.cmaskill3 AS behav_cmaskill3,
        beha.cmaskill4 AS behav_cmaskill4,
        beha.cmaskill5 AS behav_cmaskill5,
        beha.cmaskill6 AS behav_cmaskill6,

        beha.cmabehav1 AS behav_cmabehav1,
        beha.cmabehav2 AS behav_cmabehav2,
        beha.cmabehav3 AS behav_cmabehav3,
        beha.cmabehav4 AS behav_cmabehav4,
        beha.cmabehav5 AS behav_cmabehav5,
        beha.cmabehav6 AS behav_cmabehav6,

        beha.behavcontd1 AS behav_behavcontd1,
        beha.behavcontd2 AS behav_behavcontd2,
        beha.behavcontd3 AS behav_behavcontd3,
        beha.teachers_comment AS behav_teachers_comment,

        commprincipal.teacher_comment AS teacher_comment,
        commprincipal.resumption_date AS resumption_date,
        commcreate.comment AS principal_comment,
        
        classrank.rank AS clrank,
        sectionrank.rank AS secrank,
        l.username AS student_username
    ");

    $this->db->from('enroll AS e');
    $this->db->join('student AS s', 's.id = e.student_id', 'inner');
    $this->db->join('class AS c', 'c.id = e.class_id', 'left');
    $this->db->join('section AS se', 'se.id = e.section_id', 'left');
    $this->db->join('student_category AS sc', 'sc.id = s.category_id', 'left');
    $this->db->join('parent AS p', 'p.id = s.parent_id', 'left');
    $this->db->join('branch AS br', 'br.id = e.branch_id', 'left');
    $this->db->join('cmas_behaviour AS beha', 'beha.enroll_id = e.id AND beha.exam_id = '.$this->db->escape($examID), 'left');
    $this->db->join('login_credential AS l', 'l.user_id = s.id AND l.role = 7 AND l.active = 1', 'inner');
    $this->db->join('exam_class_rank AS classrank', 'classrank.enroll_id = e.id AND classrank.exam_id = '.$this->db->escape($examID), 'left');
    $this->db->join('exam_section_rank AS sectionrank', 'sectionrank.enroll_id = e.id AND sectionrank.exam_id = '.$this->db->escape($examID), 'left');
    $this->db->join('cma_principal_comment AS commprincipal', 'commprincipal.enroll_id = e.id AND commprincipal.exam_id = '.$this->db->escape($examID), 'left');
    $this->db->join('exam_principal_comment AS commcreate', 'commprincipal.principal_comment = commcreate.id', 'left');
    $this->db->join($attendanceSubQuery, 'attend.enroll_id = e.id', 'left');

    $this->db->where([
        'e.student_id' => $studentID,
        'e.session_id' => $sessionID,
        'e.is_alumni'  => $is_alumni
    ]);

    if (!empty($classID)) $this->db->where('e.class_id', $classID);
    if (!empty($sectionID)) $this->db->where('e.section_id', $sectionID);

    $result['student'] = $this->db->get()->row_array();

        if (!empty($student['resumption_date'])) {
        $student['resumption_date'] = date('M d Y', strtotime($student['resumption_date']));
    }

    /* --------------------------------------------------------
     * MARKS (subject_status LOGIC)
     * -------------------------------------------------------- */
    $this->db->select("
        m.mark AS get_mark,
        IFNULL(m.subject_status,'present') AS subject_status,
        subject.name AS subject_name,
        te.mark_distribution,
        m.subject_id
    ");

    $this->db->from('mark AS m');
    $this->db->join('subject', 'subject.id = m.subject_id', 'left');
    $this->db->join('timetable_exam AS te', "
        te.exam_id = m.exam_id AND
        te.class_id = m.class_id AND
        te.section_id = m.section_id AND
        te.subject_id = m.subject_id
    ", 'left');

    $this->db->where([
        'm.exam_id'     => $examID,
        'm.student_id' => $studentID,
        'm.session_id' => $sessionID,
        'm.class_id'   => $classID,
        'm.section_id' => $sectionID
    ]);

    // remove not_offered subjects completely
    $this->db->where('m.subject_status !=', 'not_offered');

    $rows = $this->db->get()->result_array();

    /* --------------------------------------------------------
     * TOTAL & GPA-READY CALCULATION
     * -------------------------------------------------------- */
    $totalMarks = 0;
    $subjectCount = 0;

    foreach ($rows as &$row) {

        if ($row['subject_status'] === 'absent') {
            $row['total_mark'] = 0;
            $subjectCount++;
            continue;
        }

        $marks = json_decode($row['get_mark'], true);
        $subjectTotal = 0;

        if (is_array($marks)) {
            foreach ($marks as $val) {
                $subjectTotal += (float) $val;
            }
        }

        $row['total_mark'] = $subjectTotal;
        $totalMarks += $subjectTotal;
        $subjectCount++;
    }

    $result['exam'] = $rows;
    $result['total_marks'] = $totalMarks;
    $result['subject_count'] = $subjectCount;

    return $result;
}



}
