<!doctype html>
<html>
<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width,initial-scale=1" name="viewport">
	<meta name="keywords" content="Champion Montessori Academy,School in Otor-Udu, School in Udu">
	<meta name="description" content="<?php echo $global_config['institute_name'] ?>">
	<meta name="author" content="<?php echo $global_config['institute_name'] ?>">

	<!-- Open Graph / Social Meta Tags -->
	<meta property="og:url" content="https://championsmontessoriacademy.com/champions">
	<meta property="og:type" content="website">
	<meta property="og:title" content="">
	<meta property="og:description" content="<?php echo $global_config['institute_name'] ?>">
	<meta property="og:image" content="<?php echo base_url('assets/images/ogimage.jpg');?>">

	<meta name="twitter:card" content="summary_large_image">
	<meta property="twitter:domain" content="championsmontessoriacademy.com">
	<meta property="twitter:url" content="https://championsmontessoriacademy.com/champions">
	<meta name="twitter:title" content="">
	<meta name="twitter:description" content="<?php echo $global_config['institute_name'] ?>">
	<meta name="twitter:image" content="<?php echo base_url('assets/images/ogimage.jpg');?>">

	<title><?php echo translate('login');?></title>
	<link rel="shortcut icon" href="<?php echo base_url('assets/images/favicon.png');?>">

	<!-- Fonts & CSS -->
	<link href="<?php echo is_secure('fonts.googleapis.com/css?family=Signika:300,400,600,700');?>" rel="stylesheet"> 
	<link rel="stylesheet" href="<?php echo base_url('assets/vendor/bootstrap/css/bootstrap.css');?>">
	<link rel="stylesheet" href="<?php echo base_url('assets/vendor/font-awesome/css/all.min.css'); ?>">
	<link rel="stylesheet" href="<?php echo base_url('assets/vendor/sweetalert/sweetalert-custom.css');?>">
	<link rel="stylesheet" href="<?php echo base_url('assets/login_page/css/mobile_responsive.css');?>">
	<link rel="stylesheet" href="<?php echo base_url('assets/login_page/css/style.css');?>">

	<script src="<?php echo base_url('assets/vendor/jquery/jquery.js');?>"></script>
	<script src="<?php echo base_url('assets/vendor/sweetalert/sweetalert.min.js');?>"></script>

	<style>
		.btn-block {
			width: 60%;
			margin: auto;
		}
		.password-toggle-wrapper {
			cursor: pointer;
			background: transparent;
			border: none;
			display: flex;
			align-items: center;
			justify-content: center;
		}
		.input-group-icon {
			position: relative;
		}
		@media (max-width: 768px) {
			.input-group-addon, .password-toggle-wrapper {
				padding: 0 8px;
			}
		}
	</style>

	<script type="text/javascript">
		var base_url = '<?php echo base_url() ?>';
	</script>
</head>

<body>
	<div class="auth-main">
		<div class="container">
			<div class="slideIn">
				<!-- Left Info/Image -->
				<div class="col-lg-4 col-lg-offset-1 col-md-4 col-md-offset-1 col-sm-12 col-xs-12 no-padding fitxt-center">
					<div class="image-area">
						<div class="content">
							<div class="btn_home">
								<a href="/"><i class="fa fa-home" aria-hidden="true"></i></a>
							</div>
							<div class="image-hader">
								<h2><?php echo translate('welcome_to');?></h2>
							</div>
							<div class="center img-hol-p">
								<img src="<?=$this->application_model->getBranchImage($branch_id, 'logo')?>" height="60" alt="School">
							</div>
							<div class="address">
								<p><?php echo $global_config['address'];?></p>
							</div>			
							<div class="f-social-links center">
								<a href="<?php echo $global_config['facebook_url'];?>" target="_blank"><span class="fab fa-facebook-f"></span></a>
								<a href="<?php echo $global_config['linkedin_url'];?>" target="_blank"><span class="fab fa-linkedin-in"></span></a>
								<a href="<?php echo $global_config['youtube_url'];?>" target="_blank"><span class="fab fa-youtube"></span></a>
							</div>
						</div>
					</div>
				</div>

				<!-- Login Form -->
				<div class="col-lg-6 col-lg-offset-right-1 col-md-6 col-md-offset-right-1 col-sm-12 col-xs-12 no-padding">
					<div class="sign-area">
						<div class="btn_home">
							<a href="/"><i class="fa fa-home" aria-hidden="true"></i></a>
						</div>
						<div class="sign-hader">
							<img src="<?=$this->application_model->getBranchImage($branch_id, 'logo')?>" height="54" alt="">
							<h2><?php echo $global_config['institute_name'];?></h2>
						</div>
						<?php echo form_open($this->uri->uri_string()); ?>

						<!-- Username -->
						<div class="form-group <?php if (form_error('email')) echo 'has-error'; ?>">
							<div class="input-group input-group-icon">
								<span class="input-group-addon">
									<span class="icon"><i class="far fa-user"></i></span>
								</span>
								<input type="text" class="form-control" style="  border-radius: 20px;" name="email" value="<?php echo set_value('email');?>" placeholder="<?php echo translate('username');?>" />
							</div>
							<span class="error"><?php echo form_error('email'); ?></span>
						</div>

					<!-- Password with Show/Hide -->
<div class="form-group <?php if (form_error('password')) echo 'has-error'; ?>" style="position: relative;">
    
    <!-- Left Lock Icon -->
    <span class="input-group-addon" style="position: absolute; background-color: #fffcfc00; border: #fffcfc00; left: 7px; top: 50%; transform: translateY(-50%); z-index: 2;">
        <i class="fas fa-unlock-alt"></i>
    </span>

    <!-- Password Input -->
    <input type="password" id="password" name="password" class="form-control input-rounded" 
           placeholder="<?php echo translate('password');?>" 
           style="padding-left: 35px; padding-right: 35px;" />

    <!-- Eye Icon on Right -->
    <span id="togglePassword" class="fas fa-eye" 
          style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); cursor: pointer; color: #999;"></span>

    <span class="error"><?php echo form_error('password'); ?></span>
</div>


						<!-- Remember / Forgot -->
						<div class="forgot-text">
							<div class="checkbox-replace">
								<label class="i-checks"><input type="checkbox" name="remember" id="remember"><i></i> <?php echo translate('remember');?></label>
							</div>
							<div class="">
								<a href="<?php echo base_url("{$this->authentication_model->getSegment(1)}forgot"); ?>"><?php echo translate('lose_your_password');?></a>
							</div>
						</div>

						<!-- Login Button -->
						<div class="form-group">
							<button type="submit" id="btn_submit" class="btn btn-block btn-round">
								<i class="fas fa-sign-in-alt"></i> <?php echo translate('login');?>
							</button>
						</div>

						<div class="sign-footer">
							<p><?php echo $global_config['footer_text'];?></p>
						</div>

						<?php echo form_close();?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Scripts -->
	<script src="<?php echo base_url('assets/vendor/bootstrap/js/bootstrap.js');?>"></script>
	<script src="<?php echo base_url('assets/vendor/jquery-placeholder/jquery-placeholder.js');?>"></script>
	<script src="<?php echo base_url('assets/login_page/js/jquery.backstretch.min.js');?>"></script>
	<script src="<?php echo base_url('assets/login_page/js/custom.js');?>"></script>

	<!-- Show/Hide Password -->
<script>
document.getElementById('togglePassword').addEventListener('click', function () {
    const password = document.getElementById('password');
    const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
    password.setAttribute('type', type);
    this.classList.toggle('fa-eye-slash');
});
</script>

	<!-- SweetAlert Notifications -->
	<?php
	$alertclass = "";
	if($this->session->flashdata('alert-message-success')) $alertclass = "success";
	else if ($this->session->flashdata('alert-message-error')) $alertclass = "error";
	else if ($this->session->flashdata('alert-message-info')) $alertclass = "info";

	if($alertclass != ''):
		$alert_message = $this->session->flashdata('alert-message-'. $alertclass);
	?>
	<script type="text/javascript">
		swal({
			toast: true,
			position: 'top-end',
			type: '<?php echo $alertclass;?>',
			title: '<?php echo $alert_message;?>',
			confirmButtonClass: 'btn btn-default',
			buttonsStyling: false,
			timer: 8000
		})
	</script>
	<?php endif; ?>

	<!-- Tawk.to Chat -->
	<script type="text/javascript">
	var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
	(function(){
		var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
		s1.async=true;
		s1.src='https://embed.tawk.to/662ae22c1ec1082f04e70d03/1hsbo700u';
		s1.charset='UTF-8';
		s1.setAttribute('crossorigin','*');
		s0.parentNode.insertBefore(s1,s0);
	})();
	</script>
</body>
</html>
