<?php
$div = 0;
if (get_permission('employee_count_widget', 'is_view')) {
	$div++;	
}
if (get_permission('student_count_widget', 'is_view')) {
	$div++;	
}
if (get_permission('parent_count_widget', 'is_view')) {
	$div++;	
}
if (get_permission('teacher_count_widget', 'is_view')) {
	$div++;	
}
if ($div == 0) {
	$widget1 = 0;
}else{
	$widget1 = 12 / $div;
}

$div2 = 0;
if (get_permission('admission_count_widget', 'is_view')) {
	$div2++;	
}
if (get_permission('voucher_count_widget', 'is_view')) {
	$div2++;	
}
if (get_permission('transport_count_widget', 'is_view') && moduleIsEnabled('transport')) {
	$div2++;	
}
if (get_permission('hostel_count_widget', 'is_view') && moduleIsEnabled('hostel')) {
	$div2++;	
}
if ($div2 == 0) {
	$widget2 = 0;
}else{
	$widget2 = 12 / $div2;
}

$div3 = 12;
if (get_permission('student_birthday_widget', 'is_view') || get_permission('staff_birthday_widget', 'is_view')) {
	$div3 = 9;	
}
?>
<style type="text/css">
    .borderwhite{border-top-color: #fff !important;}
    .box-header>.box-tools {display: none;}
    .sidebar-collapse #barChart{height: 100% !important;}
    .sidebar-collapse #lineChart{height: 100% !important;}
    /*.fc-day-grid-container{overflow: visible !important;}*/
    .tooltip-inner {max-width: 135px;}
</style>

<?php if ($sqlMode == true) { ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-triangle"></i> This School management system may not work properly because "ONLY_FULL_GROUP_BY" is enabled, <strong>Strongly recommended</strong> - consult with your hosting provider to disable "ONLY_FULL_GROUP_BY" in sql_mode configuration.
    </div>
<?php } ?>

<div class="dashboard-page">
	<div class="row">
<?php if (get_permission('monthly_income_vs_expense_chart', 'is_view')) { ?>
		<!-- monthly cash book transaction -->
		<div class="<?php echo get_permission('annual_student_fees_summary_chart', 'is_view') ? 'col-md-12 col-lg-4 col-xl-3' : 'col-md-12'; ?>">
			<section class="panel pg-fw">
				<div class="panel-body">
					<h4 class="chart-title mb-xs"><?=translate('income_vs_expense_of') . " " . translate(strtolower(date('F')))?></h4>
					<div id="cash_book_transaction"></div>
					<div class="round-overlap"><i class="fab fa-sellcast"></i></div>
					<div class="text-center">
						<ul class="list-inline">
							<li>
								<h6 class="text-muted"><i class="fa fa-circle text-blue"></i> <?=translate('income')?></h6>
							</li>
							<li>
								<h6 class="text-muted"><i class="fa fa-circle text-danger"></i> <?=translate('expense')?></h6>
							</li>
						</ul>
					</div>
				</div>
			</section>
		</div>
<?php } ?>
<?php if (get_permission('annual_student_fees_summary_chart', 'is_view')) { ?>

			<!-- student fees monthly summary graph -->
			<div class="<?php echo get_permission('monthly_income_vs_expense_chart', 'is_view') ? 'col-md-12 col-lg-8 col-xl-9' : 'col-md-12'; ?>">
			<section class="panel">
				<div class="panel-body">
                        <div class="box box-primary borderwhite">
                            <div class="box-header with-border">
                                <h4 class="box-title"><?php echo translate('fees_collection_for'); ?> <?php echo translate(strtolower(date('F'))) . " " . date('Y');

        ?></h4>
		
                                
                            </div>
                            <div class="box-body">
                                <div class="chart">
                                    <canvas id="barCMAMonthlyChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>        
				</div>
			</section>
		</div>


		<!-- student fees summary graph -->
		<div class="<?php echo get_permission('monthly_income_vs_expense_chart', 'is_view') ? 'col-md-12 col-lg-8 col-xl-9' : 'col-md-12'; ?>">
			<section class="panel">
				<div class="panel-body">
					<h4 class="chart-title mb-md"><?=translate('annual_fee_summary')?></h4>
					<div class="pe-chart">
						<canvas id="fees_graph" style="height: 250px;"></canvas>
					</div>
				</div>
			</section>
		</div>
<?php } ?>
	</div>
<?php if ($widget1 > 0) { ?>
	<div class="row widget-1">
		<div class="col-md-12 col-lg-12 col-sm-12">
			<div class="panel">
				<div class="row widget-row-in">
				<?php if (get_permission('employee_count_widget', 'is_view')) { ?>
					<div class="col-lg-<?php echo $widget1; ?> col-sm-6 ">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-users"></i>
									<h5><?php echo translate('employee'); ?></h5>
								</div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h3 class="counter text-right mt-md text-primary"><?php
									$staff = $this->dashboard_model->getstaffcounter('', $school_id);
									echo $staff['snumber'];
									?></h3>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
										<span class="text-uppercase"><?php echo translate('total_strength'); ?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
				<?php if (get_permission('student_count_widget', 'is_view')) { ?>
					<div class="col-lg-<?php echo $widget1; ?> col-sm-6">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-user-graduate"></i>
									<h5><?php echo translate('students'); ?></h5> </div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h4 style="padding: 0px; margin: -6px; font-size: 12px;" class="text-uppercase text-primary"><?php echo translate('GENERAL'); ?>: <?=$get_total_student?> <br> <?php echo translate('INACTIVE'); ?>: <?=$get_total_deactive_student?> <br> <?php echo translate('ALUMNI'); ?>: <?=$get_total_alumni_student?></h4>
									<h3 class="counter text-right mt-md text-primary"><?=$get_total_current_student?></h3>
									
								</div>

								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
											<span class="text-uppercase"><?php echo translate('total_strength'); ?></span>
									</div>
									
									
								</div>

							</div>
						</div>
					</div>
				<?php } ?>
				<?php if (get_permission('parent_count_widget', 'is_view')) { ?>
					<div class="col-lg-<?php echo $widget1; ?> col-sm-6 ">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-user-tie" ></i>
									<h5><?php echo translate('parents'); ?></h5></div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h3 class="counter text-right mt-md text-primary"><?php
										if (!empty($school_id))
											$this->db->where('branch_id', $school_id);
										echo $this->db->select('id')->get('parent')->num_rows();
									?></h3>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
										<span class="text-uppercase"><?php echo translate('total_strength'); ?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
				<?php if (get_permission('teacher_count_widget', 'is_view')) { ?>
					<div class="col-lg-<?php echo $widget1; ?> col-sm-6 ">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-chalkboard-teacher" ></i>
									<h5><?php echo translate('teachers'); ?></h5></div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h3 class="counter text-right mt-md text-primary"><?php
									$staff = $this->dashboard_model->getstaffcounter(3, $school_id);
									echo $staff['snumber'];
									?></h3>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
										<span class="text-uppercase"><?=translate('total_strength')?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
				</div>
			</div>
		</div>
	</div>
<?php } ?>
	<!-- student quantity chart -->
	<div class="row">
<?php if (get_permission('student_quantity_pie_chart', 'is_view')) { ?>
		<div class="<?php echo get_permission('weekend_attendance_inspection_chart', 'is_view') ? 'col-md-12 col-lg-4 col-xl-3' : 'col-md-12'; ?>">
			<section class="panel pg-fw">
				<div class="panel-body">
					<h4 class="chart-title mb-xs"><?=translate('student_quantity')?></h4>
					<div id="student_strength"></div>
					<div class="round-overlap"><i class="fas fa-school"></i></div>
				</div>
			</section>
		</div>
<?php } ?>
<?php if (get_permission('weekend_attendance_inspection_chart', 'is_view')) { ?>
		<div class="<?php echo get_permission('student_quantity_pie_chart', 'is_view') ? 'col-md-12 col-lg-8 col-xl-9' : 'col-md-12'; ?>">
			<section class="panel">
				<div class="panel-body">
					<h4 class="chart-title mb-md"><?=translate('weekend_attendance_inspection')?></h4>
					<div class="pg-fw">
						<canvas id="weekend_attendance" style="height: 340px;"></canvas>
					</div>
				</div>
			</section>
		</div>
<?php } ?>
	</div>
<?php if ($widget2 > 0) { ?>
	<div class="row widget-2">
		<div class="col-md-12 col-lg-12 col-sm-12">
			<div class="panel">
				<div class="row widget-row-in">
				<?php if (get_permission('admission_count_widget', 'is_view')) { ?>
					<div class="col-lg-<?php echo $widget2; ?> col-sm-6 ">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <i class="far fa-address-card"></i>
									<h5><?php echo translate('admission'); ?></h5>
								</div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h3 class="counter text-right mt-md text-primary"><?=$get_monthly_admission;?></h3>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
										<span class="text-uppercase"><?php echo translate('interval_month'); ?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
				<?php if (get_permission('voucher_count_widget', 'is_view')) { ?>
					<div class="col-lg-<?php echo $widget2; ?> col-sm-6">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-money-check-alt"></i>
									<h5><?php echo translate('voucher'); ?></h5> </div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h3 class="counter text-right mt-md text-primary"><?=$get_voucher?></h3>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
											<span class="text-uppercase"><?php echo translate('total_number'); ?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
				<?php if (get_permission('transport_count_widget', 'is_view') && moduleIsEnabled('transport')) { ?>
					<div class="col-lg-<?php echo $widget2; ?> col-sm-6 ">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-road" ></i>
									<h5><?php echo translate('transport'); ?></h5></div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h3 class="counter text-right mt-md text-primary"><?=$get_transport_route?></h3>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
										<span class="text-uppercase"><?php echo translate('total_route'); ?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
				<?php if (get_permission('hostel_count_widget', 'is_view') && moduleIsEnabled('hostel')) { ?>
					<div class="col-lg-<?php echo $widget2; ?> col-sm-6 ">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-warehouse" ></i>
									<h5><?php echo translate('hostel'); ?></h5></div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h3 class="counter text-right mt-md text-primary"><?php
										if (!empty($school_id))
											$this->db->where('branch_id', $school_id);
										$hostel_room = $this->db->select('id')->get('hostel_room')->num_rows();
										echo $hostel_room;
										?></h3>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
										<span class="text-uppercase"><?=translate('total_room')?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
				</div>
			</div>
		</div>
	</div>
<?php } ?>
	<div class="row">
	    <!-- event calendar -->
		<div class="col-md-<?php echo $div3 ?>">
			<section class="panel">
				<div class="panel-body">
					<div id="event_calendar"></div>
				</div>
			</section>
		</div>
	<?php if ($div3 == 9) { ?>
		<div class="col-md-3">
			<div class="panel">
				<div class="row widget-row-in">
				<?php if (get_permission('student_birthday_widget', 'is_view')) { ?>
					<div class="col-xs-12">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <a href="<?php echo base_url('birthday/student') ?>" data-toggle="tooltip" data-original-title="<?=translate('view') . " " . translate('list')?>"><i class="fas fa-birthday-cake" ></i></a>
									<h5 class="text-muted"><?=translate('student')?></h5></div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h3 class="counter text-right mt-md text-primary"><?php
										$this->db->select('student.id');
										$this->db->from('student');
										$this->db->join('enroll', 'enroll.student_id = student.id', 'inner');
										$this->db->where("enroll.session_id", get_session_id());
										if (!empty($school_id))
											$this->db->where('branch_id', $school_id);
										$this->db->where("MONTH(student.birthday)", date('m'));
										$this->db->where("DAY(student.birthday)", date('d'));
										$this->db->group_by('student.id'); 
										$stuTodayBirthday = $this->db->get()->result();
										echo(count($stuTodayBirthday));
										?></h3>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
										<span class="text-muted text-uppercase"><?=translate('today_birthday')?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } if (get_permission('staff_birthday_widget', 'is_view')) { ?>
					<div class="col-xs-12">
						<div class="panel-body">
							<div class="widget-col-in row">
								<div class="col-md-6 col-sm-6 col-xs-6"> <a href="<?php echo base_url('birthday/staff') ?>" data-toggle="tooltip" data-original-title="<?=translate('view') . " " . translate('list')?>"><i class="fas fa-birthday-cake" ></i></a>
									<h5 class="text-muted"><?=translate('employee')?></h5></div>
								<div class="col-md-6 col-sm-6 col-xs-6">
									<h3 class="counter text-right mt-md text-primary"><?php
										$this->db->select('id');
										if (!empty($school_id))
											$this->db->where('branch_id', $school_id);
										$this->db->where("MONTH(birthday)", date('m'));
										$this->db->where("DAY(birthday)", date('d'));
										$emyTodayBirthday = $this->db->get('staff')->result();
										echo(count($emyTodayBirthday));
										?></h3>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="box-top-line line-color-primary">
										<span class="text-muted text-uppercase"><?=translate('today_birthday')?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
				</div>
			</div>
		</div>
	<?php } ?>
	</div>
</div>

<div class="zoom-anim-dialog modal-block modal-block-primary mfp-hide" id="modal">
	<section class="panel">
		<header class="panel-heading">
			<div class="panel-btn">
				<button onclick="fn_printElem('printResult')" class="btn btn-default btn-circle icon" ><i class="fas fa-print"></i></button>
			</div>
			<h4 class="panel-title"><i class="fas fa-info-circle"></i> <?=translate('event_details')?></h4>
		</header>
		<div class="panel-body">
			<div id="printResult" class=" pt-sm pb-sm">
				<div class="table-responsive">						
					<table class="table table-bordered table-condensed text-dark tbr-top" id="ev_table">
						
					</table>
				</div>
			</div>
		</div>
		<footer class="panel-footer">
			<div class="row">
				<div class="col-md-12 text-right">
					<button class="btn btn-default modal-dismiss">
						<?=translate('close')?>
					</button>
				</div>
			</div>
		</footer>
	</section>
</div>

<script type="application/javascript">
(function($) {
    // FullCalendar initialization
    $('#event_calendar').fullCalendar({
        header: {
            left: 'prev,next,today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay,listWeek'
        },
        firstDay: 1,
        height: 420,
        droppable: false,
        editable: true,
        timezone: 'UTC',
        lang: '<?php echo $language ?>',
        events: {
            url: "<?=base_url('event/get_events_list/'. $school_id)?>"
        },
        eventRender: function(event, element) {
            $(element).on("click", function() {
                viewEvent(event.id);
            });
            if(event.icon){          
                element.find(".fc-title").prepend("<i class='fas fa-"+event.icon+"'></i> ");
            }
        } 
    });

    // ===== FEES ANNUAL LINE CHART =====
    <?php if(get_permission('annual_student_fees_summary_chart','is_view')): ?>
    var feesGraph = {
        type: 'line',
        data: {
            labels: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],
            datasets:[
                {label:'<?= translate("allocated_fees") ?>', data:<?= json_encode($fees_summary["total_fee"] ?? []) ?>, borderColor:'rgba(2,138,217,1)', backgroundColor:'rgba(2,138,217,0.2)', fill:true, tension:0.3, drawTime:'afterDraw'},
                {label:'<?= translate("collected_fees") ?>', data:<?= json_encode($fees_summary["total_paid"] ?? []) ?>, borderColor:'rgba(15,102,3,1)', backgroundColor:'rgba(15,102,3,0.2)', fill:true, tension:0.3, drawTime:'afterDraw'},
                {label:'<?= translate("remaining_fees") ?>', data:<?= json_encode($fees_summary["total_due"] ?? []) ?>, borderColor:'rgba(204,102,102,1)', backgroundColor:'rgba(204,102,102,0.2)', fill:true, tension:0.3, drawTime:'afterDraw'}
            ]
        },
        options:{
            responsive:true,
            maintainAspectRatio:false,
            scales:{y:{beginAtZero:true}},
            interaction:{mode:'nearest', axis:'x', intersect:false},
            plugins:{legend:{position:'top'}}
        }
    };
    var ctxFees = document.getElementById('fees_graph')?.getContext('2d');
    if(ctxFees) window.feesChart = new Chart(ctxFees, feesGraph);
    <?php endif; ?>

    // ===== BAR CMA MONTHLY LINE CHART =====
    <?php if(get_permission('annual_student_fees_summary_chart','is_view')): ?>
    var smooth = false;
    var propagate = false;

    function generateData() {
        return <?= json_encode($get_Daymonth["monthdays"] ?? []) ?>.map(() => Math.floor(Math.random() * 1000));
    }

var barMonthlyChartConfig = {
    type: 'line',
    data: {
        labels: <?= json_encode($get_Daymonth["monthdays"] ?? []) ?>,
        datasets: [{
            label: '<?= translate("collected_fees_day") ?>',
            data: <?= json_encode($get_Daymonth["total_fee_days"] ?? []) ?>,
            borderColor: 'rgba(47, 156, 0, 1)',
            backgroundColor: 'rgba(111, 53, 3, 0.57)',
            fill: true,         // area under the curve
            tension: 0.4,       // smooth curve
            pointRadius: 4,     // small points
            pointHoverRadius: 5,
            borderWidth: 6,     // thicker line for visibility
            spanGaps: true      // connect gaps if any null values
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        interaction: { mode: 'nearest', axis: 'x', intersect: false },
        plugins: { legend: { position: 'top' } },
        scales: {
            y: { 
                beginAtZero: true,
                title: { display: true, text: 'Amount Collected' }
            },
            x: { 
                title: { display: true, text: 'Day of Month' },
                ticks: { maxRotation: 0, minRotation: 0 }
            }
        }
    }
};

var ctxMonthly = document.getElementById('barCMAMonthlyChart')?.getContext('2d');
if(ctxMonthly) window.barMonthlyChart = new Chart(ctxMonthly, barMonthlyChartConfig);


    const actions = [
        {
            name: 'Randomize',
            handler(chart) {
                chart.data.datasets.forEach(dataset => {
                    dataset.data = generateData();
                });
                chart.update();
            }
        },
        {
            name: 'Propagate',
            handler(chart) {
                propagate = !propagate;
                chart.options.plugins.filler.propagate = propagate;
                chart.update();
            }
        },
        {
            name: 'Smooth',
            handler(chart) {
                smooth = !smooth;
                chart.data.datasets = chart.data.datasets.map(ds => ({...ds, tension: smooth ? 0.4 : 0}));
                chart.update();
            }
        }
    ];

    // Example button bindings
    document.getElementById('randomizeBtn')?.addEventListener('click', function() { actions[0].handler(window.barMonthlyChart); });
    document.getElementById('smoothBtn')?.addEventListener('click', function() { actions[2].handler(window.barMonthlyChart); });
    document.getElementById('propagateBtn')?.addEventListener('click', function() { actions[1].handler(window.barMonthlyChart); });
    <?php endif; ?>

    // ===== INCOME VS EXPENSE PIE CHART =====
    <?php if(get_permission('monthly_income_vs_expense_chart','is_view')): ?>
    var cash_book_transaction = document.getElementById("cash_book_transaction");
    if(cash_book_transaction){
        var cashbookchart = echarts.init(cash_book_transaction);
        cashbookchart.setOption({
            tooltip: {trigger:'item', formatter:"{a} <br/>{b} : <?php echo $global_config['currency_symbol']?> {c} ({d}%)"},
            legend:{show:false},
            color:["#d81b60","#009efb"],
            series:[{name:'Transaction', type:'pie', radius:['75%','90%'], itemStyle:{normal:{label:{show:false},labelLine:{show:false}}, emphasis:{label:{show:false}}}, data:<?= json_encode($income_vs_expense) ?>}]
        });
    }
    <?php endif; ?>

    // ===== WEEKEND ATTENDANCE CHART =====
    <?php if(get_permission('weekend_attendance_inspection_chart', 'is_view')): ?>
    var days = <?= json_encode($weekend_attendance["days"]);?>;
    var employees_att = <?= json_encode($weekend_attendance["employee_att"]);?>;
    var student_att = <?= json_encode($weekend_attendance["student_att"]);?>;
    var weekendAttendanceChart = {
        type: 'bar',
        data: {
            labels: days,
            datasets: [
                {label:'<?= translate("employee"); ?>', data: employees_att, backgroundColor:'rgba(0,136,204,0.6)', borderColor:'#F5F5F5', borderWidth:1, fill:false},
                {label:'<?= translate("student"); ?>', data: student_att, backgroundColor:'rgba(204,102,102,0.6)', borderColor:'#F5F5F5', borderWidth:1, fill:false}
            ]
        },
        options:{
            responsive:true,
            plugins:{title:{display:false}, tooltip:{mode:'index'}},
            interaction:{mode:'nearest', axis:'x', intersect:false},
            scales:{x:{title:{display:true,text:'Month'}}, y:{stacked:true, title:{display:true,text:'Value'}}}
        }
    };
    var ctx2 = document.getElementById('weekend_attendance')?.getContext('2d');
    if(ctx2) window.weekendChart = new Chart(ctx2, weekendAttendanceChart);
    <?php endif; ?>

    // ===== STUDENT STRENGTH DOUGHNUT CHART =====
    <?php if(get_permission('student_quantity_pie_chart', 'is_view')): ?>
    var color = ['#546570','#c4ccd3','#c23531','#2f4554','#61a0a8','#d48265','#91c7ae','#749f83','#ca8622','#bda29a','#6e7074'];
    var strength_data = <?= json_encode($student_by_class); ?>;
    var student_strength = document.getElementById("student_strength");
    var studentchart = echarts.init(student_strength);
    studentchart.setOption({
        tooltip:{trigger:'item', formatter:"{a} <br/>{b} : {c} ({d}%)"},
        legend:{type:'scroll', x:'center', y:'bottom', itemWidth:14,
            <?php if($theme_config["dark_skin"] == "true"): ?>
            inactiveColor:'#4b4b4b', textStyle:{color:'#6b6b6c'}
            <?php endif; ?>
        },
        series:[{name:'Strength', type:'pie', color:color, radius:['70%','85%'], center:['50%','46%'], itemStyle:{normal:{label:{show:false}, labelLine:{show:false}}, emphasis:{label:{show:false}}}, data:strength_data}]
    });
    <?php endif; ?>

    // ===== RESIZE CHARTS =====
    $(".sidebar-toggle").on("click", function(){ resizeCharts(); });
    $(window).on("resize", resizeCharts);
    function resizeCharts() {
        setTimeout(function(){
            if($("#student_strength").length) studentchart.resize();
            if($("#cash_book_transaction").length) cashbookchart.resize();
            if($("#barCMAMonthlyChart").length) window.barMonthlyChart?.resize();
            if($("#fees_graph").length) window.feesChart?.resize();
            if($("#weekend_attendance").length) window.weekendChart?.resize();
        }, 350);
    }

})(jQuery);
</script>
