<?php $widget = (is_superadmin_loggedin() ? 2 : 3); ?>
<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?php echo form_open('exam/cma_principal_comment', array('class' => 'validate')); ?>
            <header class="panel-heading">
                <h4 class="panel-title"><?=translate('select_ground')?></h4>
            </header>
            <div class="panel-body">
                <div class="row mb-sm">
                <?php if (is_superadmin_loggedin() ): ?>
                    <div class="col-md-3 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('branch')?> <span class="required">*</span></label>
                            <?php
                                $arrayBranch = $this->app_lib->getSelectList('branch');
                                echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' id='branch_id' required
                                data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
                            ?>
                        </div>
                    </div>
                <?php endif; ?>

                    <div class="col-md-<?=$widget?> mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('academic_year')?> <span class="required">*</span></label>
                            <?php
                                $arrayYear = array("" => translate('select'));
                                $years = $this->db->get('schoolyear')->result();
                                foreach ($years as $year){
                                    $arrayYear[$year->id] = $year->school_year;
                                }
                                echo form_dropdown("session_id", $arrayYear, set_value('session_id', get_session_id()), "class='form-control' required
                                data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                            ?>
                        </div>
                    </div>

                    <div class="col-md-<?=$widget?> mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('exam')?> <span class="required">*</span></label>
                            <?php
                                if(!empty($branch_id)){
                                    $arrayExam = array("" => translate('select'));
                                    $exams = $this->db->get_where('exam', array('branch_id' => $branch_id,'session_id' => get_session_id()))->result();
                                    foreach ($exams as $exam){
                                        $arrayExam[$exam->id] = $this->application_model->exam_name_by_id($exam->id);
                                    }
                                } else {
                                    $arrayExam = array("" => translate('select_branch_first'));
                                }
                                echo form_dropdown("exam_id", $arrayExam, set_value('exam_id'), "class='form-control' id='exam_id' required
                                data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                            ?>
                        </div>
                    </div>

                    <div class="col-md-3 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('class')?> <span class="required">*</span></label>
                            <?php
                                $arrayClass = $this->app_lib->getClass($branch_id);
                                echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
                                required data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                            ?>
                        </div>
                    </div>

                    <div class="col-md-<?=$widget?> mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('section')?> <span class="required">*</span></label>
                            <?php
                                $arraySection = $this->app_lib->getSections(set_value('class_id'));
                                echo form_dropdown("section_id", $arraySection, set_value('section_id'), "class='form-control' id='section_id' required
                                data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-offset-10 col-md-2">
                        <button type="submit" name="submit" value="search" class="btn btn-default btn-block"><i class="fas fa-filter"></i> <?=translate('filter')?></button>
                    </div>
                </div>
            </div>
            <?php echo form_close();?>
        </section>

<?php if (isset($get_subjects)) { ?>
    
    <section class="panel appear-animation" data-appear-animation="<?php echo $global_config['animations'];?>" data-appear-animation-delay="100">
        <?php echo form_open('exam/cma_principl_comment_save', array('class' => 'frm-submit-msg')); ?>
        <header class="panel-heading">
            <h4 class="panel-title">
                <i class="fas fa-users"></i> <?=translate('student') . " " . translate('exam_rank') . " : " . $exam_details->name;?>
            </h4>
        </header>

        <div class="panel-body">

            <div class="row mb-3">
                <div class="col-md-3">
                    <label><b>Resumption Date</b></label>
                    <input type="date" id="global_resumption_date" class="form-control">
                </div>
                <div class="col-md-3" style="padding-top:24px;">
                    <button type="button" id="applyResumptionBtn" class="btn btn-primary">Apply to All Students</button>
                </div>
            </div>

            <div class="table-responsive mt-md mb-lg">
                <input type="hidden" name="exam_id" value="<?php echo $exam_details->id; ?>">

                <table class="table table-bordered table-hover table-condensed mb-none" id="tableExport">
                    <thead class="text-dark">
                        <tr>
                            <th><?=translate('students')?></th>
                            <th><?=translate('register_no')?></th>
                            <th><?=translate('class')?></th>
                            <th><?=translate('section')?></th>
                            <th><?=translate('total_marks')?></th>
                            <th><?=translate('percentage')?></th>
                            <th>GPA</th>
                            <th><?=translate('result')?></th>
                            <th><?=translate('position')?> <span class="required">*</span></th>
                            <th><?=translate('principal_comment')?></th>
                            <th><?=translate('teachers_comment')?></th>
                            <th><?=translate('Resumption_date')?></th>
                        </tr>
                    </thead>

                    <tbody>

<?php
$studentArrayList = [];

foreach($students_list as $enroll) {
    $totalMarks = 0;
    $totalFullmarks = 0;
    $totalGradePoint = 0;
    $subjectsCount = 0; // Only count offered subjects

    foreach ($get_subjects as $subject) {
        $this->db->where([
            'class_id' => set_value('class_id'),
            'exam_id' => set_value('exam_id'),
            'subject_id' => $subject['subject_id'],
            'student_id' => $enroll->student_id,
            'session_id' => set_value('session_id')
        ]);
        $getMark = $this->db->get('mark')->row_array();

        if(!empty($getMark) && (!isset($getMark['subject_status']) || $getMark['subject_status'] != 'not_offered')) {
            $subjectsCount++;
            $absent = $getMark['subject_status'] ?? 'present';

            $obtainedMark = json_decode($getMark['mark'], true);
            $distribution = json_decode($subject['mark_distribution'], true);

            $subjectTotal = 0;
            $subjectFull = 0;
            foreach($distribution as $i => $dist) {
                $mark = ($absent == 'absent') ? 0 : floatval($obtainedMark[$i] ?? 0);
                $subjectTotal += $mark;
                $subjectFull  += floatval($dist['full_mark']);
            }

            $totalMarks += $subjectTotal;
            $totalFullmarks += $subjectFull;

            $grade = $this->exam_model->getExam_grade($subjectTotal, $branch_id);
            $totalGradePoint += $grade['grade_point'];
        }
    }

    $percentage = ($totalFullmarks>0) ? ($totalMarks*100/$totalFullmarks) : 0;
    $gpa = ($subjectsCount>0 && $totalFullmarks>0) ? number_format(($totalGradePoint/$subjectsCount),2,'.','') : '0.00';

    $studentArrayList[] = [
        'enrollID' => $enroll->id,
        'name' => $enroll->fullname,
        'register_no' => $enroll->register_no,
        'class_name' => $enroll->class_name,
        'section_name' => $enroll->section_name,
        'totalMarks' => $totalMarks,
        'totalFullmarks' => $totalFullmarks,
        'percentage' => $percentage,
        'gpa' => $gpa,
        'principal_comment' => $enroll->principal_comment,
        'teachers_comment' => $enroll->teachers_comment,
        'resumption_date' => $enroll->resumption_date
    ];
}

// Sort by total marks descending
usort($studentArrayList, function($a,$b){
    return $b['totalMarks'] <=> $a['totalMarks'];
});

$count = 1;
foreach($studentArrayList as $key=>$row1): ?>
<tr>
    <input type="hidden" name="rank[<?php echo $key ?>][enroll_id]" value="<?php echo $row1['enrollID']; ?>">
    <td><?php echo $row1['name']; ?></td>
    <td><?php echo $row1['register_no']; ?></td>
    <td><?php echo $row1['class_name']; ?></td>
    <td><?php echo $row1['section_name']; ?></td>
    <td><?php echo $row1['totalFullmarks']>0 ? $row1['totalMarks'].'/'.$row1['totalFullmarks'] : 'N/A'; ?></td>
    <td><?php echo $row1['totalFullmarks']>0 ? number_format($row1['percentage'],2,'.','').' %' : 'N/A'; ?></td>
    <td><?php echo $row1['gpa']; ?></td>
    <td>
   <?php
if ($row1['totalFullmarks'] == 0) {
    echo '<span class="badge bg-secondary">N/A</span>'; // gray
} else if ($row1['percentage'] >= 80) {
    echo '<span class="badge bg-success">Excellent</span>'; // green
} else if ($row1['percentage'] >= 60) {
    echo '<span class="badge bg-primary">Very Good</span>'; // blue
} else if ($row1['percentage'] >= 50) {
    echo '<span class="badge bg-info">Good</span>'; // light blue
} else if ($row1['percentage'] >= 40) {
    echo '<span class="badge bg-warning text-dark">Pass</span>'; // yellow
} else {
    echo '<span class="badge bg-danger">Fail</span>'; // red
}
?>
    </td>
    <td><input class="form-control" type="text" name="rank[<?php echo $key ?>][position]" value="<?php echo $count; ?>" readonly></td>
    <td>
    <?php
        $arrayPrincipal = array("" => translate('choose comment'));
        $principal_comments = $this->db->get('exam_principal_comment')->result();
        foreach ($principal_comments as $pc){
            $arrayPrincipal[$pc->id] = $pc->comment;
        }
        echo form_dropdown("rank[$key][principal_comments]", $arrayPrincipal, $row1['principal_comment'], "class='form-control'");
    ?>
    </td>
    <td><input class="form-control" type="text" name="rank[<?php echo $key ?>][teachers_comments]" value="<?php echo $row1['teachers_comment']; ?>" readonly></td>
    <td><input class="form-control resumption_date" type="date" name="rank[<?php echo $key ?>][resumption_date]" value="<?php echo $row1['resumption_date']; ?>"></td>
</tr>
<?php $count++; endforeach; ?>

                    </tbody>
                </table>
            </div>
        </div>

        <div class="panel-footer">
            <div class="row">
                <div class="col-md-offset-10 col-md-2">
                    <button type="submit" class="btn btn-default btn-block">
                        <i class="fas fa-plus-circle"></i> <?=translate('save')?>
                    </button>
                </div>
            </div>
        </div>

    <?php echo form_close(); ?>
    </section>
<?php } ?>

    </div>
</div>

<script type="text/javascript">
$(document).ready(function () {
    $('#branch_id').on("change", function() {
        var branchID = $(this).val();
        getClassByBranch(branchID);
        getExamByBranch(branchID);
    });
});

$("#applyResumptionBtn").click(function() {
    let dateVal = $("#global_resumption_date").val();
    if(dateVal === "") {
        alert("Please select a resumption date first.");
        return;
    }
    $(".resumption_date").val(dateVal);
});
</script>
