<?php $widget = (is_superadmin_loggedin() ? 2 : 3); ?> 
<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?php echo form_open('exam/cma_section_position', array('class' => 'validate')); ?>
            <header class="panel-heading">
                <h4 class="panel-title"><?=translate('select_ground')?></h4>
            </header>
            <div class="panel-body">
                <div class="row mb-sm">
                <?php if (is_superadmin_loggedin() ): ?>
                    <div class="col-md-3 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('branch')?> <span class="required">*</span></label>
                            <?php
                                $arrayBranch = $this->app_lib->getSelectList('branch');
                                echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' id='branch_id' required
                                data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
                            ?>
                        </div>
                    </div>
                <?php endif; ?>
                    <div class="col-md-<?=$widget?> mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('academic_year')?> <span class="required">*</span></label>
                            <?php
                                $arrayYear = array("" => translate('select'));
                                $years = $this->db->get('schoolyear')->result();
                                foreach ($years as $year){
                                    $arrayYear[$year->id] = $year->school_year;
                                }
                                echo form_dropdown("session_id", $arrayYear, set_value('session_id', get_session_id()), "class='form-control' required
                                data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
                            ?>
                        </div>
                    </div>
                    <div class="col-md-<?=$widget?> mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('exam')?> <span class="required">*</span></label>
                            <?php
                                if(!empty($branch_id)){
                                    $arrayExam = array("" => translate('select'));
                                    $exams = $this->db->get_where('exam', array('branch_id' => $branch_id,'session_id' => get_session_id()))->result();
                                    foreach ($exams as $exam){
                                        $arrayExam[$exam->id] = $this->application_model->exam_name_by_id($exam->id);
                                    }
                                } else {
                                    $arrayExam = array("" => translate('select_branch_first'));
                                }
                                echo form_dropdown("exam_id", $arrayExam, set_value('exam_id'), "class='form-control' id='exam_id' required
                                data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
                            ?>
                        </div>
                    </div>
                    <div class="col-md-3 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('class')?> <span class="required">*</span></label>
                            <?php
                                $arrayClass = $this->app_lib->getClass($branch_id);
                                echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
                                required data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
                            ?>
                        </div>
                    </div>
                    <div class="col-md-<?=$widget?> mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('section')?> <span class="required">*</span></label>
                            <?php
                                $arraySection = $this->app_lib->getSections(set_value('class_id'));
                                echo form_dropdown("section_id", $arraySection, set_value('section_id'), "class='form-control' id='section_id' required
                                data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-offset-10 col-md-2">
                        <button type="submit" name="submit" value="search" class="btn btn-default btn-block"><i class="fas fa-filter"></i> <?=translate('filter')?></button>
                    </div>
                </div>
            </div>
            <?php echo form_close();?>
        </section>

        <?php if (isset($get_subjects)) { ?>
            <section class="panel appear-animation" data-appear-animation="<?php echo $global_config['animations'];?>" data-appear-animation-delay="100">
                <?php echo form_open('exam/cma_section_save_position', array('class' => 'frm-submit-msg')); ?>
                <header class="panel-heading">
                    <h4 class="panel-title">
                        <i class="fas fa-users"></i> <?=translate('student') . " " . translate('exam_rank') . " : " . $exam_details->name;?>
                    </h4>
                </header>
                <div class="panel-body">

                <?php 
                $generated = !empty($students_list[0]->rank); 
                if($generated) { ?>
                    <div class="alert alert-danger text-center">The position has already been generated.</div>
                <?php } ?>
                    
                    <div class="table-responsive mt-md mb-lg">
                        <input type="hidden" name="exam_id" value="<?php echo $exam_details->id; ?>">
                        <table class="table table-bordered table-hover table-condensed mb-none" id="tableExport">
                            <thead class="text-dark">
                                <tr>
                                    <th><?=translate('students')?></th>
                                    <th><?=translate('register_no')?></th>
                                    <th><?=translate('class')?></th>
                                    <th><?=translate('section')?></th>
                                    <th><?=translate('total_marks')?></th>
                                <?php if ($exam_details->type_id != 2) { ?>
                                    <th><?=translate('percentage')?></th>
                                <?php } if ($exam_details->type_id != 1) { ?>
                                    <th>GPA</th>
                                <?php } ?>
                                    <th><?=translate('result')?></th>
                                <?php if ($generated == true) { ?>
                                    <th><?=translate('previous_position')?></th>
                                <?php } ?>
                                    <th><?=translate('position')?> <span class="required">*</span></th>
                                </tr>
                            </thead>
                            <tbody>
<?php
$passThreshold = 40;
$passStudents = [];
$failStudents = [];

foreach ($students_list as $student) {
    $totalMarks = 0;
    $totalFull = 0;
    $totalGradePoint = 0;
    $subjectsCount = 0;

    foreach ($get_subjects as $subject) {
        $this->db->where([
            'class_id' => set_value('class_id'),
            'exam_id' => set_value('exam_id'),
            'subject_id' => $subject['subject_id'],
            'student_id' => $student->student_id,
            'session_id' => set_value('session_id')
        ]);
        $mark = $this->db->get('mark')->row_array();

        if (empty($mark) || ($mark['subject_status'] ?? 'present') == 'not_offered') continue;

        $subjectsCount++;
        $obtained = json_decode($mark['mark'], true);
        $dist = json_decode($subject['mark_distribution'], true);
        $absent = ($mark['subject_status'] ?? 'present') == 'absent';

        $subjectTotal = 0;
        $subjectFull = 0;

        foreach ($dist as $i => $val) {
            $score = $absent ? 0 : floatval($obtained[$i] ?? 0);
            $subjectTotal += $score;
            $subjectFull += floatval($val['full_mark']);
        }

        $totalMarks += $subjectTotal;
        $totalFull += $subjectFull;
        $gradePoint = $this->exam_model->getExam_grade($subjectTotal, $branch_id)['grade_point'];
        $totalGradePoint += $gradePoint;
    }

    if ($subjectsCount == 0) continue;

    $percentage = ($totalFull > 0) ? ($totalMarks*100/$totalFull) : 0;
    $gpa = number_format(($totalGradePoint / $subjectsCount), 2, '.', '');

    $studentArr = [
        'enrollID' => $student->id,
        'name' => $student->fullname,
        'register_no' => $student->register_no,
        'class' => $student->class_name,
        'section' => $student->section_name,
        'totalMarks' => $totalMarks,
        'totalFull' => $totalFull,
        'percentage' => $percentage,
        'GPA' => $gpa,
        'prevPosition' => $student->rank ?? ''
    ];

    // Result labels
    if ($percentage >= 80) $studentArr['result_label'] = '<span class="badge bg-success">Excellent</span>';
    else if ($percentage >= 60) $studentArr['result_label'] = '<span class="badge bg-primary">Very Good</span>';
    else if ($percentage >= 50) $studentArr['result_label'] = '<span class="badge bg-info text-dark">Good</span>';
    else if ($percentage >= 40) $studentArr['result_label'] = '<span class="badge bg-warning text-dark">Pass</span>';
    else $studentArr['result_label'] = '<span class="badge bg-danger">Fail</span>';

    if ($percentage >= $passThreshold) $passStudents[] = $studentArr;
    else $failStudents[] = $studentArr;
}

// Sort and merge
array_multisort(array_column($passStudents,'totalMarks'), SORT_DESC, array_column($passStudents,'percentage'), SORT_DESC, $passStudents);
array_multisort(array_column($failStudents,'totalMarks'), SORT_DESC, array_column($failStudents,'percentage'), SORT_DESC, $failStudents);
$finalStudents = array_merge($passStudents, $failStudents);

$count = 1;
foreach ($finalStudents as $key => $s): ?>
<tr>
    <input type="hidden" name="rank[<?php echo $key ?>][enroll_id]" value="<?php echo $s['enrollID']; ?>">
    <td><?php echo $s['name']; ?></td>
    <td><?php echo $s['register_no']; ?></td>
    <td><?php echo $s['class']; ?></td>
    <td><?php echo $s['section']; ?></td>
    <td><?php echo $s['totalMarks'].'/'.$s['totalFull']; ?></td>
    <?php if ($exam_details->type_id != 2) { ?><td><?php echo number_format($s['percentage'],2,'.','').' %'; ?></td><?php } ?>
    <?php if ($exam_details->type_id != 1) { ?><td><?php echo $s['GPA']; ?></td><?php } ?>
    <td><?php echo $s['result_label']; ?></td>
    <?php if ($generated) { ?>
        <td><?php echo $s['prevPosition']; ?></td>
    <?php } ?>
    <td><input class="form-control" type="text" name="rank[<?php echo $key ?>][position]" value="<?php echo $count; ?>"></td>
</tr>
<?php $count++; endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="panel-footer">
                    <div class="row">
                        <div class="col-md-offset-10 col-md-2">
                            <button type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                                <i class="fas fa-plus-circle"></i> <?=translate('save')?>
                            </button>
                        </div>
                    </div>
                </div>
            <?php echo form_close(); ?>
            </section>
    <?php } ?>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function () {
    $('#branch_id').on("change", function() {
        var branchID = $(this).val();
        getClassByBranch(branchID);
        getExamByBranch(branchID);
    });
});
</script>
