<section class="panel">
	<div class="tabs-custom">
		<ul class="nav nav-tabs">
			<li class="<?php echo (!isset($validation_error) ? 'active' : ''); ?>">
				<a href="#list" data-toggle="tab">
					<i class="fas fa-list-ul"></i>
					<?php echo translate('timeline_history') . " " . translate('list'); ?>
				</a>
			</li>
			<?php if (get_permission('frontend_testimonial', 'is_add')): ?>
				<li class="<?php echo (isset($validation_error) ? 'active' : ''); ?>">
					<a href="#create" data-toggle="tab">
						<i class="far fa-edit"></i>
						<?php echo translate('add') . " " . translate('timeline_history'); ?>
					</a>
				</li>
			<?php endif; ?>
		</ul>

		<div class="tab-content">
			<!-- ========== LIST TAB ========== -->
			<div id="list" class="tab-pane <?php echo (!isset($validation_error) ? 'active' : ''); ?>">
				<table class="table table-bordered table-hover table-condensed table_default">
					<thead>
						<tr>
							<th><?php echo translate('sl'); ?></th>
							<?php if (is_superadmin_loggedin()): ?>
								<th><?= translate('branch') ?></th>
							<?php endif; ?>
							<th><?php echo translate('photo'); ?></th>
							<th><?php echo translate('title'); ?></th>
							<th><?php echo translate('year_range'); ?></th>
							<th><?php echo translate('description'); ?></th>
							<th><?php echo translate('action'); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php
						$count = 1;
						if (!empty($timeline_historylist)):
							foreach ($timeline_historylist as $row): ?>
								<tr>
									<td><?php echo $count++; ?></td>
									<?php if (is_superadmin_loggedin()): ?>
										<td><?php echo $row['branch_name']; ?></td>
									<?php endif; ?>
									<td><img class="img-border" src="<?php echo $this->timeline_history_model->get_image_url($row['image']); ?>" width="50"/></td>
									<td><?php echo $row['title']; ?></td>
									<td><?php echo $row['year_range']; ?></td>
									<td><?php echo $row['description']; ?></td>


									<td class="min-w-xs">
										<?php if (get_permission('frontend_testimonial', 'is_edit')): ?>
											<a href="<?php echo base_url('frontend/timeline_history/edit/' . $row['id']); ?>"
												class="btn btn-default btn-circle icon"
												data-toggle="tooltip"
												title="<?php echo translate('edit'); ?>">
												<i class="fas fa-pen-nib"></i>
											</a>
										<?php endif; ?>
										<?php if (get_permission('frontend_testimonial', 'is_delete')): ?>
											<?php echo btn_delete('frontend/timeline_history/delete/' . $row['id']); ?>
										<?php endif; ?>
									</td>
								</tr>
						<?php endforeach;
						endif; ?>
					</tbody>
				</table>
			</div>

			<!-- ========== CREATE TAB ========== -->
			<?php if (get_permission('frontend_testimonial', 'is_add')): ?>
				<div class="tab-pane <?php echo (isset($validation_error) ? 'active' : ''); ?>" id="create">
					<?php echo form_open_multipart($this->uri->uri_string(), ['class' => 'form-horizontal form-bordered frm-submit-data']); ?>

					<?php if (is_superadmin_loggedin()): ?>
						<div class="form-group">
							<label class="col-md-3 control-label"><?= translate('branch') ?> <span class="required">*</span></label>
							<div class="col-md-6">
								<?php
								$arrayBranch = $this->app_lib->getSelectList('branch');
								echo form_dropdown("branch_id", $arrayBranch, "", "class='form-control' data-plugin-selectTwo data-width='100%'");
								?>
								<span class="error"></span>
							</div>
						</div>
					<?php endif; ?>

					<div class="form-group">
						<label class="col-md-3 control-label"><?php echo translate('title'); ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<input type="text" class="form-control" name="title" value="<?php echo set_value('title'); ?>" />
							<span class="error"><?php echo form_error('title'); ?></span>
						</div>
					</div>

					<div class="form-group">
						<label class="col-md-3 control-label"><?php echo translate('description'); ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<textarea class="form-control" name="description" rows="3"><?php echo set_value('description'); ?></textarea>
							<span class="error"><?php echo form_error('description'); ?></span>
						</div>
					</div>

					<div class="form-group">
						<label class="col-md-3 control-label"><?php echo translate('year_range'); ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<input type="text" class="form-control" name="year_range" value="<?php echo set_value('year_range'); ?>" placeholder="e.g. 2010 - 2020" />
							<span class="error"><?php echo form_error('year_range'); ?></span>
						</div>
					</div>

					<div class="form-group">
						<label class="col-md-3 control-label"><?php echo translate('photo'); ?> <span class="required">*</span></label>
						<div class="col-md-4">
							<input type="file" name="photo" class="dropify" data-height="150" />
							<span class="error"><?php echo form_error('photo'); ?></span>
						</div>
					</div>

					<footer class="panel-footer mt-lg">
						<div class="row">
							<div class="col-md-2 col-md-offset-3">
								<button type="submit" class="btn btn-default btn-block"
									data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
									<i class="fas fa-plus-circle"></i> <?php echo translate('save'); ?>
								</button>
							</div>
						</div>
					</footer>

					<?php echo form_close(); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</section>