<section class="panel">
	<div class="tabs-custom">
		<ul class="nav nav-tabs">
			<li>
				<a href="<?php echo base_url('frontend/timeline_history'); ?>"><i class="fas fa-list-ul"></i> <?php echo translate('timeline_history') . " " . translate('list'); ?></a>
			</li>
			<li class="active">
				<a href="#edit" data-toggle="tab"><i class="far fa-edit"></i> <?php echo translate('edit') . " " . translate('timeline_history'); ?></a>
			</li>
		</ul>
		<div class="tab-content">
			<div class="tab-pane active" id="edit">
				<?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered frm-submit-data')); ?>
				<input type="hidden" name="timeline_history_id" value="<?php echo $timeline_history['id']; ?>">
				<?php if (is_superadmin_loggedin()): ?>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('branch') ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<?php
							$arrayBranch = $this->app_lib->getSelectList('branch');
							echo form_dropdown("branch_id", $arrayBranch, $timeline_history['branch_id'], "class='form-control' data-plugin-selectTwo
								data-width='100%' data-minimum-results-for-search='Infinity'");
							?>
							<span class="error"></span>
						</div>
					</div>
				<?php endif; ?>
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('title'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="text" class="form-control" name="title" value="<?php echo set_value('title', $timeline_history['title']); ?>" />
						<span class="error"></span>
					</div>
				</div>


				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('description'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<textarea class="form-control" id="description" name="description" placeholder="" rows="3"><?php echo set_value('description', $timeline_history['description']); ?></textarea>
						<span class="error"><?php echo form_error('description'); ?></span>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('year_range'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="text" class="form-control" name="year_range" value="<?php echo set_value('year_range',$timeline_history['year_range']); ?>" placeholder="e.g. 2010 - 2020" />
						<span class="error"><?php echo form_error('year_range'); ?></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('photo'); ?> <span class="required">*</span></label>
					<div class="col-md-4">
						<input type="hidden" name="old_photo" value="<?php echo $timeline_history['image']; ?>">
						<input type="file" name="photo" class="dropify" data-height="150" data-default-file="<?php echo $this->timeline_history_model->get_image_url($timeline_history['image']); ?>" />
						<span class="error"></span>
					</div>
				</div>
				<footer class="panel-footer mt-lg">
					<div class="row">
						<div class="col-md-2 col-md-offset-3">
							<button type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
								<i class="fas fa-edit"></i> <?php echo translate('update'); ?>
							</button>
						</div>
					</div>
				</footer>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</section>