<?php
$page_data = $page_data ?? [];
$servicon = json_decode($service_data['parallax_image'], true);
if (empty($servicon)) {
  $servicon = [
    'icon1_image' => '',
    'icon2_image' => '',
    'icon3_image' => '',
    'icon4_image' => '',
    'vidbanner' => '',

  ];
}

$servtext = json_decode($service_data['description'], true);
if (empty($servtext)) {
  $servtext = [
    'icon1_text' => '',
    'icon2_text' => '',
    'icon3_text' => '',
    'icon4_text' => '',

  ];
}


$servtitle = json_decode($service_data['title'], true);
if (empty($servtitle)) {
  $servtitle = [
    'icon1_text' => '',
    'icon2_text' => '',
    'icon3_text' => '',
    'icon4_text' => '',

  ];
}


$founder = json_decode($page_data['founder'], true);
if (empty($founder)) {
  $founder = array(
    'founder_page_title' => '',
    'description' => '',
    'founder_name' => '',
    'position' => '',
    'photo' => '',
  );
}


$timeline_history = json_decode($page_data['elements'], true);
if (empty($timeline_history)) {
  $timeline_history = array(
    'th_title' => '',
    'th_sub_title' => '',
  );
}


$content = json_decode($service_data['content'], true);
if (empty($content)) {
  $content = array(
    'vision_title' => '',
    'mission_title' => '',
    'mission_description' => '',
    'vision_description' => '',
    'Who_we_are' => '',
    'goal_1' => '',
    'goal_2' => '',
    'goal_3' => '',
    'reg_button' => '',

  );
}


?>



<?php
// Define an array of box styles (colors, positions, and messages)
$box_styles = [
  ['color' => '#f34d23', 'position' => 'top: 0px; right: 0px; left: auto; transform: rotate(-18deg);', 'text' => 'Every child is a unique champion!'],

  ['color' => '#11aef3', 'position' => 'left: 13px; right: auto; transform: rotate(17deg);', 'text' => 'Kind hearts grow confidence'],


  ['color' => '#9dc437', 'position' => 'top: 24px; right: 3px; left: auto; transform: rotate(17deg);', 'text' => 'Curious minds, happy hearts'],

  ['color' => '#ff4880', 'position' => 'top: 45px; right: -4px; left: auto; transform: rotate(10deg);', 'text' => 'Curious minds, happy hearts'],

  ['color' => '#c954f0', 'position' => 'top: calc(50% + 11px); right: -8px; left: auto; transform: rotate(6deg);', 'text' => 'Curious minds, happy hearts'],


  ['color' => '#ffa500', 'position' => 'top: 30px; right: 0px;  left: auto; transform: rotate(-11deg);', 'text' => 'Inspiring young minds daily'],

  ['color' => '#00c897', 'position' => 'right: 10px; transform: rotate(8deg);', 'text' => 'Guiding stars for bright futures'],
];
?>



<div id="pxl-pagetitle" class="pxl-pagetitle layout-el relative has-parallax overflow-hidden">
  <div class="pxl-page-title-bg pxl-absoluted" data-parallax='{"x":"50"}'></div>
  <div class="pxl-page-title-overlay"></div>
  <div data-elementor-type="wp-post" data-elementor-id="5185" class="elementor elementor-5185">
    <div class="elementor-element elementor-element-c0f6a2d e-con-full e-flex e-con e-parent" data-id="c0f6a2d" data-element_type="container" data-settings='{"background_background":"classic"}'>
      <div class="elementor-element elementor-element-fdf07c0 elementor-absolute elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="fdf07c0" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeInLeft","_animation_delay":300}' data-widget_type="pxl_image.default">
        <div class="elementor-widget-container">
          <div id="pxl_image-fdf07c0-2196" class="pxl-image-wg d-flex default">
            <img loading="lazy" width="307" height="350" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img1-about.webp'); ?>" class="attachment-full size-full wp-image-5192" alt="" />
          </div>
        </div>
      </div>
      <div class="elementor-element elementor-element-f74e239 elementor-absolute elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="f74e239" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeInUp","_animation_delay":600}' data-widget_type="pxl_image.default">
        <div class="elementor-widget-container">
          <div id="pxl_image-f74e239-9657" class="pxl-image-wg d-flex default" data-parallax='{"x":"50"}'>
            <img loading="lazy" width="320" height="462" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img2-about.webp'); ?>" class="attachment-full size-full wp-image-5193" alt="" />
          </div>
        </div>
      </div>
      <div class="elementor-element elementor-element-da0ae48 elementor-absolute e-transform elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="da0ae48" data-element_type="widget" data-settings='{"_position":"absolute","_transform_flipX_effect":"transform","_animation":"fadeInRight","_animation_delay":300}' data-widget_type="pxl_image.default">
        <div class="elementor-widget-container">
          <div id="pxl_image-da0ae48-8516" class="pxl-image-wg d-flex default">
            <img loading="lazy" width="307" height="350" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img1-about.webp'); ?>" class="attachment-full size-full wp-image-5192" alt="" />
          </div>
        </div>
      </div>
      <div class="elementor-element elementor-element-5e320eb elementor-absolute elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="5e320eb" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeInUp","_animation_delay":600}' data-widget_type="pxl_image.default">
        <div class="elementor-widget-container">
          <div id="pxl_image-5e320eb-4180" class="pxl-image-wg d-flex default" data-parallax='{"x":"-50"}'>
            <img loading="lazy" width="300" height="455" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img3-about.webp'); ?>" class="attachment-full size-full wp-image-5194" alt="" />
          </div>
        </div>
      </div>
      <div class="elementor-element elementor-element-d57d181 e-con-full e-flex e-con e-child" data-id="d57d181" data-element_type="container">
        <div class="elementor-element elementor-element-947b290 elementor-absolute pxl-parallax-effect mouse-move bound-section e-transform elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="947b290" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeIn","_animation_delay":500,"_transform_translateY_effect":{"unit":"%","size":-50,"sizes":[]},"_transform_translateY_effect_laptop":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile":{"unit":"px","size":"","sizes":[]}}' data-widget_type="pxl_image.default">
          <div class="elementor-widget-container">
            <div id="pxl_image-947b290-7380" class="pxl-image-wg d-flex default">
              <img loading="lazy" width="60" height="60" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/img2-pagetitle.webp'); ?>" class="attachment-full size-full wp-image-327" alt="" />
            </div>
          </div>
        </div>
        <div class="elementor-element elementor-element-9d22965 elementor-absolute pxl-parallax-effect mouse-move bound-section elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="9d22965" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeIn","_animation_delay":200}' data-widget_type="pxl_image.default">
          <div class="elementor-widget-container">
            <div id="pxl_image-9d22965-1692" class="pxl-image-wg d-flex default">
              <img loading="lazy" width="60" height="60" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/img2-pagetitle.webp'); ?>" class="attachment-full size-full wp-image-327" alt="" />
            </div>
          </div>
        </div>
        <div class="elementor-element elementor-element-2839bfc elementor-absolute pxl-parallax-effect mouse-move bound-section elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="2839bfc" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeIn","_animation_delay":900}' data-widget_type="pxl_image.default">
          <div class="elementor-widget-container">
            <div id="pxl_image-2839bfc-2625" class="pxl-image-wg d-flex default">
              <img loading="lazy" width="60" height="60" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/img6-pagetitle.webp'); ?>" class="attachment-full size-full wp-image-336" alt="" />
            </div>
          </div>
        </div>
        <div class="elementor-element elementor-element-1392b33 elementor-absolute pxl-parallax-effect mouse-move bound-section elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="1392b33" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeIn","_animation_delay":700}' data-widget_type="pxl_image.default">
          <div class="elementor-widget-container">
            <div id="pxl_image-1392b33-1139" class="pxl-image-wg d-flex default">
              <img loading="lazy" width="60" height="60" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/img6-pagetitle.webp'); ?>" class="attachment-full size-full wp-image-336" alt="" />
            </div>
          </div>
        </div>
        <div class="elementor-element elementor-element-745c6de elementor-widget elementor-widget-pxl_heading" data-id="745c6de" data-element_type="widget" data-settings='{"title_sp_type":"words","title_sp_opacity":0}' data-widget_type="pxl_heading.default">
          <div class="elementor-widget-container">
            <div id="pxl-pxl_heading-745c6de-6898" class="pxl-heading-wrap d-flex">
              <div class="pxl-heading-inner">
                <h2 class="heading-title pxl-split-text pxl_title_split_text words">
                  <?php echo $page_data['title']; ?>
                </h2>
              </div>
            </div>
          </div>
        </div>
        <div class="elementor-element elementor-element-fc08cb3 elementor-widget elementor-widget-pxl_text_editor" data-id="fc08cb3" data-element_type="widget" data-settings='{"sp_type":"lines","sp_opacity":0}' data-widget_type="pxl_text_editor.default">
          <div class="elementor-widget-container">
            <div id="pxl_text_editor-fc08cb3-3203" class="pxl-text-editor-wrap d-flex">
              <div class="pxl-text-editor elementor-clearfix pxl-split-text pxl_el_split_text lines">
                <p>
                  <?php echo $page_data['subtitle']; ?>
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="elementor-element elementor-element-194d5ec e-flex e-con-boxed e-con e-parent" data-id="194d5ec" data-element_type="container" data-settings='{"background_background":"classic"}'>
      <div class="e-con-inner"></div>
    </div>
  </div>
</div>
<div id="pxl-main" class="pxl-main page-builder-el">
  <div class="elementor-container pxl-page-content pxl-content-container">
    <div class="row pxl-content-wrap no-sidebar">
      <div id="pxl-content-area" class="pxl-content-area content-page">
        <main id="pxl-content-main" class="pxl-content-main">
          <article id="post-5209" class="post-5209 page type-page status-publish hentry">
            <div class="pxl-entry-content clearfix">
              <div data-elementor-type="wp-page" data-elementor-id="5209" class="elementor elementor-5209">
                <div class="elementor-element elementor-element-e7e6ad2 e-flex e-con-boxed e-con e-parent" data-id="e7e6ad2" data-element_type="container">
                  <div class="e-con-inner">
                    <div class="elementor-element elementor-element-cf98e83 e-con-full e-flex e-con e-child" data-id="cf98e83" data-element_type="container">
                      <div class="elementor-element elementor-element-a2277f1 e-con-full e-flex e-con e-child" data-id="a2277f1" data-element_type="container">
                        <div class="elementor-element elementor-element-58ac626 pxl-anm-pxl_fadeInUp pxl-invisible elementor-widget elementor-widget-pxl_fancy_box" data-id="58ac626" data-element_type="widget" data-settings='{"pxl_animation":"pxl_fadeInUp","pxl_animation_delay":0.200000000000000011102230246251565404236316680908203125}' data-widget_type="pxl_fancy_box.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-fancybox-wrap d-flex layout-1">
                              <div class="fancybox-inner w-100 relative">
                                <div class="pxl-fancybox-content">
                                  <div class="item-image">
                                    <img loading="lazy" decoding="async" width="83" height="78" src="<?php echo base_url('uploads/frontend/about/' . $servicon['icon1_image']); ?>" class="no-lazyload attachment-full" alt="" />
                                  </div>
                                  <h4 class="title"><?php echo $servtitle['title_1']; ?></h4>
                                  <div class="desc">
                                    <?php echo $servtext['icon1_text']; ?>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div data-parallax='{"y":"30"}' class="elementor-element elementor-element-b2484a9 elementor-absolute e-transform elementor-hidden-mobile elementor-widget elementor-widget-pxl_divider" data-id="b2484a9" data-element_type="widget" data-settings='{"_position":"absolute","_transform_translateY_effect":{"unit":"%","size":-50,"sizes":[]},"_transform_translateY_effect_laptop":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile":{"unit":"px","size":"","sizes":[]}}' data-widget_type="pxl_divider.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-widget-divider">
                              <div class="pxl-divider style1"></div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="elementor-element elementor-element-b6a0d4b e-con-full e-flex e-con e-child" data-id="b6a0d4b" data-element_type="container">
                        <div class="elementor-element elementor-element-bab3b97 pxl-anm-pxl_fadeInUp pxl-invisible elementor-widget elementor-widget-pxl_fancy_box" data-id="bab3b97" data-element_type="widget" data-settings='{"pxl_animation":"pxl_fadeInUp","pxl_animation_delay":0.40000000000000002220446049250313080847263336181640625}' data-widget_type="pxl_fancy_box.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-fancybox-wrap d-flex layout-1">
                              <div class="fancybox-inner w-100 relative">
                                <div class="pxl-fancybox-content">
                                  <div class="item-image">
                                    <img loading="lazy" decoding="async" width="87" height="78" src="<?php echo base_url('uploads/frontend/about/' . $servicon['icon2_image']); ?>" class="no-lazyload attachment-full" alt="" />
                                  </div>
                                  <h4 class="title"><?php echo $servtitle['title_2']; ?></h4>
                                  <div class="desc">
                                    <?php echo $servtext['icon2_text']; ?>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div data-parallax='{"y":"-30"}' class="elementor-element elementor-element-0666481 elementor-absolute e-transform elementor-hidden-tablet elementor-hidden-mobile_extra elementor-hidden-mobile elementor-widget elementor-widget-pxl_divider" data-id="0666481" data-element_type="widget" data-settings='{"_position":"absolute","_transform_translateY_effect":{"unit":"%","size":-50,"sizes":[]},"_transform_translateY_effect_laptop":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile":{"unit":"px","size":"","sizes":[]}}' data-widget_type="pxl_divider.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-widget-divider">
                              <div class="pxl-divider style1"></div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="elementor-element elementor-element-a398603 e-con-full e-flex e-con e-child" data-id="a398603" data-element_type="container">
                        <div class="elementor-element elementor-element-08b7a55 pxl-anm-pxl_fadeInUp pxl-invisible elementor-widget elementor-widget-pxl_fancy_box" data-id="08b7a55" data-element_type="widget" data-settings='{"pxl_animation":"pxl_fadeInUp","pxl_animation_delay":0.59999999999999997779553950749686919152736663818359375}' data-widget_type="pxl_fancy_box.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-fancybox-wrap d-flex layout-1">
                              <div class="fancybox-inner w-100 relative">
                                <div class="pxl-fancybox-content">
                                  <div class="item-image">
                                    <img loading="lazy" decoding="async" width="70" height="76" src="<?php echo base_url('uploads/frontend/about/' . $servicon['icon3_image']); ?>" class="no-lazyload attachment-full" alt="" />
                                  </div>
                                  <h4 class="title"><?php echo $servtitle['title_3']; ?></h4>
                                  <div class="desc">
                                    <?php echo $servtext['icon3_text']; ?>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div data-parallax='{"y":"30"}' class="elementor-element elementor-element-f69e08b elementor-absolute e-transform elementor-hidden-mobile elementor-widget elementor-widget-pxl_divider" data-id="f69e08b" data-element_type="widget" data-settings='{"_position":"absolute","_transform_translateY_effect":{"unit":"%","size":-50,"sizes":[]},"_transform_translateY_effect_laptop":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile":{"unit":"px","size":"","sizes":[]}}' data-widget_type="pxl_divider.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-widget-divider">
                              <div class="pxl-divider style1"></div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="elementor-element elementor-element-f0d6261 e-con-full e-flex e-con e-child" data-id="f0d6261" data-element_type="container">
                        <div class="elementor-element elementor-element-ec083d7 pxl-anm-pxl_fadeInUp pxl-invisible elementor-widget elementor-widget-pxl_fancy_box" data-id="ec083d7" data-element_type="widget" data-settings='{"pxl_animation":"pxl_fadeInUp","pxl_animation_delay":0.8000000000000000444089209850062616169452667236328125}' data-widget_type="pxl_fancy_box.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-fancybox-wrap d-flex layout-1">
                              <div class="fancybox-inner w-100 relative">
                                <div class="pxl-fancybox-content">
                                  <div class="item-image">
                                    <img loading="lazy" decoding="async" width="82" height="78" src="<?php echo base_url('uploads/frontend/about/' . $servicon['icon4_image']); ?>" class="no-lazyload attachment-full" alt="" />
                                  </div>
                                  <h4 class="title">
                                    <?php echo $servtitle['title_4']; ?>
                                  </h4>
                                  <div class="desc">
                                    <?php echo $servtext['icon4_text']; ?>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>





                <div class="elementor-element elementor-element-1da5b8a e-flex e-con-boxed e-con e-parent" data-id="1da5b8a" data-element_type="container">
                  <div class="e-con-inner">
                    <div class="elementor-element elementor-element-1d3eb7c e-con-full e-flex elementor-invisible e-con e-child" data-id="1d3eb7c" data-element_type="container" data-settings='{"position":"absolute","animation":"zoomIn","animation_delay":400}'>
                      <div class="elementor-element elementor-element-d475a76 pxl-parallax-effect mouse-move bound-section elementor-widget elementor-widget-pxl_image" data-id="d475a76" data-element_type="widget" data-widget_type="pxl_image.default">
                        <div class="elementor-widget-container">
                          <div id="pxl_image-d475a76-1749" class="pxl-image-wg d-flex animated-rotate">
                            <img loading="lazy" decoding="async" width="124" height="121" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img2-sun.webp'); ?>" class="attachment-full size-full wp-image-5739" alt="" />
                          </div>
                        </div>
                      </div>
                      <div class="elementor-element elementor-element-154b4f4 elementor-absolute pxl-parallax-effect mouse-move bound-section elementor-widget__width-inherit e-transform elementor-widget elementor-widget-pxl_image" data-id="154b4f4" data-element_type="widget" data-settings='{"_position":"absolute","_transform_translateY_effect":{"unit":"%","size":-50,"sizes":[]},"_transform_translateY_effect_laptop":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile":{"unit":"px","size":"","sizes":[]}}' data-widget_type="pxl_image.default">
                        <div class="elementor-widget-container">
                          <div id="pxl_image-154b4f4-1207" class="pxl-image-wg d-flex default">
                            <img loading="lazy" decoding="async" width="84" height="86" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img1-sun.webp'); ?>" class="attachment-full size-full wp-image-5738" alt="" />
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-b12c808 e-con-full e-flex e-con e-child" data-id="b12c808" data-element_type="container">
                      <div class="elementor-element elementor-element-a37a6ec elementor-widget elementor-widget-pxl_image" data-id="a37a6ec" data-element_type="widget" data-settings='{"position":"absolute"}' data-widget_type="pxl_image.default">
                        <div class="elementor-widget-container">
                          <div id="pxl_image-a37a6ec-4048" class="pxl-image-wg d-flex pxl-bg-parallax default">
                            <div class="parallax-inner" data-parallax='{"z":50}' style="
                                      --pxl-image-bg: url(<?php echo base_url('uploads/frontend/about/' . $servicon['vidbanner']); ?>);
                                    "></div>
                          </div>
                        </div>
                      </div>
                      <div class="elementor-element elementor-element-ed09c50 elementor-absolute e-transform pxl-video-layout-1 elementor-widget elementor-widget-pxl_video" data-id="ed09c50" data-element_type="widget" data-settings='{"_position":"absolute","_transform_translateY_effect":{"unit":"%","size":-50,"sizes":[]},"_transform_translateY_effect_laptop":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect":{"unit":"%","size":-50,"sizes":[]},"_transform_translateX_effect_laptop":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect_tablet":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect_mobile":{"unit":"%","size":"","sizes":[]}}' data-widget_type="pxl_video.default">
                        <div class="elementor-widget-container">
                          <div class="pxl-video-player relative btn-style-df layout-1">
                            <div class="pxl-video-lightbox" data-elementor-open-lightbox="yes" data-elementor-lightbox='{"type":"video","videoType":"youtube","url":"https://www.youtube.com/embed/lG0Z8BST8uE?feature=oembed&amp;loop=0&amp;controls=1&amp;mute=0&amp;rel=0&amp;modestbranding=0","modalOptions":{"id":"pxl-lightbox-ed09c50","entranceAnimation":"fadeInUp","entranceAnimation_tablet":"","entranceAnimation_mobile":"","videoAspectRatio":"169"}}'>
                              <div class="btn-video-wrap d-flex-wrap">
                                <div class="pxl-video-btn">
                                  <svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 357.25 367.02">
                                    <defs>
                                      <style>
                                        .cls-1 {
                                          fill: #c8d3dd;
                                        }

                                        .cls-2 {
                                          fill: #fff;
                                        }

                                        .cls-3 {
                                          fill: #26a7e2ff;
                                        }

                                        .cls-4 {
                                          fill: #4d0dffff;
                                        }

                                        .cls-5 {
                                          fill: #2663f1ff;
                                        }
                                      </style>
                                    </defs>
                                    <path class="cls-1" d="M420.77,237.22c0,98.49-80.13,178.62-178.63,178.62S63.52,335.71,63.52,237.22v-9.77H420.77Z" transform="translate(-63.52 -48.82)"></path>
                                    <circle class="cls-2" cx="242.14" cy="227.45" r="178.62" transform="translate(-153.43 189.01) rotate(-45)"></circle>
                                    <circle class="cls-3" cx="242.14" cy="219.45" r="156.62" transform="translate(-147.77 186.67) rotate(-45)"></circle>
                                    <circle class="cls-4" cx="242.14" cy="209.54" r="141.26" transform="translate(-140.77 183.77) rotate(-45)"></circle>
                                    <path class="cls-5" d="M210.28,95.2c9.34,16.64-12.39,22-36.62,46.22s-38.37,49.35-49.69,38-.88-40.15,23.35-64.37S203.49,83.09,210.28,95.2Z" transform="translate(-63.52 -48.82)"></path>
                                    <path class="cls-5" d="M241.08,100.15c-9.82,1.12-17.82,1.77-18.75-6.43S228.6,78,238.42,76.85s18.53,4.62,19.47,12.8S250.89,99,241.08,100.15Z" transform="translate(-63.52 -48.82)"></path>
                                    <path class="cls-2" d="M198.37,264.12V164.77a17.51,17.51,0,0,1,27.57-14.32l70.73,49.67a17.51,17.51,0,0,1,0,28.65l-70.73,49.67A17.51,17.51,0,0,1,198.37,264.12Z" transform="translate(-63.52 -48.82)"></path>
                                  </svg>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>





                <div class="elementor-element elementor-element-97a27e5 e-flex e-con-boxed e-con e-parent" data-id="97a27e5" data-element_type="container">
                  <div class="e-con-inner">
                    <div class="elementor-element elementor-element-adaa68f elementor-absolute pxl-anm-pxl_zoomIn heartbeat-1 pxl-invisible elementor-widget elementor-widget-pxl_image" data-id="adaa68f" data-element_type="widget" data-settings='{"_position":"absolute","pxl_animation":"pxl_zoomIn","pxl_animation_duration":0.59999999999999997779553950749686919152736663818359375,"pxl_animation_delay":0.200000000000000011102230246251565404236316680908203125}' data-widget_type="pxl_image.default">
                      <div class="elementor-widget-container">
                        <div id="pxl_image-adaa68f-3890" class="pxl-image-wg d-flex default">
                          <img loading="lazy" decoding="async" width="30" height="32" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-about.webp'); ?>" class="attachment-full size-full wp-image-8367" alt="" />
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-472bf63 elementor-absolute pxl-anm-pxl_zoomIn heartbeat-3 pxl-invisible elementor-widget elementor-widget-pxl_image" data-id="472bf63" data-element_type="widget" data-settings='{"_position":"absolute","pxl_animation":"pxl_zoomIn","pxl_animation_duration":0.59999999999999997779553950749686919152736663818359375,"pxl_animation_delay":0.6999999999999999555910790149937383830547332763671875}' data-widget_type="pxl_image.default">
                      <div class="elementor-widget-container">
                        <div id="pxl_image-472bf63-9961" class="pxl-image-wg d-flex default">
                          <img loading="lazy" decoding="async" width="49" height="55" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img3b-about.webp'); ?>" class="attachment-full size-full wp-image-8368" alt="" />
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-de21145 elementor-absolute pxl-anm-pxl_zoomIn heartbeat-2 pxl-invisible elementor-widget elementor-widget-pxl_image" data-id="de21145" data-element_type="widget" data-settings='{"_position":"absolute","pxl_animation":"pxl_zoomIn","pxl_animation_duration":0.59999999999999997779553950749686919152736663818359375,"pxl_animation_delay":0.5}' data-widget_type="pxl_image.default">
                      <div class="elementor-widget-container">
                        <div id="pxl_image-de21145-2981" class="pxl-image-wg d-flex default">
                          <img loading="lazy" decoding="async" width="39" height="41" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img1b-about.webp'); ?>" class="attachment-full size-full wp-image-8366" alt="" />
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-31eddde e-con-full e-flex e-con e-child" data-id="31eddde" data-element_type="container">
                      <div class="elementor-element elementor-element-9368dbd e-con-full e-flex e-con e-child" data-id="9368dbd" data-element_type="container">
                        <div class="elementor-element elementor-element-ffa9570 elementor-widget elementor-widget-pxl_text_editor" data-id="ffa9570" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                          <div class="elementor-widget-container">
                            <div id="pxl_text_editor-ffa9570-1657" class="pxl-text-editor-wrap d-flex">
                              <div class="pxl-text-editor elementor-clearfix">
                                <p>
                                  <?php echo $content['Who_we_are']; ?>
                                </p>
                              </div>
                            </div>
                          </div>
                        </div>

                      </div>





                      <div class="elementor-element elementor-element-e9554b1 e-con-full e-flex e-con e-child" data-id="e9554b1" data-element_type="container">
                        <div class="elementor-element elementor-element-8669aae pxl-icon-list--layout--traditional elementor-widget elementor-widget-pxl_icon_list" data-id="8669aae" data-element_type="widget" data-widget_type="pxl_icon_list.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-icon-list-wg items-traditional icon-type-icon">
                              <div class="list-item relative d-flex item-traditional elementor-repeater-item-c8b9a24 pxl-hover-anm">
                                <span class="pxl-icon d-inline-flex flex-shrink-0">
                                  <span class="icon-inner none-anm">
                                    <i aria-hidden="true" class="pxli pxli-circle-check-solid"></i>
                                  </span>
                                </span>
                                <div class="box-content">
                                  <span class="item-ask-icon"></span>
                                  <div class="item-content">
                                    <span class="item-title">
                                      <?php echo $content['goal_1']; ?>
                                    </span>
                                  </div>
                                </div>
                              </div>
                              <div class="list-item relative d-flex item-traditional elementor-repeater-item-490de3d pxl-hover-anm">
                                <span class="pxl-icon d-inline-flex flex-shrink-0">
                                  <span class="icon-inner none-anm">
                                    <i aria-hidden="true" class="pxli pxli-circle-check-solid"></i>
                                  </span>
                                </span>
                                <div class="box-content">
                                  <span class="item-ask-icon"></span>
                                  <div class="item-content">
                                    <span class="item-title">
                                      <?php echo $content['goal_2']; ?>
                                    </span>
                                  </div>
                                </div>
                              </div>
                              <div class="list-item relative d-flex item-traditional elementor-repeater-item-14c1327 pxl-hover-anm">
                                <span class="pxl-icon d-inline-flex flex-shrink-0">
                                  <span class="icon-inner none-anm">
                                    <i aria-hidden="true" class="pxli pxli-circle-check-solid"></i>
                                  </span>
                                </span>
                                <div class="box-content">
                                  <span class="item-ask-icon"></span>
                                  <div class="item-content">
                                    <span class="item-title">
                                      <?php echo $content['goal_3']; ?>
                                    </span>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="elementor-element elementor-element-89a6fe8 pxl-anm-pxl_fadeInUp pxl-invisible elementor-widget elementor-widget-pxl_button" data-id="89a6fe8" data-element_type="widget" data-settings='{"pxl_animation":"pxl_fadeInUp"}' data-widget_type="pxl_button.default">
                          <div class="elementor-widget-container">
                            <div id="pxl_button-89a6fe8-2606" class="pxl-button-wrapper d-flex align-items-center">
                              <a href="/champions/admission" class="pxl-btn btn-second icon-ps-right">
                                <span class="pxl-button-text icon-move" data-text="<?php echo $content['reg_button']; ?>"><?php echo $content['reg_button']; ?></span>
                              </a>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="elementor-element elementor-element-470951d e-flex e-con-boxed e-con e-parent" data-id="470951d" data-element_type="container" data-settings='{"background_background":"classic"}'>
                  <div class="e-con-inner">
                    <div class="elementor-element elementor-element-023116b elementor-absolute duck-run elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="023116b" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeInRight","_animation_delay":400}' data-widget_type="pxl_image.default">
                      <div class="elementor-widget-container">
                        <div id="pxl_image-023116b-1184" class="pxl-image-wg d-flex default">
                          <img loading="lazy" decoding="async" width="94" height="100" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img5-enrollment.webp'); ?>" class="attachment-full size-full wp-image-2793" alt="" />
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-4ad2791 pxl-logo-marquee-layout-3 elementor-absolute elementor-widget elementor-widget-pxl_logo_marquee" data-id="4ad2791" data-element_type="widget" data-settings='{"_position":"absolute"}' data-widget_type="pxl_logo_marquee.default">
                      <div class="elementor-widget-container">
                        <div class="pxl-logo-marquee1 layout-3">
                          <div class="pxl-logo-active pxl-flex-middle">
                            <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-d3456e2" data-speed="0.3" data-slip-type="right">
                              <div class="pxl-item--inner pxl-flex-middle">
                                <div class="item-image">
                                  <img loading="lazy" decoding="async" width="1900" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-home1.webp'); ?>" class="no-lazyload attachment-full" alt="" />
                                </div>
                              </div>
                            </div>
                            <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-b0d4c76" data-speed="0.3" data-slip-type="right">
                              <div class="pxl-item--inner pxl-flex-middle">
                                <div class="item-image">
                                  <img loading="lazy" decoding="async" width="1900" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-home1.webp'); ?>" class="no-lazyload attachment-full" alt="" />
                                </div>
                              </div>
                            </div>
                            <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-84a47db" data-speed="0.3" data-slip-type="right">
                              <div class="pxl-item--inner pxl-flex-middle">
                                <div class="item-image">
                                  <img loading="lazy" decoding="async" width="1900" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-home1.webp'); ?>" class="no-lazyload attachment-full" alt="" />
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-bc26ed8 e-con-full e-flex e-con e-child" data-id="bc26ed8" data-element_type="container">
                      <div class="elementor-element elementor-element-a39789d e-con-full e-flex e-con e-child" data-id="a39789d" data-element_type="container">
                        <div class="elementor-element elementor-element-1bd3c79 e-con-full e-flex e-con e-child" data-id="1bd3c79" data-element_type="container">
                          <div class="elementor-element elementor-element-7de81b1 pxl-anm-gsap anm-assign-for-desc elementor-widget elementor-widget-pxl_fancy_box" data-id="7de81b1" data-element_type="widget" data-settings='{"pxl_animation":"gsap","pxl_anm_el_class_apply":"desc","pxl_from_opacity":0,"pxl_to_opacity":1,"pxl_once":"1","pxl_toggle_actions":"play none none none"}' data-widget_type="pxl_fancy_box.default">
                            <div class="elementor-widget-container">
                              <div class="pxl-fancybox-wrap d-flex layout-3">
                                <div class="fancybox-inner w-100 relative pxl-animated-waypoint">
                                  <div class="pxl-fancybox-content">
                                    <h5 class="title">
                                      <?php echo $content['vision_title']; ?>
                                    </h5>
                                    <div class="desc">
                                      <?php echo $content['vision_description']; ?>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="elementor-element elementor-element-f46a5e7 e-con-full e-flex e-con e-child" data-id="f46a5e7" data-element_type="container" data-settings='{"background_background":"classic"}'>
                          <div class="elementor-element elementor-element-eb5399a pxl-anm-gsap anm-assign-for-desc elementor-widget elementor-widget-pxl_fancy_box" data-id="eb5399a" data-element_type="widget" data-settings='{"pxl_animation":"gsap","pxl_anm_el_class_apply":"desc","pxl_from_opacity":0,"pxl_to_opacity":1,"pxl_once":"1","pxl_toggle_actions":"play none none none"}' data-widget_type="pxl_fancy_box.default">
                            <div class="elementor-widget-container">
                              <div class="pxl-fancybox-wrap d-flex layout-3">
                                <div class="fancybox-inner w-100 relative pxl-animated-waypoint">
                                  <div class="pxl-fancybox-content">
                                    <h5 class="title">
                                      <?php echo $content['mission_title']; ?>
                                    </h5>
                                    <div class="desc">
                                      <?php echo $content['mission_description']; ?>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <?php
                      if (!empty($statistics)) {
                        $statisticsElem = json_decode($statistics['elements'], true);
                      ?>
                        <div class="elementor-element elementor-element-6566fbe e-con-full e-flex e-con e-child" data-id="6566fbe" data-element_type="container">
                          <div class="elementor-element elementor-element-56d60f0 e-con-full e-flex e-con e-child" data-id="56d60f0" data-element_type="container">
                            <div class="elementor-element elementor-element-7b15bd6 elementor-widget elementor-widget-pxl_counter" data-id="7b15bd6" data-element_type="widget" data-widget_type="pxl_counter.default">
                              <div class="elementor-widget-container">
                                <div class="pxl-counter-wg gx-16 layout-1">
                                  <div class="counter-number">
                                    <span class="counter-number-value" data-duration="2" data-start="1" data-delimiter="no"><?php echo $this->home_model->getStatisticsCounter($statisticsElem['type_4'], $branchID); ?></span>
                                    <span class="counter-number-suffix">+</span>
                                  </div>
                                  <div class="counter-title p">
                                    Excellence in Early Learning
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="elementor-element elementor-element-ad97467 e-con-full e-flex e-con e-child" data-id="ad97467" data-element_type="container">
                            <div class="elementor-element elementor-element-9b76c05 elementor-widget elementor-widget-pxl_counter" data-id="9b76c05" data-element_type="widget" data-widget_type="pxl_counter.default">
                              <div class="elementor-widget-container">
                                <div class="pxl-counter-wg gx-16 layout-1">
                                  <div class="counter-number">
                                    <span class="counter-number-value" data-duration="2" data-start="1" data-delimiter="no"><?php echo $this->home_model->getStatisticsCounter($statisticsElem['type_1'], $branchID); ?></span>
                                  </div>
                                  <div class="counter-title p">
                                    Dedicated Teachers
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="elementor-element elementor-element-054f6d1 e-con-full e-flex e-con e-child" data-id="054f6d1" data-element_type="container">
                            <div class="elementor-element elementor-element-026885a elementor-widget elementor-widget-pxl_counter" data-id="026885a" data-element_type="widget" data-widget_type="pxl_counter.default">
                              <div class="elementor-widget-container">
                                <div class="pxl-counter-wg gx-16 layout-1">
                                  <div class="counter-number">
                                    <span class="counter-number-value" data-duration="2" data-start="1" data-delimiter="no"><?php echo $this->home_model->getStatisticsCounter($statisticsElem['type_2'], $branchID); ?></span>
                                  </div>
                                  <div class="counter-title p">
                                    Smiling Learners Enrolled
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="elementor-element elementor-element-0343005 e-con-full e-flex e-con e-child" data-id="0343005" data-element_type="container">
                            <div class="elementor-element elementor-element-57d4a2a elementor-widget elementor-widget-pxl_counter" data-id="57d4a2a" data-element_type="widget" data-widget_type="pxl_counter.default">
                              <div class="elementor-widget-container">
                                <div class="pxl-counter-wg gx-16 layout-1">
                                  <div class="counter-number">
                                    <span class="counter-number-value" data-duration="2" data-start="1" data-delimiter="no">92</span>
                                    <span class="counter-number-suffix">%</span>
                                  </div>
                                  <div class="counter-title p">
                                    Parent Satisfaction Rate
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>





                    </div>
                  </div>
                </div>
              <?php } ?>
              <div class="elementor-element elementor-element-45666b5 e-flex e-con-boxed e-con e-parent" data-id="45666b5" data-element_type="container">
                <div class="e-con-inner">
                  <div class="elementor-element elementor-element-2a77509 e-con-full e-flex e-con e-child" data-id="2a77509" data-element_type="container">
                    <div class="elementor-element elementor-element-104371d elementor-widget elementor-widget-pxl_heading" data-id="104371d" data-element_type="widget" data-settings='{"title_sp_type":"words-scale"}' data-widget_type="pxl_heading.default">
                      <div class="elementor-widget-container">
                        <div id="pxl-pxl_heading-104371d-8976" class="pxl-heading-wrap d-flex">
                          <div class="pxl-heading-inner">
                            <h2 class="heading-title pxl-split-text pxl_title_split_text words-scale">
                              <p><?php echo $our_values['title'] ?>
                            </h2>
                            <div class="heading-subtitle">
                              <div class="subtitle-text">
                                <p><?php echo $our_values['description'] ?>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-db8777f elementor-widget__width-auto elementor-widget elementor-widget-pxl_moving_path" data-id="db8777f" data-element_type="widget" data-widget_type="pxl_moving_path.default">
                      <div class="elementor-widget-container">
                        <div class="pxl-moving-path layout-1" data-duration="3.5" data-direction="rtl">
                          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 100">
                            <path d="M10 40 Q 100 90, 190 40" fill="transparent" stroke="black" stroke-dasharray="2,2" stroke-width="1"></path>
                          </svg>
                          <div class="target-wrap">
                            <img loading="lazy" decoding="async" width="36" height="36" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/bee-img.webp'); ?>" class="attachment-full" alt="" />
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-61d9ff7 pxl-swiper-arrows-true pxl-swiper-dots-false pxl-swiper-dots-bullets elementor-widget elementor-widget-pxl_fancy_box_carousel" data-id="61d9ff7" data-element_type="widget" data-widget_type="pxl_fancy_box_carousel.default">
                      <div class="elementor-widget-container">
                        <div class="pxl-swiper-slider pxl-fancy-box-carousel layout-2">
                          <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
                            <div class="pxl-swiper-container" dir="ltr" data-settings='{"slide_direction":"horizontal","slide_percolumn":1,"slide_mode":"slide","slides_to_show_xxl":3,"slides_to_show":3,"slides_to_show_lg":2,"slides_to_show_md":2,"slides_to_show_sm":2,"slides_to_show_xs":1,"slides_to_scroll":1,"slides_gutter":31,"slides_gutter_xl":31,"slides_gutter_lg":31,"slides_gutter_md":31,"slides_gutter_sm":20,"slides_gutter_xs":20,"center_slide":false,"loop":false,"pause_on_hover":false,"autoplay":false,"pause_on_interaction":true,"delay":5000,"speed":500,"dots_style":"bullets","set_timeout":true}'>
                              <div class="pxl-swiper-wrapper swiper-wrapper">

                                <?php
                                $this->db->where('branch_id', $branchID);
                                $our_values = $this->db->get('front_cms_our_values')->result_array();

                                $colors = ['#FFD6A5', '#FDFFB6', '#CAFFBF', '#9BF6FF', '#A0C4FF', '#BDB2FF', '#FFC6FF'];

                                // Define an array of background colors
                                $colors2 = ['#FF6B6B', '#4ECDC4', '#099327ff', '#6A4C93', '#FF9F1C'];

                                // Randomize border-radius for unique shapes
                                $borderRadius = rand(5, 40) . '% ' . rand(15, 45) . '% ' . rand(5, 22) . '% ' . rand(28, 20) . '%';

                                // Counter to rotate colors
                                $colorIndex = 0;
                                $color2Index = 0;

                                if (!empty($our_values)) {
                                  $i = 0;
                                  foreach ($our_values as $value) {
                                    // rotate colors through the array

                                    $bgColor = $colors[$i % count($colors)];
                                    $i++;

                                    // Get the current color
                                    $bgColor2 = $colors2[$color2Index];

                                    // Increment counter and loop back if needed
                                    $color2Index++;
                                    if ($color2Index >= count($colors2)) {
                                      $color2Index = 0;
                                    }
                                ?>
                                    <div class="pxl-swiper-slide swiper-slide">
                                      <div class="item-inner" style="background-color: <?php echo $bgColor; ?>; border-radius: <?php echo $borderRadius; ?>; padding: 20px; transition: 0.3s;">
                                        <div class="box-icon">
                                          <span class="item-icon" style="background-color: <?php echo $bgColor2; ?>;">
                                            <?php echo $value['icon'] ?>
                                          </span>
                                        </div>
                                        <div class="item-content">
                                          <h3 class="item-title">
                                            <span><?php echo $value['title'] ?></span>
                                          </h3>
                                          <div class="item-description">
                                            <?php echo $value['description'] ?>
                                          </div>
                                        </div>
                                      </div>
                                    </div>


                                  <?php }
                                } else {
                                  ?>
                                  <div class="pxl-swiper-slide swiper-slide">
                                    <div class="item-inner" style="background-color: #eee; border-radius: 15px; padding: 20px;">
                                      <div class="item-content">
                                        <h3 class="item-title"><span>No Values Found</span></h3>
                                        <div class="item-description">Please add values in the backend.</div>
                                      </div>
                                    </div>
                                  </div>
                                <?php
                                } ?>

                              </div>
                            </div>
                          </div>
                          <div class="pxl-swiper-arrows nav-out-vertical">
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                              <span class="pxl-icon"><span aria-hidden="true" class="pxli pxli-arrow-leftnew"></span></span>
                            </div>
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
                              <span class="pxl-icon"><span aria-hidden="true" class="pxli pxli-arrow-leftnew"></span></span>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="elementor-element elementor-element-aa8832c e-con-full e-flex e-con e-parent" data-id="aa8832c" data-element_type="container">
                <div class="elementor-element elementor-element-f6420d4 e-flex e-con-boxed e-con e-child" data-id="f6420d4" data-element_type="container" data-settings='{"background_background":"classic"}'>
                  <div class="e-con-inner">
                    <div class="elementor-element elementor-element-92fec61 elementor-absolute e-transform elementor-invisible elementor-widget elementor-widget-pxl_shape" data-id="92fec61" data-element_type="widget" data-settings='{"_position":"absolute","_transform_translateY_effect":{"unit":"%","size":45,"sizes":[]},"_transform_translateY_effect_laptop":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile":{"unit":"%","size":"","sizes":[]},"_animation":"fadeInUp","_animation_delay":400,"_transform_translateX_effect":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile":{"unit":"px","size":"","sizes":[]}}' data-widget_type="pxl_shape.default">
                      <div class="elementor-widget-container">
                        <div class="pxl-shape-wg style2"></div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-b152489 elementor-absolute elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="b152489" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeInRight","_animation_delay":400}' data-widget_type="pxl_image.default">
                      <div class="elementor-widget-container">
                        <div id="pxl_image-b152489-8230" class="pxl-image-wg d-flex default" data-parallax='{"x":"50"}'>
                          <img loading="lazy" decoding="async" width="263" height="409" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img10-about.webp'); ?>" class="attachment-full size-full wp-image-5349" alt="" />
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-a301630 pxl-logo-marquee-layout-3 elementor-absolute elementor-widget elementor-widget-pxl_logo_marquee" data-id="a301630" data-element_type="widget" data-settings='{"_position":"absolute"}' data-widget_type="pxl_logo_marquee.default">
                      <div class="elementor-widget-container">
                        <div class="pxl-logo-marquee1 layout-3">
                          <div class="pxl-logo-active pxl-flex-middle">
                            <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-d3456e2" data-speed="0.3" data-slip-type="left">
                              <div class="pxl-item--inner pxl-flex-middle">
                                <div class="item-image">
                                  <img loading="lazy" decoding="async" width="1900" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-home1.webp'); ?>" class="no-lazyload attachment-full" alt="" />
                                </div>
                              </div>
                            </div>
                            <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-b0d4c76" data-speed="0.3" data-slip-type="left">
                              <div class="pxl-item--inner pxl-flex-middle">
                                <div class="item-image">
                                  <img loading="lazy" decoding="async" width="1900" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-home1.webp'); ?>" class="no-lazyload attachment-full" alt="" />
                                </div>
                              </div>
                            </div>
                            <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-2b7f596" data-speed="0.3" data-slip-type="left">
                              <div class="pxl-item--inner pxl-flex-middle">
                                <div class="item-image">
                                  <img loading="lazy" decoding="async" width="1900" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-home1.webp'); ?>" class="no-lazyload attachment-full" alt="" />
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-c9bd796 e-con-full e-flex e-con e-child" data-id="c9bd796" data-element_type="container">
                      <div class="elementor-element elementor-element-89094be e-con-full e-flex e-con e-child" data-id="89094be" data-element_type="container">
                        <div class="elementor-element elementor-element-7db99a6 e-con-full e-flex e-con e-child" data-id="7db99a6" data-element_type="container" data-settings='{"position":"absolute"}'>
                          <div class="elementor-element elementor-element-d3ad5b5 elementor-widget elementor-widget-pxl_shape" data-id="d3ad5b5" data-element_type="widget" data-widget_type="pxl_shape.default">
                            <div class="elementor-widget-container">
                              <div class="pxl-shape-wg style2"></div>
                            </div>
                          </div>
                          <div class="elementor-element elementor-element-a48978b elementor-widget__width-inherit elementor-absolute e-transform elementor-widget elementor-widget-pxl_icon" data-id="a48978b" data-element_type="widget" data-settings='{"_position":"absolute","_transform_translateY_effect":{"unit":"%","size":-50,"sizes":[]},"_transform_translateY_effect_laptop":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_tablet":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"%","size":"","sizes":[]},"_transform_translateY_effect_mobile":{"unit":"%","size":"","sizes":[]},"_transform_translateX_effect":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile":{"unit":"px","size":"","sizes":[]}}' data-widget_type="pxl_icon.default">
                            <div class="elementor-widget-container">
                              <div class="pxl-icon-wg">
                                <div class="icon-inner relative pxl-transition pxl-hover-anm">
                                  <span class="pxl-icon pulse"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 557.21 585.03">
                                      <defs></defs>
                                      <title>heart</title>
                                      <path d="M53.91,341.17c0-5-1.39-6.61-2.17-10.46-.46-2.23-1.33-8.33-2.17-10.85-1.85-5.51-7.62-12.34-8.94-18.1-1.57-6.83-1.51-13.66-3.92-21-3.26-10-2.1-18.27-4.14-29.2-.71-3.82-3.54-6.32-4.44-11.27-.74-4.13.75-8.66,0-12.78C26,215.7,23.79,208,23.79,194.38V165.1c0-12.13,1.81-20.8,3.85-31.47,2.5-13,4.44-23.65,8.9-36.79,4.65-13.73,12-25.21,22.35-36.12,11.84-12.45,24.78-25.07,42.32-27.43,17.11-2.31,30-4.56,48.39-.45,5.25,1.17,14.84,6.6,20.15,8.95a162.44,162.44,0,0,1,17.15,8.72c16.5,9.72,31.6,20.1,45,33.56,25.49,25.5,47.86,50,67.69,79.77,8.18,12.27,10.93,29.22,24.9,10.41,7.4-10,14.37-21.5,22.08-31.74,20.11-26.72,40.91-53.65,69.53-72.06,26.45-17,52.43-30.25,84-28.1,28.69,1.95,64.48,28,73.81,56.4,10.4,31.63,9.28,78-2.93,108.34-2.4,5.95-2.16,13.54-4.56,19.83-2.5,6.51-5.73,11.53-8.25,17.46-6,14.25-11.52,30.82-17.88,44.58-13.4,29-31.73,55.69-48.73,82.16C474.3,398,457.38,425.32,438,450.3c-17.94,23.07-32.6,47.91-53.89,69.51C369.12,535,354,550,338.85,565c-5.67,5.62-11.34,11.24-16.9,17-6.9,7.1-10.49,14.78-17.35,21.64-5.59,5.6-15,18.31-22.18,8.21-1.94-2.73,1.59-9.79-.1-12.45-.35-.55-10.57-5-11.6-5.41-11.39-4.2-23.1-5.32-34.11-12.08-26.17-16.06-53.65-34.81-71.77-59.92-11.1-15.37-26.48-29.45-37.91-44.48-8.45-11.11-14.12-24.82-21.71-36.5-10.07-15.48-18.29-31.87-26.85-48.83-5.34-10.56-11-20.89-15.31-31.85-2.75-7-4.12-13-9.15-19.11C53.91,337.4,55.55,343.16,53.91,341.17ZM381.44,213.35c4.45-7.26,15.53-11.53,10.92-20.43A49.93,49.93,0,0,0,382,206.49c-.79,1.5-5,5.12-3.16,7.43q1.14-2.47,2.56-.57C385.91,206.05,380.89,211.57,381.44,213.35ZM239.71,556c-.72-2.53-.75-6.59-4.4-3.75,3.68,3.14,15.45,18.28,22.59,15.08,2.59-1.16,4.19-5.93,3-8.89-2.85-6.8-15.18-3.64-21.14-2.44C238.76,552.63,245.66,554.77,239.71,556ZM403,240.17c-7.6,0-38.71,32.39-28.63,42.47,9.16-9.18,19.42-17.12,24.17-29.44,1.66-4.3,2.07-9,3.27-12.54.73-2.15,7.94,1,3.76-4.4L403,240.17C402.28,240.17,403.54,238.61,403,240.17ZM174.58,274.65c-.88-3.08,1.92-6.71-2.52-8.25-1.4,4.2,1.14,11.77,2.52,16.26,2.26,7.38,5.65,15.76,8.34,22.84,4.66,12.26,5.82,28.84,15.62,38.13,5.35-5.52-.14-14.75-2.35-19.26-2-4.12-2.47-10-4.39-14.11-5.54-12-10.15-24.21-17.22-35.61C173.79,271.88,178.18,280.45,174.58,274.65Zm173-99.34c-9.29,1.94-39.3,43.72-32.23,47.45,13.46,7.1,28.56-47.23,34.16-47.23-3.47,0,9-5.78,10.43-7.38,4.6-5.13,5.86-2.4,2.36-9.84-1.83,1.8-17.19,14.92-14.72,17C341.66,176.54,347,174.83,347.54,175.31Zm3.73,325.18c15.08-12,31.6-48.28,24.35-66.6-8.75,7.15-13.92,27-16.82,37.93-.37,1.42-2.47,5.77-3.15,7.34s-4.21,7.83-4.38,8.9c-.38,2.36-.34,10.85-.35,10.56.12,2.43-6.62-1.66-2.2,4a4.87,4.87,0,0,1,2.55-2.17C358.74,494.53,350.72,500.31,351.27,500.49ZM212.88,527.71c.72,2.53.74,6.59,4.4,3.75-5.45-4.64-9.44-14.65-13.49-22.23-4.18-7.81-8.62-15.86-12.62-23.8-7.94-15.75-14.28-34.64-27.58-46.88-5.71,5.66,4.25,14.29,6.33,19.86a91,91,0,0,1,2.61,10.37c.89,4.2.71,12,2.19,16.49C178,495.4,201,528.05,212.88,527.71,213.83,531.05,208,527.85,212.88,527.71ZM364.2,391c9.45-3.86,12.21-23.5,16.36-31.75s6.46-16.27,11-24.52c6.23-11.32,9.67-22.45,15.78-34.16,5.52-10.58,23.86-35.3,20.3-47,2.54-.72,6.59-.75,3.76-4.4-19.55,22.91-31.1,48.36-42.93,77.25-4.85,11.86-10.33,22.73-15.7,34.77-1.64,3.69-2.78,7.06-4.25,10.31-.78,1.73-4,7.4-4.32,8.85-.65,2.91-1.43,10.08-1.52,11.64-.26,4.51-3.61-.63-1,7.25,4.44-1.54,1.64-5.18,2.52-8.25C365.41,390.51,363.41,393.77,364.2,391ZM84.08,356.53c.88,3.08-1.92,6.71,2.52,8.25,3.34-10.09-1.59-1.12-2.52-8.25v-8q.9-4.92-4.42-7.38V336.9q1.34-6-4.55-9.16c-.72-3.29-.65-12.88,1-15.36,3.18-4.64,8.61-.85,11-5.5,2.08-4-1.7-4.4-2.24-7.39-1.51-8.32-5.52-13.7-8.37-20.91-5.82-14.72-9.87-30.13-14.9-45.14-3.06-9.15-6.65-18.2-9.32-27.29-2.35-8-2.61-18.94-9.58-26.05-3.91,4.69-2.55,23.12-1.8,29.5.67,5.7,3.28,7.05,4.48,11.67,1.41,5.48-.74,12.11,0,17.72.68,5.22,2.87,7.53,3.94,13.13.71,3.72-.68,7.83,0,11.55l4.51,4.51a23.78,23.78,0,0,0,0,8.78c1.14,4,3.1,7.52,4.3,11.54,3.2,10.77,4.68,23.58,8.67,33.88,3.83,9.87,9.41,26.9,17.25,34.15C84.87,359.3,81.44,354.09,84.08,356.53ZM501.91,67.28c-2.21-5.57-18.64-6.26-20.64,0,12.92,0,18.53-1.15,27,8.84,6.57,7.77,6.89,13.5,9.6,23.31,1.32,4.8,2.13,8.27,5.12,11.36,3.21,3.31,10.27,2.95,13.58,6.14,1.25,1.2,4,10,4.4,12.07,1,4.49-.94,9.64,0,14.14.82,3.88,4.18,4,4.14,9,0,4.36-3.16,11.19-4.42,15.4-2.42,8.1-4.72,17.2-6.29,25.33-.71,3.67-1.4,9.3-2.26,13.81-1.08,5.69-3.09,7.71-4,13-1.9,11.35-7.66,21.1-3.29,33.66,9.51-8.94,11.35-24.51,16-35.76,6.28-15.24,13-34.71,13-50.51,0-11.31,6.57-17.76,4.34-29.59-1-5.07-3.42-7.89-4.42-13.3-1.32-7.16-1.44-8.9-3.47-15.12-1.58-4.85-1.15-7.79-3.9-12.14-3.21-5.09-9.36-9.36-13.68-13.68-10.49-10.49-16.49-14-30.73-16C501.64,66.59,505.68,67.79,501.91,67.28ZM155.17,54.86c-8.6,0-12.48-2.8-20.86-4.23a83.3,83.3,0,0,0-23.23,0c-8.94,1.42-11.09.69-14,9.34-2,6.12-1.36,14.74,4,16,4.77,1.12,7.87-6.06,11.16-8.28,7-4.76,13.89-5.17,23.08-4.12,10.23,1.18,16.72,5.83,24.39,12.9,6.3,5.82,17.59,18.73,25.53,21.59,7,2.5,15.8-1,23.07,1.45,6.76,2.25,10.94,6.46,15.81,11.33C242,128.72,257.72,145.4,272,165.91a175.55,175.55,0,0,1,16.16,29.31c2,4.42,3.13,9.73,7.18,10.36,3.71.57,8.09-5.15,8.56-8.56.88-6.43-11.91-18.26-15.25-22.77-6.35-8.58-12.19-17.57-18.26-25.71-16.47-22.1-36.38-36.87-56.07-56.4-4.35-4.31-8.74-4.51-12.27-7-6.14-4.4-9.33-10.37-16.31-14.16-9.44-5.12-23.33-7.83-30.59-16.09C150.88,54.86,160.75,61.2,155.17,54.86ZM75.46,104.45c0-12.88,6-44-11.75-22.76-8.44,10.08-13.82,25.83-16.66,38.21-1.29,5.64-1.89,9.45-.59,15.9q5.45,3.13,3.14,9.53-2.19,7.26,4.37,11c.54,2.94,4.32,36.65,10.4,36.19,3.53-.26-3.27-41.91.09-46.85,3.66-5.36,12.19-4.95,15.31-11.22,3.41-6.86,1-24.92-4.31-30C75.46,94.41,76.45,105.41,75.46,104.45Zm178,384.67c-2.51,11.64,2.88,29.27,7.17,39.89a137.33,137.33,0,0,0,13.89,25.61c2.68,4,11.91,18.81,17.86,17.39,3.48-.84,7.35-13.65,7.72-15.68,1.59-8.88,2.59-15.85,3.78-24.34,1-7.2,2.94-27.25-1.32-32.41-4.86,1.25-9.21,8.63-10.09,13.2-1.21,6.35,8.79,11.4-5.85,11.82-17.75.51-23.42-24.34-33.16-35.48C251.9,496.32,257.86,494.17,253.45,489.12ZM166,372.32c-13.51-21.29-22.81-46.38-31.33-69.59-3.75-10.2-8.79-20.09-12.65-29.83-2.67-6.74-6.67-13.11-10-19.62-4.33-8.44-4.88-19.24-15.21-15.79,6.26,6.81,5.4,15.43,8.81,23.31,3,6.94,7.61,12.15,11.26,18.62,5.87,10.42,1.06,11.34,2.17,21.62.51,4.74,6.5,18.71,8.51,23.5,3.37,8,9,15.95,12.6,24.2s5.67,15.71,10.12,23.9c2.25,4.14,13.41,34,19.63,26.08,3.16-4-1.84-9.79-2.29-12.84-.61-4.1-1.61-8.7-1.61-13.56C164.53,370.05,166,375.9,166,372.32ZM165.79,208c3.47,14.74,10.4,28.32,16.1,42,3.11,7.46,5.33,25.49,13.77,28.38.8-14.75,8-27.1,2.79-42.11a207.32,207.32,0,0,0-15.32-32.9c-2.11-3.59-15.41-24-20.79-23.57-6.84.6-5.46,5.7-4.93,10.78q5.72,3,4.28,8.85-1.4,5.65,4.1,8.62C166.66,211.63,164.63,206.68,165.79,208ZM230.6,324.23c0-4,.73-8.9,0-12.86l-4.38-4.66v-9.46c-.85-2.59-3.92-13.44-8.09-13.13,0,24.42,1.91,45,3.7,68.88.63,8.33,3.65,15.24,6.06,23.25,3.05,10.15,3.79,17.67,9.52,27.35,5.69-5.7,2.26-38.5,1.77-47.5-.52-9.52-2.8-7.67-4.1-14.49-1.37-7.22,1.36-11.69-4.48-17.38C230.6,319.9,231.6,325.2,230.6,324.23Zm142.22-194c0,14.12,13.14,6.83,18.45,1.52l27.05-27.05c7.54-7.54,15.22-18.24,24-24,2.79-1.83,12.66.21,11.47-7.44-8.83-5.19-34.93,17-42.22,22.37-14.36,10.65-26,21.83-38.78,34.64C372.82,131.71,377.38,125.72,372.82,130.28ZM339.87,381.79c7.32-4.76,8.79-20.94,12.95-28.46,3.88-7,8.4-14.51,11.38-21.94,1.13-2.81,5.46-14.65,2.85-17.26-15,7.09-14.37,16.79-20.13,30.86-2.2,5.35-2.36,10.36-4.13,15.51q2.16,7.28-4.39,11.14a15.65,15.65,0,0,0,1.47,10.15C340.79,381.19,336.92,378.64,339.87,381.79ZM312.49,509.53c8.14,8.51,17.31-21.71,11.31-27.47-14.17-13.6-11.31,20.44-11.31,27.47C315.41,512.58,312.49,501.09,312.49,509.53Zm12.72-153.39c.68-6.05,11-38.15-2.71-37.67-2.35,2.65-.63,7.07-1.41,10l-4.3,4.53v10.64c0,9.61-1.41,12.5,8.42,12.5C325.94,349.64,322,356.14,325.21,356.14ZM215.72,188.46c7.2-10.51-2.43-19.11-8.94-26.19-4.57,7.72-1,26.19,8.94,26.19C219.08,183.55,214.12,188.46,215.72,188.46Zm-49.49-40.58c-2-2.16-10.38-27.61-16.69-22.68-7.18,5.61,9.21,25.53,16.69,22.68C164.48,146,164.27,148.63,166.23,147.88ZM348.06,279.44c-2.3,5.8-1.95,14.75.39,20.4,3.22-1.78,11.76-11.14,10.95-15.18-1.39-7-3.87-5.22-11.34-5.22C345.76,285.22,351.47,279.44,348.06,279.44Zm-100.22,1.89c8,7.18,7.31-2.93,6.86-5.85-.77-5.05-5.79-10.48-9.43-13.44-6.52,7.62,2.57,12.5,2.57,19.29C250.72,283.91,247.84,279.72,247.84,281.33ZM409,158.29c-1.54,4.57-10.17,15.92-2.54,17.14,8.81,1.4,15.89-17.14,2.54-17.14C408.26,160.58,410.91,158.29,409,158.29ZM222.32,232c3.69-.79,9,.82,12.11-2-2-3.16-3.36-12.77-5.31-14.34-9.12-7.32-6.8,11.87-6.8,16.35C227.43,230.86,222.32,225.32,222.32,232ZM179.2,427.51c5.3,5.83,5.42,7.1,13,5.46-1.48-11.44-13-25.2-13-5.46C181.62,430.17,179.2,423.79,179.2,427.51Zm318-319.9c-.33-3.67,2.81-9.77-.49-12.93-8.91,5.56-10.35,9.32.49,12.93C496.74,102.29,493.64,106.42,497.21,107.61ZM477.83,235.25c-1.35-2.34-.1-9.07-2.12-10.88-9,7.31-10.73,11.5,2.12,10.88C475,230.29,473.07,235.48,477.83,235.25Zm-259-101.41c-2.64,6.51.87,6.42,6.31,10.12,2.63-6.52-.87-6.42-6.31-10.12C218.74,134.05,221.39,135.58,218.83,133.84Zm53.49,75.41c5.48-6.59.91-13.55-7.16-10,1.49,1.59,4.92,10,7.16,10C272.84,208.62,267.86,209.33,272.32,209.25ZM122.08,97.33l1.59,8.59a21.27,21.27,0,0,0,8.81-6.63l-10.4-2C123,102.06,126.87,98.23,122.08,97.33ZM468.89,116.1a21.72,21.72,0,0,0,6.66-8.19c-7.83-6.5-7.4,4-6.66,8.19C471.67,112.76,468.33,112.91,468.89,116.1ZM308.51,285.42c-3.92-2.79-6.66-4-8.44.64C302.59,288.39,305,288.24,308.51,285.42ZM516.57,137.36c-2.83,2.83,1.13,3.18,2.77,1.54l-2.77-1.54C516,137.94,517.47,137.86,516.57,137.36ZM469.78,347.91q-2.85,1.68,0,4.31,2.87-1.68,0-4.31C469.31,348.39,470.26,348.87,469.78,347.91Z" transform="translate(-23.79 -30.56)"></path>
                                    </svg></span>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="elementor-element elementor-element-3681292 pxl-anm-pxl_fadeInUp pxl-invisible elementor-widget elementor-widget-pxl_image" data-id="3681292" data-element_type="widget" data-settings='{"pxl_animation":"pxl_fadeInUp"}' data-widget_type="pxl_image.default">
                          <div class="elementor-widget-container">
                            <div id="pxl_image-3681292-1426" class="pxl-image-wg d-flex default">
                              <img loading="lazy" decoding="async" width="700" height="700" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img8-about.webp'); ?>" class="attachment-full size-full wp-image-5287" alt="" srcset="
                                          <?php echo base_url('uploads/frontend/about/' . $founder['photo']); ?>         700w,
                                          <?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img8-about-300x300.webp'); ?> 300w
                                        " sizes="(max-width: 700px) 100vw, 700px" />
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="elementor-element elementor-element-b49a0e9 e-con-full e-flex e-con e-child" data-id="b49a0e9" data-element_type="container">
                        <div class="elementor-element elementor-element-94a4bd7 pxl-swiper-arrows-false pxl-swiper-dots-false pxl-swiper-dots-bullets elementor-widget elementor-widget-pxl_testimonial_carousel" data-id="94a4bd7" data-element_type="widget" data-widget_type="pxl_testimonial_carousel.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-swiper-slider pxl-testimonial-carousel layout-2">
                              <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
                                <div class="pxl-swiper-container" dir="ltr" data-settings='{"slide_direction":"horizontal","slide_percolumn":1,"slide_mode":"slide","slides_to_show_xxl":1,"slides_to_show":1,"slides_to_show_lg":1,"slides_to_show_md":1,"slides_to_show_sm":1,"slides_to_show_xs":1,"slides_to_scroll":1,"slides_gutter":15,"slides_gutter_xl":15,"slides_gutter_lg":15,"slides_gutter_md":15,"slides_gutter_sm":15,"slides_gutter_xs":15,"center_slide":false,"loop":false,"pause_on_hover":false,"autoplay":false,"pause_on_interaction":true,"delay":5000,"speed":500,"dots_style":"bullets","set_timeout":true}'>
                                  <div class="pxl-swiper-wrapper swiper-wrapper">
                                    <div class="pxl-swiper-slide swiper-slide">
                                      <div class="item-inner relative">
                                        <div class="box-icon">
                                          <div class="item-subtitle">
                                            <?php echo $founder['founder_page_title']; ?>
                                          </div>
                                          <div class="item-quote">
                                            “
                                          </div>
                                        </div>
                                        <div class="item-description">
                                          <?php echo $founder['description']; ?>
                                        </div>
                                        <div class="item-name">
                                          <?php echo $founder['founder_name']; ?>
                                        </div>
                                        <div class="item-position">
                                          <?php echo $founder['position']; ?>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="elementor-element elementor-element-fd77c46 e-flex e-con-boxed e-con e-parent" data-id="fd77c46" data-element_type="container">
                <div class="e-con-inner">
                  <div class="elementor-element elementor-element-b652bf7 elementor-absolute e-transform elementor-hidden-mobile_extra elementor-hidden-mobile elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="b652bf7" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeInLeft","_animation_delay":400,"_transform_translateY_effect":{"unit":"px","size":-2,"sizes":[]},"_transform_translateX_effect":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_tablet":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_mobile":{"unit":"px","size":"","sizes":[]}}' data-widget_type="pxl_image.default">
                    <div class="elementor-widget-container">
                      <div id="pxl_image-b652bf7-8782" class="pxl-image-wg d-flex default">
                        <img loading="lazy" decoding="async" width="273" height="169" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img2-study.webp'); ?>" class="attachment-full size-full wp-image-4744" alt="" />
                      </div>
                    </div>
                  </div>
                  <div class="elementor-element elementor-element-dc345d6 e-con-full e-flex e-con e-child" data-id="dc345d6" data-element_type="container">
                    <div class="elementor-element elementor-element-d7a665d elementor-widget elementor-widget-pxl_heading" data-id="d7a665d" data-element_type="widget" data-widget_type="pxl_heading.default">
                      <div class="elementor-widget-container">
                        <div id="pxl-pxl_heading-d7a665d-4939" class="pxl-heading-wrap d-flex">
                          <div class="pxl-heading-inner d-flex flex-column flex-column-reverse sub-top">
                            <h2 class="heading-title pxl-split-text split-lines-rotation-x">
                              <?php echo $timeline_history['th_title']; ?>
                            </h2>
                            <div class="heading-subtitle">
                              <div class="subtitle-text">
                                <?php echo $timeline_history['th_sub_title']; ?>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-c0b4a27 pxl-swiper-arrows-true pxl-swiper-dots-false pxl-swiper-dots-bullets elementor-widget elementor-widget-pxl_history_carousel" data-id="c0b4a27" data-element_type="widget" data-widget_type="pxl_history_carousel.default">
                      <div class="elementor-widget-container">
                        <div class="pxl-swiper-slider pxl-history-carousel layout-1">
                          <div class="pxl-swiper-slider-thumbs">
                            <div class="pxl-swiper-slider-inner pxl-carousel-inner">
                              <div class="pxl-swiper-thumbs" data-settings='{"allow_touch_move":false,"slide_direction":"horizontal","slide_percolumn":1,"slide_mode":"slide","slides_to_show_xxl":5,"slides_to_show":5,"slides_to_show_lg":4,"slides_to_show_md":4,"slides_to_show_sm":3,"slides_to_show_xs":2,"slides_to_scroll":1,"slides_gutter":15,"arrow":false,"dots":false,"speed":500,"loop":false}'>
                                <div class="pxl-thumbs-wrapper swiper-wrapper">


                                  <?php foreach ($timeline_historylist as $key => $value): ?>
                                    <div class="pxl-swiper-slide thumb-item swiper-slide">
                                      <div class="thumbs-wrap d-flex">
                                        <span class="item-history"><?php echo html_escape($value['year_range']); ?></span>
                                        <div class="item-dot"></div>
                                      </div>
                                    </div>
                                  <?php endforeach; ?>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
                            <div class="pxl-swiper-container" dir="ltr" data-settings='{"slide_direction":"horizontal","slide_percolumn":1,"slide_mode":"slide","slides_to_show_xxl":1,"slides_to_show":1,"slides_to_show_lg":1,"slides_to_show_md":1,"slides_to_show_sm":1,"slides_to_show_xs":1,"slides_to_scroll":1,"slides_gutter":15,"slides_gutter_xl":15,"slides_gutter_lg":15,"slides_gutter_md":15,"slides_gutter_sm":15,"slides_gutter_xs":15,"center_slide":false,"loop":false,"pause_on_hover":false,"autoplay":false,"pause_on_interaction":true,"delay":5000,"speed":500,"dots_style":"bullets","set_timeout":true}'>
                              <div class="pxl-swiper-wrapper swiper-wrapper">


                                <?php
                                $shapes = ['shape-circle', 'shape-triangle', 'shape-hex', 'shape-curve', 'shape-wave'];
                                $i = 0;
                                foreach ($timeline_historylist as $value):
                                  $shape = $shapes[$i % count($shapes)];
                                ?>
                                  <div class="pxl-swiper-slide swiper-slide">
                                    <div class="item-inner relative row">
                                      <div class="item-image col-12 col-lg-6">
                                        <span class="scale-hover-x">
                                          <img loading="lazy" decoding="async" class="no-lazyload" src="<?php echo base_url('uploads/frontend/timeline_history/' . $value['image']); ?>" width="606" height="415" alt="<?php echo html_escape($value['title']); ?>" title="<?php echo html_escape($value['title']); ?>" />
                                        </span>
                                      </div>
                                      <div class="item-content col-12 col-lg-6">
                                        <div class="item-history">
                                          <?php echo html_escape($value['year_range']); ?>
                                        </div>
                                        <div class="item-title">
                                          <?php echo html_escape($value['title']); ?>
                                        </div>
                                        <div class="item-description">
                                          <?php echo $value['description']; ?>
                                        </div>
                                      </div>
                                    </div>
                                  </div>




                                <?php $i++;
                                endforeach; ?>




                              </div>
                            </div>
                          </div>
                          <div class="pxl-swiper-arrows custom">
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                              <span class="pxl-icon"><span aria-hidden="true" class="pxli pxli-arrow-leftnew"></span></span>
                            </div>
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
                              <span class="pxl-icon"><span aria-hidden="true" class="pxli pxli-arrow-leftnew"></span></span>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>




                  </div>
                </div>
              </div>
              <div class="elementor-element elementor-element-8b5f9ec e-flex e-con-boxed e-con e-parent" data-id="8b5f9ec" data-element_type="container">
                <div class="e-con-inner">
                  <div class="elementor-element elementor-element-5a6ba8c elementor-absolute elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="5a6ba8c" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeInLeft","_animation_delay":400}' data-widget_type="pxl_image.default">
                    <div class="elementor-widget-container">
                      <div id="pxl_image-5a6ba8c-2058" class="pxl-image-wg d-flex default">
                        <img loading="lazy" decoding="async" width="289" height="241" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img13-about.webp'); ?>" class="attachment-full size-full wp-image-5393" alt="" />
                      </div>
                    </div>
                  </div>
                  <div class="elementor-element elementor-element-794d313 elementor-absolute e-transform elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="794d313" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeInRight","_animation_delay":500,"_transform_flipX_effect":"transform"}' data-widget_type="pxl_image.default">
                    <div class="elementor-widget-container">
                      <div id="pxl_image-794d313-3671" class="pxl-image-wg d-flex default">
                        <img loading="lazy" decoding="async" width="289" height="241" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img13-about.webp'); ?>" class="attachment-full size-full wp-image-5393" alt="" />
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="elementor-element elementor-element-f140115 e-con-full e-flex e-con e-parent" data-id="f140115" data-element_type="container" data-settings='{"background_background":"classic"}'>
                <div class="elementor-element elementor-element-515fa2d e-flex e-con-boxed e-con e-child" data-id="515fa2d" data-element_type="container" data-settings='{"background_background":"classic"}'>
                  <div class="e-con-inner">
                    <div class="elementor-element elementor-element-70809ac elementor-absolute elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="70809ac" data-element_type="widget" data-settings='{"_position":"absolute","_animation":"fadeInLeft","_animation_delay":400}' data-widget_type="pxl_image.default">
                      <div class="elementor-widget-container">
                        <div id="pxl_image-70809ac-1538" class="pxl-image-wg d-flex default">
                          <img loading="lazy" decoding="async" width="368" height="282" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img14-about.webp'); ?>" class="attachment-full size-full wp-image-5451" alt="" />
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-4cfc0c3 pxl-logo-marquee-layout-3 elementor-absolute elementor-widget elementor-widget-pxl_logo_marquee" data-id="4cfc0c3" data-element_type="widget" data-settings='{"_position":"absolute"}' data-widget_type="pxl_logo_marquee.default">
                      <div class="elementor-widget-container">
                        <div class="pxl-logo-marquee1 layout-3">
                          <div class="pxl-logo-active pxl-flex-middle">
                            <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-d3456e2" data-speed="0.3" data-slip-type="right">
                              <div class="pxl-item--inner pxl-flex-middle">
                                <div class="item-image">
                                  <img loading="lazy" decoding="async" width="1900" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-home1.webp'); ?>" class="no-lazyload attachment-full" alt="" />
                                </div>
                              </div>
                            </div>
                            <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-b0d4c76" data-speed="0.3" data-slip-type="right">
                              <div class="pxl-item--inner pxl-flex-middle">
                                <div class="item-image">
                                  <img loading="lazy" decoding="async" width="1900" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-home1.webp'); ?>" class="no-lazyload attachment-full" alt="" />
                                </div>
                              </div>
                            </div>
                            <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-6141b35" data-speed="0.3" data-slip-type="right">
                              <div class="pxl-item--inner pxl-flex-middle">
                                <div class="item-image">
                                  <img loading="lazy" decoding="async" width="1900" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img2b-home1.webp'); ?>" class="no-lazyload attachment-full" alt="" />
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="elementor-element elementor-element-1be294d e-con-full e-flex e-con e-child" data-id="1be294d" data-element_type="container">
                      <div class="elementor-element elementor-element-f8c9891 elementor-widget elementor-widget-pxl_heading" data-id="f8c9891" data-element_type="widget" data-settings='{"title_sp_type":"words-scale"}' data-widget_type="pxl_heading.default">
                        <div class="elementor-widget-container">
                          <div id="pxl-pxl_heading-f8c9891-6787" class="pxl-heading-wrap d-flex">
                            <div class="pxl-heading-inner d-flex flex-column flex-column-reverse sub-top">
                              <h2 class="heading-title pxl-split-text pxl_title_split_text words-scale">
                                <?php echo $teacher_data['t_page_title']; ?>
                              </h2>
                              <div class="heading-subtitle">
                                <div class="subtitle-text">
                                  <?php echo $teacher_data['t_sub_title']; ?>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="elementor-element elementor-element-9fd5d07 elementor-widget elementor-widget-pxl_text_editor" data-id="9fd5d07" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                          <div class="elementor-widget-container">
                            <div id="pxl_text_editor-9fd5d07-8281" class="pxl-text-editor-wrap d-flex">
                              <div class="pxl-text-editor elementor-clearfix">
                                <p>
                                  <?php echo $teacher_data['t_sec_title']; ?>
                                </p>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="elementor-element elementor-element-be3dc14 elementor-widget__width-auto elementor-widget elementor-widget-pxl_moving_path" data-id="be3dc14" data-element_type="widget" data-widget_type="pxl_moving_path.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-moving-path layout-1" data-duration="3.5" data-direction="ltr">
                              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 100">
                                <path d="M10 40 Q 100 90, 190 40" fill="transparent" stroke="black" stroke-dasharray="2,2" stroke-width="1"></path>
                              </svg>
                              <div class="target-wrap">
                                <img loading="lazy" decoding="async" width="33" height="36" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/bee-imgleft.webp'); ?>" class="attachment-full" alt="" />
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="elementor-element elementor-element-cd71106 post-layout-teacher-1 pxl-swiper-arrows-true pxl-swiper-dots-false pxl-swiper-dots-bullets elementor-widget elementor-widget-pxl_post_carousel" data-id="cd71106" data-element_type="widget" data-widget_type="pxl_post_carousel.default">
                          <div class="elementor-widget-container">
                            <div class="pxl-swiper-slider pxl-teacher-carousel layout-teacher-1 relative center-mode-1">
                              <div class="pxl-swiper-slider-wrap pxl-carousel-inner">
                                <div class="pxl-swiper-container" dir="ltr" data-settings='{"slide_direction":"horizontal","slide_percolumn":1,"slide_mode":"slide","slides_to_show_xxl":3,"slides_to_show":3,"slides_to_show_lg":3,"slides_to_show_md":2,"slides_to_show_sm":1.5,"slides_to_show_xs":1,"slides_to_scroll":1,"slides_gutter":35,"slides_gutter_xl":35,"slides_gutter_lg":35,"slides_gutter_md":35,"slides_gutter_sm":35,"slides_gutter_xs":35,"center_slide":true,"loop":true,"pause_on_hover":false,"autoplay":false,"pause_on_interaction":true,"delay":5000,"speed":500,"dots_style":"bullets","set_timeout":true}'>


                                  <div class="pxl-swiper-wrapper swiper-wrapper">

                                    <?php
                                    $index = 0;
                                    foreach ($doctor_list as $row) {
                                      // Cycle through styles — if more teachers than styles, repeat
                                      $style = $box_styles[$index % count($box_styles)];
                                      $index++;
                                    ?>



                                      <div class="pxl-swiper-slide swiper-slide">
                                        <div class="box-item-wrap">
                                          <div class="inner-item-wrap style-box-paralax">
                                            <div class="post-image scale-hover-z-right">
                                              <a href="../teacher/ethan-brooks/index.html">
                                                <img loading="lazy" decoding="async" class="no-lazyload" src="<?php echo get_image_url('staff', $row['photo']); ?>" width="341" height="341" alt="<?php echo $row['name']; ?>" title="<?php echo $row['name']; ?>" />
                                              </a>
                                            </div>
                                            <div class="item-excerpt icon-move"
                                              style="background-color: <?php echo $style['color']; ?>; <?php echo $style['position']; ?>">
                                              <?php echo $style['text']; ?>
                                            </div>
                                          </div>
                                          <h4 class="item-title">
                                            <a href="../teacher/ethan-brooks/index.html"><?php echo $row['name']; ?></a>
                                          </h4>
                                          <div class="item-subject">
                                            <div class="box-icon">
                                              <span class="teacher-icon"></span>
                                              <span class="item-text"><?php echo $row['designation_name']; ?></span>
                                            </div>
                                            <div class="box-icon">
                                              <span class="item-text"></span>
                                            </div>
                                          </div>
                                        </div>
                                      </div>


                                    <?php } ?>



                                  </div>
                                </div>
                              </div>
                              <div class="pxl-swiper-arrows nav-out-vertical">
                                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                                  <span class="pxl-icon"><span aria-hidden="true" class="pxli pxli-arrow-leftnew"></span></span>
                                </div>
                                <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
                                  <span class="pxl-icon"><span aria-hidden="true" class="pxli pxli-arrow-leftnew"></span></span>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

              </div>
              </div>
          </article>
        </main>
      </div>
    </div>
  </div>
</div>
<!-- #main -->