<?php

    $authenticationURL = base_url($cms_setting['url_alias'] . '/authentication');
    $saasExisting = $this->app_lib->isExistingAddon('saas');
    if ($saasExisting && $this->db->table_exists("custom_domain")) {
        $getDomain = $this->home_model->getCurrentDomain();
        if (!empty($getDomain)) {
            $authenticationURL = base_url('authentication');
        }
    }

    ?>

<!DOCTYPE html>
<html lang="en">
<head>



		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">



		<meta name="description" content="<?php echo $global_config['institute_name'] ?>">

		<!-- Facebook Meta Tags -->
		<meta property="og:url" content="<?php echo base_url() ?>">
		<meta property="og:type" content="website">
		<meta property="og:title" content="">
		<meta property="og:description" content="<?php echo $global_config['institute_name'] ?>">
		<meta property="og:image" content="<?php echo base_url('assets/images/ogimage.jpg'); ?>">

		<!-- Twitter Meta Tags -->
		<meta name="twitter:card" content="summary_large_image">
		<meta property="twitter:domain" content="<?php echo base_url() ?>">
		<meta property="twitter:url" content="<?php echo base_url() ?>">
		<meta name="twitter:title" content="">
		<meta name="twitter:description" content="<?php echo $global_config['institute_name'] ?>">
		<meta name="twitter:image" content="<?php echo base_url('assets/images/ogimage.jpg'); ?>">

		<!-- Meta Tags Generated via https://www.opengraph.xyz -->

		<meta property="og:title" content="><?php echo $page_data['page_title']; ?>" />
		<meta property="og:type" content="<?php echo $page_data['meta_description']; ?>" />
		<meta property="og:URL" content="<?php echo base_url() ?>
        <meta property=" og:image" content="<?php echo base_url('assets/images/ogimage.jpg'); ?>" />
		<meta property="og:description" content="<?php echo $page_data['meta_description']; ?>" />

		<meta name="keyword" content="<?php echo $page_data['meta_keyword']; ?>">
		<meta name="description" content="<?php echo $page_data['meta_description']; ?>">
		<!-- Favicon -->
		<link rel="shortcut icon" href="<?php echo base_url('uploads/frontend/images/' . $cms_setting['fav_icon']); ?>">
		<title><?php echo $page_data['page_title'] . " - " . $cms_setting['application_title']; ?></title>


		<meta name='robots' content='max-image-preview:large' />
		<style>
		  img:is([sizes="auto" i], [sizes^="auto," i]) {
		    contain-intrinsic-size: 3000px 1500px
		  }
		</style>

		<link rel='dns-prefetch' href='href="https://fonts.googleapis.com/css2?family=Mochiy+Pop+P+One&family=Prompt:ital,wght@0,100..900;1,100..900&family=Playwrite+GB+S:ital,wght@0,100..400;1,100..400&display=swap"' />


		<script type="text/javascript">
		  /* <![CDATA[ */
		  window._wpemojiSettings = {
		    "baseUrl": "https:\/\/s.w.org\/images\/core\/emoji\/16.0.1\/72x72\/",
		    "ext": ".png",
		    "svgUrl": "https:\/\/s.w.org\/images\/core\/emoji\/16.0.1\/svg\/",
		    "svgExt": ".svg",
		    "source": {
		      "concatemoji": "https:\/\/demo.7iquid.com\/little-sprouts\/wp-includes\/js\/wp-emoji-release.min.js?ver=6.8.3"
		    }
		  };


		  /*! This file is auto-generated */
		  ! function(s, n) {
		    var o, i, e;

		    function c(e) {
		      try {
		        var t = {
		          supportTests: e,
		          timestamp: (new Date).valueOf()
		        };
		        sessionStorage.setItem(o, JSON.stringify(t))
		      } catch (e) {}
		    }

		    function p(e, t, n) {
		      e.clearRect(0, 0, e.canvas.width, e.canvas.height), e.fillText(t, 0, 0);
		      var t = new Uint32Array(e.getImageData(0, 0, e.canvas.width, e.canvas.height).data),
		        a = (e.clearRect(0, 0, e.canvas.width, e.canvas.height), e.fillText(n, 0, 0), new Uint32Array(e.getImageData(0, 0, e.canvas.width, e.canvas.height).data));
		      return t.every(function(e, t) {
		        return e === a[t]
		      })
		    }

		    function u(e, t) {
		      e.clearRect(0, 0, e.canvas.width, e.canvas.height), e.fillText(t, 0, 0);
		      for (var n = e.getImageData(16, 16, 1, 1), a = 0; a < n.data.length; a++)
		        if (0 !== n.data[a]) return !1;
		      return !0
		    }

		    function f(e, t, n, a) {
		      switch (t) {
		        case "flag":
		          return n(e, "\ud83c\udff3\ufe0f\u200d\u26a7\ufe0f", "\ud83c\udff3\ufe0f\u200b\u26a7\ufe0f") ? !1 : !n(e, "\ud83c\udde8\ud83c\uddf6", "\ud83c\udde8\u200b\ud83c\uddf6") && !n(e, "\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc65\udb40\udc6e\udb40\udc67\udb40\udc7f", "\ud83c\udff4\u200b\udb40\udc67\u200b\udb40\udc62\u200b\udb40\udc65\u200b\udb40\udc6e\u200b\udb40\udc67\u200b\udb40\udc7f");
		        case "emoji":
		          return !a(e, "\ud83e\udedf")
		      }
		      return !1
		    }

		    function g(e, t, n, a) {
		      var r = "undefined" != typeof WorkerGlobalScope && self instanceof WorkerGlobalScope ? new OffscreenCanvas(300, 150) : s.createElement("canvas"),
		        o = r.getContext("2d", {
		          willReadFrequently: !0
		        }),
		        i = (o.textBaseline = "top", o.font = "600 32px Arial", {});
		      return e.forEach(function(e) {
		        i[e] = t(o, e, n, a)
		      }), i
		    }

		    function t(e) {
		      var t = s.createElement("script");
		      t.src = e, t.defer = !0, s.head.appendChild(t)
		    }
		    "undefined" != typeof Promise && (o = "wpEmojiSettingsSupports", i = ["flag", "emoji"], n.supports = {
		      everything: !0,
		      everythingExceptFlag: !0
		    }, e = new Promise(function(e) {
		      s.addEventListener("DOMContentLoaded", e, {
		        once: !0
		      })
		    }), new Promise(function(t) {
		      var n = function() {
		        try {
		          var e = JSON.parse(sessionStorage.getItem(o));
		          if ("object" == typeof e && "number" == typeof e.timestamp && (new Date).valueOf() < e.timestamp + 604800 && "object" == typeof e.supportTests) return e.supportTests
		        } catch (e) {}
		        return null
		      }();
		      if (!n) {
		        if ("undefined" != typeof Worker && "undefined" != typeof OffscreenCanvas && "undefined" != typeof URL && URL.createObjectURL && "undefined" != typeof Blob) try {
		          var e = "postMessage(" + g.toString() + "(" + [JSON.stringify(i), f.toString(), p.toString(), u.toString()].join(",") + "));",
		            a = new Blob([e], {
		              type: "text/javascript"
		            }),
		            r = new Worker(URL.createObjectURL(a), {
		              name: "wpTestEmojiSupports"
		            });
		          return void(r.onmessage = function(e) {
		            c(n = e.data), r.terminate(), t(n)
		          })
		        } catch (e) {}
		        c(n = g(i, f, p, u))
		      }
		      t(n)
		    }).then(function(e) {
		      for (var t in e) n.supports[t] = e[t], n.supports.everything = n.supports.everything && n.supports[t], "flag" !== t && (n.supports.everythingExceptFlag = n.supports.everythingExceptFlag && n.supports[t]);
		      n.supports.everythingExceptFlag = n.supports.everythingExceptFlag && !n.supports.flag, n.DOMReady = !1, n.readyCallback = function() {
		        n.DOMReady = !0
		      }
		    }).then(function() {
		      return e
		    }).then(function() {
		      var e;
		      n.supports.everything || (n.readyCallback(), (e = n.source || {}).concatemoji ? t(e.concatemoji) : e.wpemoji && e.twemoji && (t(e.twemoji), t(e.wpemoji)))
		    }))
		  }((window, document), window._wpemojiSettings);
		  /* ]]> */
		</script>

		<link rel='stylesheet' id='pxl-main-css-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/pxltheme-core/assets/css/pxl-main-css.min8a54.css?ver=1.0.0'); ?>' type='text/css' media='all' />

		<style id='wp-emoji-styles-inline-css' type='text/css'>
		  img.wp-smiley,
		  img.emoji {
		    display: inline !important;
		    border: none !important;
		    box-shadow: none !important;
		    height: 1em !important;
		    width: 1em !important;
		    margin: 0 0.07em !important;
		    vertical-align: -0.1em !important;
		    background: none !important;
		    padding: 0 !important;
		  }
		</style>
		<style id='classic-theme-styles-inline-css' type='text/css'>
		  /*! This file is auto-generated */
		  .wp-block-button__link {
		    color: #fff;
		    background-color: #32373c;
		    border-radius: 9999px;
		    box-shadow: none;
		    text-decoration: none;
		    padding: calc(.667em + 2px) calc(1.333em + 2px);
		    font-size: 1.125em
		  }

		  .wp-block-file__button {
		    background: #32373c;
		    color: #fff;
		    text-decoration: none
		  }
		</style>
		<style id='global-styles-inline-css' type='text/css'>
		  :root {
		    --wp--preset--aspect-ratio--square: 1;
		    --wp--preset--aspect-ratio--4-3: 4/3;
		    --wp--preset--aspect-ratio--3-4: 3/4;
		    --wp--preset--aspect-ratio--3-2: 3/2;
		    --wp--preset--aspect-ratio--2-3: 2/3;
		    --wp--preset--aspect-ratio--16-9: 16/9;
		    --wp--preset--aspect-ratio--9-16: 9/16;
		    --wp--preset--color--black: #000000;
		    --wp--preset--color--cyan-bluish-gray: #abb8c3;
		    --wp--preset--color--white: #ffffff;
		    --wp--preset--color--pale-pink: #f78da7;
		    --wp--preset--color--vivid-red: #2e31cfff;
		    --wp--preset--color--luminous-vivid-orange: #ff6900;
		    --wp--preset--color--luminous-vivid-amber: #fcb900;
		    --wp--preset--color--light-green-cyan: #7bdcb5;
		    --wp--preset--color--vivid-green-cyan: #00d084;
		    --wp--preset--color--pale-cyan-blue: #8ed1fc;
		    --wp--preset--color--vivid-cyan-blue: #0693e3;
		    --wp--preset--color--vivid-purple: #9b51e0;
		    --wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg, rgba(6, 147, 227, 1) 0%, rgb(155, 81, 224) 100%);
		    --wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg, rgb(122, 220, 180) 0%, rgb(0, 208, 130) 100%);
		    --wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg, rgba(252, 185, 0, 1) 0%, rgba(255, 105, 0, 1) 100%);
		    --wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg, rgba(255, 105, 0, 1) 0%, rgba(57, 46, 207, 1) 100%);
		    --wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg, rgb(238, 238, 238) 0%, rgb(169, 184, 195) 100%);
		    --wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg, rgb(74, 234, 220) 0%, rgb(151, 120, 209) 20%, rgb(207, 42, 186) 40%, rgb(238, 44, 130) 60%, rgb(251, 105, 98) 80%, rgb(254, 248, 76) 100%);
		    --wp--preset--gradient--blush-light-purple: linear-gradient(135deg, rgb(255, 206, 236) 0%, rgb(152, 150, 240) 100%);
		    --wp--preset--gradient--blush-bordeaux: linear-gradient(135deg, rgb(254, 205, 165) 0%, rgb(254, 45, 45) 50%, rgb(107, 0, 62) 100%);
		    --wp--preset--gradient--luminous-dusk: linear-gradient(135deg, rgb(255, 203, 112) 0%, rgb(199, 81, 192) 50%, rgb(65, 88, 208) 100%);
		    --wp--preset--gradient--pale-ocean: linear-gradient(135deg, rgb(255, 245, 203) 0%, rgb(182, 227, 212) 50%, rgb(51, 167, 181) 100%);
		    --wp--preset--gradient--electric-grass: linear-gradient(135deg, rgb(202, 248, 128) 0%, rgb(113, 206, 126) 100%);
		    --wp--preset--gradient--midnight: linear-gradient(135deg, rgb(2, 3, 129) 0%, rgb(40, 116, 252) 100%);
		    --wp--preset--font-size--small: 13px;
		    --wp--preset--font-size--medium: 20px;
		    --wp--preset--font-size--large: 36px;
		    --wp--preset--font-size--x-large: 42px;
		    --wp--preset--spacing--20: 0.44rem;
		    --wp--preset--spacing--30: 0.67rem;
		    --wp--preset--spacing--40: 1rem;
		    --wp--preset--spacing--50: 1.5rem;
		    --wp--preset--spacing--60: 2.25rem;
		    --wp--preset--spacing--70: 3.38rem;
		    --wp--preset--spacing--80: 5.06rem;
		    --wp--preset--shadow--natural: 6px 6px 9px rgba(0, 0, 0, 0.2);
		    --wp--preset--shadow--deep: 12px 12px 50px rgba(0, 0, 0, 0.4);
		    --wp--preset--shadow--sharp: 6px 6px 0px rgba(0, 0, 0, 0.2);
		    --wp--preset--shadow--outlined: 6px 6px 0px -3px rgba(255, 255, 255, 1), 6px 6px rgba(0, 0, 0, 1);
		    --wp--preset--shadow--crisp: 6px 6px 0px rgba(0, 0, 0, 1);
		  }

		  :where(.is-layout-flex) {
		    gap: 0.5em;
		  }

		  :where(.is-layout-grid) {
		    gap: 0.5em;
		  }

		  body .is-layout-flex {
		    display: flex;
		  }

		  .is-layout-flex {
		    flex-wrap: wrap;
		    align-items: center;
		  }

		  .is-layout-flex> :is(*, div) {
		    margin: 0;
		  }

		  body .is-layout-grid {
		    display: grid;
		  }

		  .is-layout-grid> :is(*, div) {
		    margin: 0;
		  }

		  :where(.wp-block-columns.is-layout-flex) {
		    gap: 2em;
		  }

		  :where(.wp-block-columns.is-layout-grid) {
		    gap: 2em;
		  }

		  :where(.wp-block-post-template.is-layout-flex) {
		    gap: 1.25em;
		  }

		  :where(.wp-block-post-template.is-layout-grid) {
		    gap: 1.25em;
		  }

		  .has-black-color {
		    color: var(--wp--preset--color--black) !important;
		  }

		  .has-cyan-bluish-gray-color {
		    color: var(--wp--preset--color--cyan-bluish-gray) !important;
		  }

		  .has-white-color {
		    color: var(--wp--preset--color--white) !important;
		  }

		  .has-pale-pink-color {
		    color: var(--wp--preset--color--pale-pink) !important;
		  }

		  .has-vivid-red-color {
		    color: var(--wp--preset--color--vivid-red) !important;
		  }

		  .has-luminous-vivid-orange-color {
		    color: var(--wp--preset--color--luminous-vivid-orange) !important;
		  }

		  .has-luminous-vivid-amber-color {
		    color: var(--wp--preset--color--luminous-vivid-amber) !important;
		  }

		  .has-light-green-cyan-color {
		    color: var(--wp--preset--color--light-green-cyan) !important;
		  }

		  .has-vivid-green-cyan-color {
		    color: var(--wp--preset--color--vivid-green-cyan) !important;
		  }

		  .has-pale-cyan-blue-color {
		    color: var(--wp--preset--color--pale-cyan-blue) !important;
		  }

		  .has-vivid-cyan-blue-color {
		    color: var(--wp--preset--color--vivid-cyan-blue) !important;
		  }

		  .has-vivid-purple-color {
		    color: var(--wp--preset--color--vivid-purple) !important;
		  }

		  .has-black-background-color {
		    background-color: var(--wp--preset--color--black) !important;
		  }

		  .has-cyan-bluish-gray-background-color {
		    background-color: var(--wp--preset--color--cyan-bluish-gray) !important;
		  }

		  .has-white-background-color {
		    background-color: var(--wp--preset--color--white) !important;
		  }

		  .has-pale-pink-background-color {
		    background-color: var(--wp--preset--color--pale-pink) !important;
		  }

		  .has-vivid-red-background-color {
		    background-color: var(--wp--preset--color--vivid-red) !important;
		  }

		  .has-luminous-vivid-orange-background-color {
		    background-color: var(--wp--preset--color--luminous-vivid-orange) !important;
		  }

		  .has-luminous-vivid-amber-background-color {
		    background-color: var(--wp--preset--color--luminous-vivid-amber) !important;
		  }

		  .has-light-green-cyan-background-color {
		    background-color: var(--wp--preset--color--light-green-cyan) !important;
		  }

		  .has-vivid-green-cyan-background-color {
		    background-color: var(--wp--preset--color--vivid-green-cyan) !important;
		  }

		  .has-pale-cyan-blue-background-color {
		    background-color: var(--wp--preset--color--pale-cyan-blue) !important;
		  }

		  .has-vivid-cyan-blue-background-color {
		    background-color: var(--wp--preset--color--vivid-cyan-blue) !important;
		  }

		  .has-vivid-purple-background-color {
		    background-color: var(--wp--preset--color--vivid-purple) !important;
		  }

		  .has-black-border-color {
		    border-color: var(--wp--preset--color--black) !important;
		  }

		  .has-cyan-bluish-gray-border-color {
		    border-color: var(--wp--preset--color--cyan-bluish-gray) !important;
		  }

		  .has-white-border-color {
		    border-color: var(--wp--preset--color--white) !important;
		  }

		  .has-pale-pink-border-color {
		    border-color: var(--wp--preset--color--pale-pink) !important;
		  }

		  .has-vivid-red-border-color {
		    border-color: var(--wp--preset--color--vivid-red) !important;
		  }

		  .has-luminous-vivid-orange-border-color {
		    border-color: var(--wp--preset--color--luminous-vivid-orange) !important;
		  }

		  .has-luminous-vivid-amber-border-color {
		    border-color: var(--wp--preset--color--luminous-vivid-amber) !important;
		  }

		  .has-light-green-cyan-border-color {
		    border-color: var(--wp--preset--color--light-green-cyan) !important;
		  }

		  .has-vivid-green-cyan-border-color {
		    border-color: var(--wp--preset--color--vivid-green-cyan) !important;
		  }

		  .has-pale-cyan-blue-border-color {
		    border-color: var(--wp--preset--color--pale-cyan-blue) !important;
		  }

		  .has-vivid-cyan-blue-border-color {
		    border-color: var(--wp--preset--color--vivid-cyan-blue) !important;
		  }

		  .has-vivid-purple-border-color {
		    border-color: var(--wp--preset--color--vivid-purple) !important;
		  }

		  .has-vivid-cyan-blue-to-vivid-purple-gradient-background {
		    background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;
		  }

		  .has-light-green-cyan-to-vivid-green-cyan-gradient-background {
		    background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;
		  }

		  .has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background {
		    background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;
		  }

		  .has-luminous-vivid-orange-to-vivid-red-gradient-background {
		    background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;
		  }

		  .has-very-light-gray-to-cyan-bluish-gray-gradient-background {
		    background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;
		  }

		  .has-cool-to-warm-spectrum-gradient-background {
		    background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;
		  }

		  .has-blush-light-purple-gradient-background {
		    background: var(--wp--preset--gradient--blush-light-purple) !important;
		  }

		  .has-blush-bordeaux-gradient-background {
		    background: var(--wp--preset--gradient--blush-bordeaux) !important;
		  }

		  .has-luminous-dusk-gradient-background {
		    background: var(--wp--preset--gradient--luminous-dusk) !important;
		  }

		  .has-pale-ocean-gradient-background {
		    background: var(--wp--preset--gradient--pale-ocean) !important;
		  }

		  .has-electric-grass-gradient-background {
		    background: var(--wp--preset--gradient--electric-grass) !important;
		  }

		  .has-midnight-gradient-background {
		    background: var(--wp--preset--gradient--midnight) !important;
		  }

		  .has-small-font-size {
		    font-size: var(--wp--preset--font-size--small) !important;
		  }

		  .has-medium-font-size {
		    font-size: var(--wp--preset--font-size--medium) !important;
		  }

		  .has-large-font-size {
		    font-size: var(--wp--preset--font-size--large) !important;
		  }

		  .has-x-large-font-size {
		    font-size: var(--wp--preset--font-size--x-large) !important;
		  }

		  :where(.wp-block-post-template.is-layout-flex) {
		    gap: 1.25em;
		  }

		  :where(.wp-block-post-template.is-layout-grid) {
		    gap: 1.25em;
		  }

		  :where(.wp-block-columns.is-layout-flex) {
		    gap: 2em;
		  }

		  :where(.wp-block-columns.is-layout-grid) {
		    gap: 2em;
		  }

		  :root :where(.wp-block-pullquote) {
		    font-size: 1.5em;
		    line-height: 1.6;
		  }
		</style>

		<link rel='stylesheet' id='contact-form-7-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/contact-form-7/includes/css/contact-form-7.min9b2d.css?ver=6.1'); ?>' type='text/css' media='all' />

		<style id='woocommerce-inline-inline-css' type='text/css'>
		  .woocommerce form .form-row .required {
		    visibility: visible;
		  }
		</style>
		

		<link rel='stylesheet' id='elementor-frontend-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/custom-frontend.min7468.css?ver=1759398840'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='elementor-post-8-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/post-87468.css?ver=1759398840'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='e-animation-fadeInLeft-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/lib/animations/styles/fadeInLeft.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='e-animation-fadeIn-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/lib/animations/styles/fadeIn.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />


		<link rel='stylesheet' id='e-animation-fadeInUp-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/lib/animations/styles/fadeInUp.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='swiper-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/lib/swiper/v8/css/swiper.min94a4.css?ver=8.4.5'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='e-animation-fadeInDown-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/lib/animations/styles/fadeInDown.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='e-animation-fadeInRight-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/lib/animations/styles/fadeInRight.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='e-animation-float-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/lib/animations/styles/e-animation-float.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='widget-icon-box-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/custom-widget-icon-box.min7468.css?ver=1759398840'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='pxl-timepicker-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/pxltheme-core/assets/css/jquery.timepicker.min32d4.css?ver=6.8.3'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='elementor-post-5781-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/post-578186c8.css?ver=1759398882'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='elementor-post-5765-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/post-5765c5b8.css?ver=1759400698'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='elementor-post-353-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/post-3537468.css?ver=1759398840'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='elementor-post-5821-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/post-582186c8.css?ver=1759398882'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='elementor-post-180-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/post-1803179.css?ver=1759398841'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='perfect-scrollbar-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/woo-smart-wishlist/assets/libs/perfect-scrollbar/css/perfect-scrollbar.min32d4.css?ver=6.8.3'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='perfect-scrollbar-wpc-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/woo-smart-wishlist/assets/libs/perfect-scrollbar/css/perfect-scrollbar-wpc.min32d4.css?ver=6.8.3'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='woosw-icons-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/woo-smart-wishlist/assets/css/woosw-icons.mince52.css?ver=5.0.2'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='woosw-frontend-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/woo-smart-wishlist/assets/css/woosw-frontend.mince52.css?ver=5.0.2'); ?>' type='text/css' media='all' />

		<style id='woosw-frontend-inline-css' type='text/css'>
		  .woosw-popup .woosw-popup-inner .woosw-popup-content .woosw-popup-content-bot .woosw-notice {
		    background-color: #5fbd74;
		  }

		  .woosw-popup .woosw-popup-inner .woosw-popup-content .woosw-popup-content-bot .woosw-popup-content-bot-inner a:hover {
		    color: #5fbd74;
		    border-color: #5fbd74;
		  }
		</style>

		<link rel='stylesheet' id='brands-styles-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/woocommerce/assets/css/brands-styles.min1c61.css?ver=10.1.0'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='pixelart-icon-css' href='<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/fonts/pixelart/pixelart-icon.minf488.css?ver=1.1.0'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='magnific-popup-css' href='<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/css/magnific-popup.min8a54.css?ver=1.0.0'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='sprouts-style-css' href='<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/css/sprouts-style.min5152.css?ver=1.0'); ?>' type='text/css' media='all' />

		<style id='sprouts-style-inline-css' type='text/css'>
		  :root {
		    --primary-color: #84daff;
		    --second-color: #5145f9c4;
		    --third-color: #0066FF;
		    --additional01-color: #5f3b03;
		    --body-color: #666666;
		    --heading-color: #09115d;
		    --primary-color-rgb: 251, 207, 0;
		    --second-color-rgb: 243, 77, 35;
		    --third-color-rgb: 255, 72, 128;
		    --additional01-color-rgb: 95, 59, 3;
		    --body-color-rgb: 102, 102, 102;
		    --heading-color-rgb: 9, 17, 93;
		    --link-color: #09115d;
		    --link-color-hover: #0066FF;
		    --link-color-active: #0066FF;
		    --body-font-family: 'Prompt', sans-serif;
		    --body-font-size: 16px;
		    --body-font-weight: normal;
		    --body-line-height: 1.625;
		    --body-letter-spacing: 0;
		    --content-bg-color: ;
		    --heading-font-family: 'Mochiy Pop P One', sans-serif;
		    --heading-font-weight: 400;
		    --heading-text-transform: none;
		    --heading-line-height: 1.36363636364;
		    --heading-letter-spacing: 0px;
		    --heading-color-hover: var(--link-color);
		    --heading-font-size-h1: 65px;
		    --heading-font-size-h2: 55px;
		    --heading-font-size-h3: 45px;
		    --heading-font-size-h4: 30px;
		    --heading-font-size-h5: 20px;
		    --heading-font-size-h6: 18px;
		    --logo-width: 166px;
		    --logo-mobile_width: 125px;
		  }
		</style>

		<link rel='stylesheet' id='sprouts-base-css' href='<?php echo base_url('assets/frontend/wp-content/themes/sprouts/sprouts-base.min5152.css?ver=1.0'); ?>' type='text/css' media='all' />

  
		<link rel='stylesheet' id='sprouts-google-fonts-css' href='https://fonts.googleapis.com/css2?family=Mochiy+Pop+P+One&family=Prompt:ital,wght@0,100..900;1,100..900&family=Playwrite+GB+S:ital,wght@0,100..400;1,100..400&display=swap' type='text/css' media='all' />

		<link rel='stylesheet' id='elementor-gf-local-roboto-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/google-fonts/css/elementor-gf-local-roboto.min04dd.css?ver=1753177299'); ?>' type='text/css' media='all' />

		<link rel='stylesheet' id='elementor-gf-local-robotoslab-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/google-fonts/css/elementor-gf-local-robotoslab.minfb24.css?ver=1753177329'); ?>' type='text/css' media='all' />

		<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-includes/js/jquery/jquery.minf43b.js?ver=3.7.1'); ?>" id="jquery-core-js"></script>

		<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-includes/js/jquery/jquery-migrate.min5589.js?ver=3.4.1" id="jquery-migrate-js'); ?>"></script>

		<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/pxltheme-core/assets/js/libs/waypoints.minc1b4.js?ver=2.0.5" id="waypoints-js'); ?>"></script>

		<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min1d5f.js?ver=2.7.0-wc.10.1.0'); ?>" id="jquery-blockui-js" defer="defer" data-wp-strategy="defer"></script>

		<script type="text/javascript" id="wc-add-to-cart-js-extra">
		  /* <![CDATA[ */
		  var wc_add_to_cart_params = {
		    "ajax_url": "\/little-sprouts\/wp-admin\/admin-ajax.php",
		    "wc_ajax_url": "\/little-sprouts\/?wc-ajax=%%endpoint%%",
		    "i18n_view_cart": "View cart",
		    "cart_url": "https:\/\/demo.7iquid.com\/little-sprouts\/cart\/",
		    "is_cart": "",
		    "cart_redirect_after_add": "no"
		  };
		  /* ]]> */
		</script>

		<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/woocommerce/assets/js/frontend/add-to-cart.min1c61.js?ver=10.1.0'); ?>" id="wc-add-to-cart-js" defer="defer" data-wp-strategy="defer"></script>

		<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/woocommerce/assets/js/js-cookie/js.cookie.min61af.js?ver=2.1.4-wc.10.1.0" id="js-cookie-js'); ?>" data-wp-strategy="defer"></script>

		<script type="text/javascript" id="woocommerce-js-extra">
		  /* <![CDATA[ */
		  var woocommerce_params = {
		    "ajax_url": "\/little-sprouts\/wp-admin\/admin-ajax.php",
		    "wc_ajax_url": "\/little-sprouts\/?wc-ajax=%%endpoint%%",
		    "i18n_password_show": "Show password",
		    "i18n_password_hide": "Hide password"
		  };
		  /* ]]> */
		</script>

		<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/woocommerce/assets/js/frontend/woocommerce.min1c61.js?ver=10.1.0'); ?>" id="woocommerce-js" defer="defer" data-wp-strategy="defer"></script>

		<link rel="https://api.w.org/" href="wp-json/index.html" />
		<link rel="alternate" title="JSON" type="application/json" href="wp-json/wp/v2/pages/5781.json" />
		<link rel="EditURI" type="application/rsd+xml" title="RSD" href="xmlrpc0db0.php?rsd" />
		<meta name="generator" content="WordPress 6.8.3" />

		<meta name="generator" content="WooCommerce 10.1.0" />
		<link rel="canonical" href="index.html" />
		<link rel='shortlink' href='index.html' />
		<link rel="alternate" title="oEmbed (JSON)" type="application/json+oembed" href="wp-json/oembed/1.0/embed6892.json?url=https%3A%2F%2Fdemo.7iquid.com%2Flittle-sprouts%2F" />

		<link rel="alternate" title="oEmbed (XML)" type="text/xml+oembed" href="wp-json/oembed/1.0/embed82b8?url=https%3A%2F%2Fdemo.7iquid.com%2Flittle-sprouts%2F&amp;format=xml" />

		<meta name="generator" content="Redux 4.5.7" />
		<noscript>
		  <style>
		    .woocommerce-product-gallery {
		      opacity: 1 !important;
		    }
		  </style>

		</noscript>
		<meta name="generator" content="Elementor 3.32.0; features: e_font_icon_svg, additional_custom_breakpoints; settings: css_print_method-external, google_font-enabled, font_display-swap">
		<style>
		  .e-con.e-parent:nth-of-type(n+4):not(.e-lazyloaded):not(.e-no-lazyload),
		  .e-con.e-parent:nth-of-type(n+4):not(.e-lazyloaded):not(.e-no-lazyload) * {
		    background-image: none !important;
		  }

		  @media screen and (max-height: 1024px) {

		    .e-con.e-parent:nth-of-type(n+3):not(.e-lazyloaded):not(.e-no-lazyload),
		    .e-con.e-parent:nth-of-type(n+3):not(.e-lazyloaded):not(.e-no-lazyload) * {
		      background-image: none !important;
		    }
		  }

		  @media screen and (max-height: 640px) {

		    .e-con.e-parent:nth-of-type(n+2):not(.e-lazyloaded):not(.e-no-lazyload),
		    .e-con.e-parent:nth-of-type(n+2):not(.e-lazyloaded):not(.e-no-lazyload) * {
		      background-image: none !important;
		    }
		  }
		</style>

		<style id="pxl_theme_options-dynamic-css" title="dynamic-css" class="redux-options-output">
		  a {
		    color: #09115d;
		  }

		  a:hover {
		    color: #0066FF;
		  }

		  a:active {
		    color: #0066FF;
		  }

		  .pxl-pagetitle .pxl-page-title-bg {
		    background-repeat: no-repeat;
		    background-position: center center;
		    background-image: url('<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img1-pagetitle.webp'); ?>');
		    background-size: cover;
		  }

		  .pxl-page-title-bg {
		    top: 0px;
		    right: 0px;
		    left: -50px;
		  }

		  .woocommerce-page .pxl-pagetitle .pxl-page-title-bg {
		    background-repeat: no-repeat;
		    background-position: center center;
		    background-image: url('<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/bg-product.webp'); ?>');
		    background-size: cover;
		  }
		</style>


		<style>
		  .enroll-now-btn {
		    display: inline-flex;
		    align-items: center;
		    gap: 10px;
		    font-weight: 700;
		    font-size: 14px;
		    font-family: "Poppins", sans-serif;
		    color: #fff;
		    padding: 8px 20px;
		    border: 2px dotted blue;
		    border-radius: 50px;
		    text-decoration: none;
		    box-shadow: 0 4px 10px rgba(0, 123, 255, 0.4);
		    transition: all 0.3s ease;
		  }

		  .enroll-now-btn:hover {
		    background: linear-gradient(135deg, #00c6ff, #007bff);
		    box-shadow: 0 6px 18px rgba(0, 123, 255, 0.6);
		    transform: translateY(-3px);
		    text-decoration: none;
		  }

		  .enroll-icon {
		    display: inline-flex;
		    align-items: center;
		  }

		  .enroll-icon svg {
		    width: 20px;
		    height: 20px;
		  }

		  .pxl-text-editor p {
		    margin: 0;
		  }


		  .item-description {
		    display: inline-block;
		    vertical-align: middle;
		  }

		  .outstand-review-box ul {
		    display: flex;
		    align-items: center;
		    list-style: none;
		    padding: 0;
		    margin: 0;
		  }

		  .outstand-review-box ul li {
		    display: inline-block;
		    margin-right: 4px;
		  }

		  .outstand-review-box i.fas {
		    color: #FFD700;
		    /* Gold for filled stars */
		  }

		  .outstand-review-box i.far {
		    color: #ccc;
		    /* Gray for empty stars */
		  }

		  .outstand-review-box ul li:last-child {
		    margin-right: 0;
		  }
		</style>

		<style>
		  /* 🌬️ Breathing animation (subtle scale) */
		  #ajaxCF7Form {
		    animation: breathe 6s ease-in-out infinite;
		    transition: transform 0.3s ease;
		  }

		  @keyframes breathe {

		    0%,
		    100% {
		      transform: scale(1);
		    }

		    50% {
		      transform: scale(1.015);
		    }

		    /* gentle scale */
		  }

		  /* 💥 Shake animation for invalid submission */
		  .shake {
		    animation: shake 0.5s cubic-bezier(.36, .07, .19, .97) both;
		  }

		  @keyframes shake {

		    10%,
		    90% {
		      transform: translateX(-2px);
		    }

		    20%,
		    80% {
		      transform: translateX(4px);
		    }

		    30%,
		    50%,
		    70% {
		      transform: translateX(-8px);
		    }

		    40%,
		    60% {
		      transform: translateX(8px);
		    }
		  }

		  /* 🎨 Alert messages */
		  .alert {
		    padding: 12px 15px;
		    border-radius: 6px;
		    margin-top: 15px;
		    text-align: center;
		    font-weight: 500;
		    opacity: 1;
		    transform: scale(1);
		    transition: opacity 1s ease-out, transform 1s ease-out;
		  }

		  .alert-success {
		    background: #28a745;
		    color: #fff !important;
		  }

		  .alert-danger {
		    background: #dc3545;
		    color: #fff !important;
		  }

		  .alert.fade-out {
		    opacity: 0;
		    transform: scale(0.9);
		  }

		  /* Loader spinner */
		  .loader {
		    display: inline-block;
		    width: 16px;
		    height: 16px;
		    border: 3px solid rgba(255, 255, 255, 0.5);
		    border-top: 3px solid #fff;
		    border-radius: 50%;
		    animation: spin 0.8s linear infinite;
		    margin-left: 6px;
		    vertical-align: middle;
		  }

		  @keyframes spin {
		    to {
		      transform: rotate(360deg);
		    }
		  }



		  .pxl-video-player {
  position: relative;
  z-index: 10;
}

.pxl-video-btn {
  cursor: pointer;
  pointer-events: auto;
}

.parallax-inner {
  pointer-events: none; /* Prevent blocking clicks */
}

		</style>



</head>
		<!-- Preloader -->
		 <body class="home wp-singular page-template-default page page-id-5781 wp-theme-sprouts theme-sprouts woocommerce-no-js elementor-default elementor-kit-8 elementor-page elementor-page-5781"><div id="pxl-page" class="pxl-page"><div id="pxl-loadding" class="pxl-loader style-1"><div class="loading-spinner"> <img src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/loadinggif.gif'); ?>" alt="Loading"></div>
 
</div>





 <header id="pxl-header" class="pxl-header header-type-el header-layout-5765 header-mobile-type-el sticky-direction-scroll-up">
     <div data-elementor-type="wp-post" data-elementor-id="5765" class="elementor elementor-5765">
         <div class="elementor-element elementor-element-0b76cf9 elementor-hidden-tablet_extra elementor-hidden-tablet elementor-hidden-mobile_extra elementor-hidden-mobile e-flex e-con-boxed pxl-header-desktop pxl-header-transparent e-con e-parent" data-id="0b76cf9" data-element_type="container">
             <div class="e-con-inner">
  


                              <?php
                    $news_list = $this->home_model->getLatestNews($branchID);
                    if (!empty($news_list)) {
                        $url_alias = $cms_setting['url_alias'];
                    ?>
                     <div class="elementor-element elementor-element-3562579 e-con-full e-flex e-con e-child" data-id="3562579" data-element_type="container">
                         <div class="elementor-element elementor-element-09f6eb2 pxl-logo-marquee-layout-2 elementor-widget__width-initial elementor-widget elementor-widget-pxl_logo_marquee" data-id="09f6eb2" data-element_type="widget" data-widget_type="pxl_logo_marquee.default">
                             <div class="elementor-widget-container">
                                 <div class="pxl-logo-marquee1 layout-2">
                                     <div class="pxl-logo-active pxl-flex-middle">





                                         <?php foreach ($news_list as $key => $value) { ?>
                                             <div class="pxl-text--marquee col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 elementor-repeater-item-f39fce6"
                                                 data-speed="0.5" data-slip-type="left">

                                                 <div class="pxl-item--inner pxl-flex-middle">
                                                    <div class="item-image">
                                          <img
                                              width="16"
                                              height="14"
                                              src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/img1-header.webp'); ?>"
                                              class="no-lazyload attachment-full"
                                              alt="" />
                                      </div>
                                                     <h1 class="pxl-text--logo"> <a class="text-white" href="<?php echo base_url($url_alias . '/news_view/' . $value->alias); ?>"><strong><?php echo str_pad($key + 1, 2, '0', STR_PAD_LEFT); ?>.</strong> <?php echo $value->title . " - <span class='date-text'>" .  _d($value->date); ?></span></a></h1>
                                                 </div>
                                             </div><?php } ?>


                                     </div>

                                 </div>

                             </div>

                         </div>
                     </div>
                 <?php } ?>






<div class="elementor-element elementor-element-eec42e1 e-con-full e-flex e-con e-child" data-id="eec42e1" data-element_type="container">
                     <div class="elementor-element elementor-element-4659190 e-con-full e-flex e-con e-child" data-id="4659190" data-element_type="container">
                         <div class="elementor-element elementor-element-12f2c59 e-con-full e-flex e-con e-child" data-id="12f2c59" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;classic&quot;}">
                             <div class="elementor-element elementor-element-2ecfd36 e-con-full e-flex e-con e-child" data-id="2ecfd36" data-element_type="container">
                                 <div class="elementor-element elementor-element-3698cc4 e-con-full e-flex e-con e-child" data-id="3698cc4" data-element_type="container">
                                     <div class="elementor-element elementor-element-242bb2b elementor-widget elementor-widget-pxl_icon" data-id="242bb2b" data-element_type="widget" data-widget_type="pxl_icon.default">
                                         <div class="elementor-widget-container">
                                             <div class="pxl-icon-wg">
                                                 <div class="icon-inner relative pxl-transition"> <span class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 256 256">
                                                             <path d="M128,16a88.1,88.1,0,0,0-88,88c0,75.3,80,132.17,83.41,134.55a8,8,0,0,0,9.18,0C136,236.17,216,179.3,216,104A88.1,88.1,0,0,0,128,16Zm0,56a32,32,0,1,1-32,32A32,32,0,0,1,128,72Z"></path>
                                                         </svg></span></div>
                                             </div>
                                         </div>
                                     </div>
                                     <div class="elementor-element elementor-element-ebc10bc elementor-widget elementor-widget-pxl_text_editor" data-id="ebc10bc" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                         <div class="elementor-widget-container">
                                             <div id="pxl_text_editor-ebc10bc-6315" class="pxl-text-editor-wrap d-flex">
                                                 <div class="pxl-text-editor elementor-clearfix">
                                                     <p><a href=""><?php echo $cms_setting['working_hours']; ?></a></p>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                                 <div class="elementor-element elementor-element-9f517f3 e-con-full e-flex e-con e-child" data-id="9f517f3" data-element_type="container">
                                     <div class="elementor-element elementor-element-31c797c elementor-widget elementor-widget-pxl_icon" data-id="31c797c" data-element_type="widget" data-widget_type="pxl_icon.default">
                                         <div class="elementor-widget-container">
                                             <div class="pxl-icon-wg">
                                                 <div class="icon-inner relative pxl-transition"> <span class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 256 256">
                                                             <path d="M232,128v56a24,24,0,0,1-24,24H192a24,24,0,0,1-24-24V144a24,24,0,0,1,24-24h23.65a87.71,87.71,0,0,0-87-80H128a88,88,0,0,0-87.64,80H64a24,24,0,0,1,24,24v40a24,24,0,0,1-24,24H48a24,24,0,0,1-24-24V128A104.11,104.11,0,0,1,201.89,54.66,103.41,103.41,0,0,1,232,128Z"></path>
                                                         </svg></span></div>
                                             </div>
                                         </div>
                                     </div>
                                     <div class="elementor-element elementor-element-6724d79 elementor-widget elementor-widget-pxl_text_editor" data-id="6724d79" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                         <div class="elementor-widget-container">
                                             <div id="pxl_text_editor-6724d79-3372" class="pxl-text-editor-wrap d-flex">

                                                 <div class="pxl-text-editor elementor-clearfix">
                                                     <p><a href="tel: <?php echo $cms_setting['mobile_no']; ?>"> <?php echo $cms_setting['mobile_no']; ?> </a></p>

                                                 </div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                                 <div class="elementor-element elementor-element-1741653 e-con-full e-flex e-con e-child" data-id="1741653" data-element_type="container">
                                     <div class="elementor-element elementor-element-800454b elementor-widget elementor-widget-pxl_icon" data-id="800454b" data-element_type="widget" data-widget_type="pxl_icon.default">
                                         <div class="elementor-widget-container">
                                             <div class="pxl-icon-wg">
                                                 <div class="icon-inner relative pxl-transition"> <span class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 256 256">
                                                             <path d="M232,128c0,.51,0,1,0,1.52-.34,14.26-5.63,30.48-28,30.48-23.14,0-28-17.4-28-32V88a8,8,0,0,0-8.53-8A8.17,8.17,0,0,0,160,88.27v4a48,48,0,1,0,6.73,64.05,40.19,40.19,0,0,0,3.38,5C175.48,168,185.71,176,204,176a54.81,54.81,0,0,0,9.22-.75,4,4,0,0,1,4.09,6A104.05,104.05,0,0,1,125.91,232C71.13,230.9,26.2,186.86,24.08,132.11A104,104,0,1,1,232,128ZM96,128a32,32,0,1,0,32-32A32,32,0,0,0,96,128Z"></path>
                                                         </svg></span></div>
                                             </div>
                                         </div>
                                     </div>
                                     <div class="elementor-element elementor-element-8f59aa3 elementor-widget elementor-widget-pxl_text_editor" data-id="8f59aa3" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                         <div class="elementor-widget-container">
                                             <div id="pxl_text_editor-8f59aa3-5193" class="pxl-text-editor-wrap d-flex">
                                                 <div class="pxl-text-editor elementor-clearfix">
                                                     <p><a href="mailto:<?php echo $cms_setting['email']; ?>"><?php echo $cms_setting['email']; ?> </a></p>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                             </div>
                             <div class="elementor-element elementor-element-b79c0c3 e-con-full e-flex e-con e-child" data-id="b79c0c3" data-element_type="container">

                                 <div class="elementor-element elementor-element-bf17102 elementor-widget elementor-widget-pxl_divider" data-id="bf17102" data-element_type="widget" data-widget_type="pxl_divider.default">
                                     <div class="elementor-widget-container">
                                         <div class="pxl-widget-divider">
                                             <div class="pxl-divider style1"></div>
                                         </div>
                                     </div>
                                 </div>
                                 <div class="elementor-element elementor-element-5137b86 elementor-widget elementor-widget-pxl_text_editor" data-id="5137b86" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                     <div class="elementor-widget-container">
                                         <div id="pxl_text_editor-5137b86-2681" class="pxl-text-editor-wrap d-flex justify-content-center">
                                             <div class="pxl-text-editor elementor-clearfix">
                                                 <p>
                                                     <a class="enroll-now-btn" href="/champions/admission">
                                                         Enroll Now !
                                                         <span class="enroll-icon">
                                                             <!-- Graduation cap icon -->
                                                             <svg
                                                                 xmlns="http://www.w3.org/2000/svg"
                                                                 viewBox="0 0 512 512">
                                                                 <path
                                                                     d="M362.7 19.3L314.3 67.7 444.3 197.7l48.4-48.4c25-25 25-65.5 0-90.5L453.3 19.3c-25-25-65.5-25-90.5 0zm-71 71L58.6 323.5c-10.4 10.4-18 23.3-22.2 37.4L1 481.2C-1.5 489.7 .8 498.8 7 505s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L421.7 220.3 291.7 90.3z"></path>
                                                             </svg>
                                                         </span>
                                                     </a>
                                                 </p>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                                 <div class="elementor-element elementor-element-6d168ac elementor-widget elementor-widget-pxl_divider" data-id="6d168ac" data-element_type="widget" data-widget_type="pxl_divider.default">
                                     <div class="elementor-widget-container">
                                         <div class="pxl-widget-divider">
                                             <div class="pxl-divider style1"></div>
                                         </div>
                                     </div>
                                 </div>

                             </div>
                         </div>
                         <div class="elementor-element elementor-element-688e8fb elementor-widget-divider--view-line elementor-widget elementor-widget-divider" data-id="688e8fb" data-element_type="widget" data-widget_type="divider.default">
                             <div class="elementor-divider"> <span class="elementor-divider-separator"> </span></div>
                         </div>
                         <div class="elementor-element elementor-element-21a7ef7 e-con-full e-flex e-con e-child" data-id="21a7ef7" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;classic&quot;}">
                             <div class="elementor-element elementor-element-75e31ed e-con-full e-flex e-con e-child" data-id="75e31ed" data-element_type="container">
                                 <div class="elementor-element elementor-element-2c74697 elementor-widget elementor-widget-pxl_logo" data-id="2c74697" data-element_type="widget" data-widget_type="pxl_logo.default">
                                     <div class="elementor-widget-container">
                                         <!-- Logo Starts -->
                                         <div class="pxl-logo d-flex-wrap align-items-center"> <a href="<?php echo base_url('home') ?>"><img src="<?php echo base_url('uploads/frontend/images/' . $cms_setting['logo']); ?>" alt="Champions Montessori Logo"></a></div>

                                         <!-- Logo Ends -->

                                     </div>
                                 </div>
                             </div>
                             <div class="elementor-element elementor-element-f33685f e-con-full e-flex e-con e-child" data-id="f33685f" data-element_type="container">
                                 <div class="elementor-element elementor-element-2744d87 elementor-widget elementor-widget-pxl_menu" data-id="2744d87" data-element_type="widget" data-widget_type="pxl_menu.default">
                                     <div class="elementor-widget-container">
                                         <div id="pxl_menu-2744d87-3745" class="pxl-nav-menu pxl-nav-menu-main style-1 is-arrow ">
                                             <div class="menu-menu-main-container">




                                                 <ul id="pxl-primary-menu" class="pxl-primary-menu clearfix">
                                                     <?php
                                                        $school = $this->uri->segment(1);
                                                        $result = $this->home_model->menuList($school);
                                                        $currentURL = base_url(uri_string());

                                                        foreach ($result as $key => $row) {
                                                            $active_menu     = '';
                                                            $submenu_class   = '';
                                                            $submenu_active  = '';
                                                            $op_new_tab      = '';
                                                            $has_children    = '';
                                                            $toggle_span     = '';

                                                            // Detect active page
                                                            if ($currentURL == $row['url']) {
                                                                $active_menu = ' current-menu-item current_page_item';
                                                            }

                                                            // Detect submenu
                                                            if (!empty($row['submenu']) && is_array($row['submenu'])) {
                                                                $submenu_class = ' menu-item-has-children';
                                                                $has_children  = '<span class="main-menu-toggle"></span>';
                                                                $arrayURL = array_column($row['submenu'], 'url');
                                                                if (in_array($currentURL, $arrayURL)) {
                                                                    $submenu_active = ' current-menu-ancestor current-menu-parent';
                                                                }
                                                            }

                                                            // Handle new tab
                                                            if (!empty($row['open_new_tab'])) {
                                                                $op_new_tab = "target='_blank'";
                                                            }

                                                            // Skip disabled admissions if needed
                                                            if (isset($cms_setting['online_admission']) && $cms_setting['online_admission'] == 0 && $row['alias'] == 'admission') continue;
                                                        ?>
                                                         <li class="menu-item menu-item-type-custom menu-item-object-custom<?php echo $active_menu . $submenu_class . $submenu_active; ?>">
                                                             <a href="<?php echo $row['url']; ?>" class="nav-link" <?php echo $op_new_tab; ?>>
                                                                 <span class="pxl-menu-title"><?php echo $row['title']; ?></span>
                                                             </a>
                                                             <?php echo $has_children; ?>

                                                             <?php if (!empty($row['submenu'])) { ?>
                                                                 <ul class="sub-menu">
                                                                     <?php foreach ($row['submenu'] as $row2) {
                                                                            $active_sub = ($currentURL == $row2['url']) ? ' current-menu-item' : '';
                                                                            $op_new_tab = !empty($row2['open_new_tab']) ? "target='_blank'" : '';
                                                                        ?>
                                                                         <li class="menu-item<?php echo $active_sub; ?>">
                                                                             <a href="<?php echo $row2['url']; ?>" <?php echo $op_new_tab; ?>>
                                                                                 <span class="pxl-menu-title"><?php echo $row2['title']; ?></span>
                                                                             </a>
                                                                         </li>
                                                                     <?php } ?>
                                                                 </ul>
                                                             <?php } ?>
                                                         </li>
                                                     <?php } ?>
                                                 </ul>



                                             </div>
                                             <div class="pxl-divider-move"></div>
                                         </div>
                                     </div>
                                 </div>
                             </div>
                             <div class="elementor-element elementor-element-ede8e2a e-con-full e-flex e-con e-child" data-id="ede8e2a" data-element_type="container">
                                 <div class="elementor-element elementor-element-ff9ece4 elementor-widget elementor-widget-pxl_anchor" data-id="ff9ece4" data-element_type="widget" data-widget_type="pxl_anchor.default">
                                     <div class="elementor-widget-container">
                                         <div class="pxl-anchor-wrap d-flex-wrap align-items-center align-content-center style-none ">
                                             <div class="pxl-anchor side-panel d-flex-wrap align-items-center relative" data-target=".pxl-hidden-template-5759">
                                                 <div class="pxl-anchor-icon d-inline-flex"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                         <path d="M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"></path>
                                                     </svg></div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>



                                 <div class="elementor-element elementor-element-42f4387 elementor-widget elementor-widget-pxl_button" data-id="42f4387" data-element_type="widget" data-widget_type="pxl_button.default">
                                     <div class="elementor-widget-container">
                                         <?php if (!is_loggedin()) { ?>
                                             <div id="pxl_button-42f4387-9911" class="pxl-button-wrapper d-flex align-items-center">
                                                 <a href="<?php echo $authenticationURL; ?>" class="pxl-btn btn-primary icon-ps-right has-icon">
                                                     <i class="pxl-icon left">
                                                         <!-- Login Icon (Left) -->
                                                         <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                             <path d="M192 56c-22.09 0-40 17.91-40 40v72h48V104h224v304H200v-64h-48v72c0 22.09 17.91 40 40 40h240c22.09 0 40-17.91 40-40V96c0-22.09-17.91-40-40-40H192zM217 217v78h139v-78H217zM64 256l80-80v48h112v64H144v48L64 256z" />
                                                         </svg>
                                                     </i>
                                                     <span class="pxl-button-text icon-move fw-bold" data-text="Login Here!" style="font-weight:900; font-size:17px;">Login Here!</span>
                                                     <i class="pxl-icon">
                                                         <!-- Login Icon (Right) -->
                                                         <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                             <path d="M192 56c-22.09 0-40 17.91-40 40v72h48V104h224v304H200v-64h-48v72c0 22.09 17.91 40 40 40h240c22.09 0 40-17.91 40-40V96c0-22.09-17.91-40-40-40H192zM217 217v78h139v-78H217zM64 256l80-80v48h112v64H144v48L64 256z" />
                                                         </svg>
                                                     </i>
                                                 </a>
                                             </div>

                                         <?php } else { ?>

                                             <div id="pxl_button-42f4387-9911" class="pxl-button-wrapper d-flex align-items-center">
                                                 <a href="<?php echo base_url('dashboard'); ?>" class="pxl-btn btn-primary icon-ps-right has-icon">
                                                     <i class="pxl-icon left">
                                                         <!-- Login Icon (Left) -->
                                                         <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                             <path d="M192 56c-22.09 0-40 17.91-40 40v72h48V104h224v304H200v-64h-48v72c0 22.09 17.91 40 40 40h240c22.09 0 40-17.91 40-40V96c0-22.09-17.91-40-40-40H192zM217 217v78h139v-78H217zM64 256l80-80v48h112v64H144v48L64 256z" />
                                                         </svg>
                                                     </i>
                                                     <span class="pxl-button-text icon-move fw-bold" data-text="Login Here!" style="font-weight:900; font-size:17px;">Return To Dashboard</span>
                                                     <i class="pxl-icon">
                                                         <!-- Login Icon (Right) -->
                                                         <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                             <path d="M192 56c-22.09 0-40 17.91-40 40v72h48V104h224v304H200v-64h-48v72c0 22.09 17.91 40 40 40h240c22.09 0 40-17.91 40-40V96c0-22.09-17.91-40-40-40H192zM217 217v78h139v-78H217zM64 256l80-80v48h112v64H144v48L64 256z" />
                                                         </svg>
                                                     </i>
                                                 </a>
                                             </div>

                                         <?php } ?>

                                     </div>


                                 </div>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
        
         
         
         <div class="elementor-element elementor-element-de65365 e-con-full elementor-hidden-tablet_extra elementor-hidden-tablet elementor-hidden-mobile_extra elementor-hidden-mobile e-flex pxl-header-desktop pxl-header-sticky e-con e-parent" data-id="de65365" data-element_type="container">
             <div class="elementor-element elementor-element-df0030d e-con-full e-flex e-con e-child" data-id="df0030d" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;classic&quot;}">
                 <div class="elementor-element elementor-element-cd68b7a e-con-full e-flex e-con e-child" data-id="cd68b7a" data-element_type="container">

                     <div class="elementor-element elementor-element-57a797b elementor-widget elementor-widget-pxl_logo" data-id="57a797b" data-element_type="widget" data-widget_type="pxl_logo.default">
                         <div class="elementor-widget-container">
                             <div class="pxl-logo d-flex-wrap align-items-center"> <a href="/"><img src="<?php echo base_url('uploads/frontend/images/' . $cms_setting['logo']); ?>" alt="Champions Montessori Logo"></a></div>
                         </div>
                     </div>

                     <div class="elementor-element elementor-element-062a522 elementor-widget elementor-widget-pxl_menu" data-id="062a522" data-element_type="widget" data-widget_type="pxl_menu.default">
                         <div class="elementor-widget-container">
                             <div id="pxl_menu-062a522-6477" class="pxl-nav-menu pxl-nav-menu-main style-1 is-arrow ">
                                 <div class="menu-menu-main-container">
                                     <ul id="pxl-primary-menu-pxl_menu-062a522-6477" class="pxl-primary-menu clearfix">
                                         <?php
                                            $school = $this->uri->segment(1);
                                            $result = $this->home_model->menuList($school);
                                            $currentURL = base_url(uri_string());

                                            foreach ($result as $key => $row) {
                                                $active_menu     = '';
                                                $submenu_class   = '';
                                                $submenu_active  = '';
                                                $op_new_tab      = '';
                                                $has_children    = '';
                                                $toggle_span     = '';

                                                // Detect active page
                                                if ($currentURL == $row['url']) {
                                                    $active_menu = ' current-menu-item current_page_item';
                                                }

                                                // Detect submenu
                                                if (!empty($row['submenu']) && is_array($row['submenu'])) {
                                                    $submenu_class = ' menu-item-has-children';
                                                    $has_children  = '<span class="main-menu-toggle"></span>';
                                                    $arrayURL = array_column($row['submenu'], 'url');
                                                    if (in_array($currentURL, $arrayURL)) {
                                                        $submenu_active = ' current-menu-ancestor current-menu-parent';
                                                    }
                                                }

                                                // Handle new tab
                                                if (!empty($row['open_new_tab'])) {
                                                    $op_new_tab = "target='_blank'";
                                                }

                                                // Skip disabled admissions if needed
                                                if (isset($cms_setting['online_admission']) && $cms_setting['online_admission'] == 0 && $row['alias'] == 'admission') continue;
                                            ?>
                                             <li class="menu-item menu-item-type-custom menu-item-object-custom<?php echo $active_menu . $submenu_class . $submenu_active; ?>">
                                                 <a href="<?php echo $row['url']; ?>" class="nav-link" <?php echo $op_new_tab; ?>>
                                                     <span class="pxl-menu-title"><?php echo $row['title']; ?></span>
                                                 </a>
                                                 <?php echo $has_children; ?>

                                                 <?php if (!empty($row['submenu'])) { ?>
                                                     <ul class="sub-menu">
                                                         <?php foreach ($row['submenu'] as $row2) {
                                                                $active_sub = ($currentURL == $row2['url']) ? ' current-menu-item' : '';
                                                                $op_new_tab = !empty($row2['open_new_tab']) ? "target='_blank'" : '';
                                                            ?>
                                                             <li class="menu-item<?php echo $active_sub; ?>">
                                                                 <a href="<?php echo $row2['url']; ?>" <?php echo $op_new_tab; ?>>
                                                                     <span class="pxl-menu-title"><?php echo $row2['title']; ?></span>
                                                                 </a>
                                                             </li>
                                                         <?php } ?>
                                                     </ul>
                                                 <?php } ?>
                                             </li>
                                         <?php } ?>
                                     </ul>
                                 </div>
                                 <div class="pxl-divider-move"></div>
                             </div>
                         </div>
                     </div>
                 </div>
                 <div class="elementor-element elementor-element-357f0ff e-con-full e-flex e-con e-child" data-id="357f0ff" data-element_type="container">
                     <div class="elementor-element elementor-element-566e6ac elementor-widget elementor-widget-pxl_anchor" data-id="566e6ac" data-element_type="widget" data-widget_type="pxl_anchor.default">
                         <div class="elementor-widget-container">
                             <div class="pxl-anchor-wrap d-flex-wrap align-items-center align-content-center style-none ">
                                 <div class="pxl-anchor side-panel d-flex-wrap align-items-center relative" data-target=".pxl-hidden-template-5759">
                                     <div class="pxl-anchor-icon d-inline-flex"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                             <path d="M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"></path>
                                         </svg></div>
                                 </div>
                             </div>
                         </div>
                     </div>
                     <div class="elementor-element elementor-element-4e2ad25 elementor-widget elementor-widget-pxl_button" data-id="4e2ad25" data-element_type="widget" data-widget_type="pxl_button.default">
                        
                         <div class="elementor-widget-container">
                            <?php if (!is_loggedin()) { ?>
                             <div id="pxl_button-4e2ad25-4873" class="pxl-button-wrapper d-flex align-items-center"> <a href="<?php echo $authenticationURL; ?>" class="pxl-btn btn-primary icon-ps-right has-icon"> <i class="pxl-icon left"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                             <path d="M362.7 19.3L314.3 67.7 444.3 197.7l48.4-48.4c25-25 25-65.5 0-90.5L453.3 19.3c-25-25-65.5-25-90.5 0zm-71 71L58.6 323.5c-10.4 10.4-18 23.3-22.2 37.4L1 481.2C-1.5 489.7 .8 498.8 7 505s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L421.7 220.3 291.7 90.3z"></path>
                                         </svg></i> <span class="pxl-button-text icon-move" data-text="Login Here!">Login Here!</span> <i class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                             <path d="M362.7 19.3L314.3 67.7 444.3 197.7l48.4-48.4c25-25 25-65.5 0-90.5L453.3 19.3c-25-25-65.5-25-90.5 0zm-71 71L58.6 323.5c-10.4 10.4-18 23.3-22.2 37.4L1 481.2C-1.5 489.7 .8 498.8 7 505s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L421.7 220.3 291.7 90.3z"></path>
                                         </svg></i> </a>
                                        
                                        
                             </div>

                              <?php } else { ?>

                            <div id="pxl_button-4e2ad25-4873" class="pxl-button-wrapper d-flex align-items-center"> <a href="<?php echo base_url('dashboard'); ?>" class="pxl-btn btn-primary icon-ps-right has-icon">
                                                     <i class="pxl-icon left">
                                                         <!-- Login Icon (Left) -->
                                                         <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                             <path d="M192 56c-22.09 0-40 17.91-40 40v72h48V104h224v304H200v-64h-48v72c0 22.09 17.91 40 40 40h240c22.09 0 40-17.91 40-40V96c0-22.09-17.91-40-40-40H192zM217 217v78h139v-78H217zM64 256l80-80v48h112v64H144v48L64 256z" />
                                                         </svg>
                                                     </i>
                                                     <span class="pxl-button-text icon-move fw-bold" data-text="Login Here!" style="font-weight:900; font-size:17px;">Return To Dashboard</span>
                                                     <i class="pxl-icon">
                                                         <!-- Login Icon (Right) -->
                                                         <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                             <path d="M192 56c-22.09 0-40 17.91-40 40v72h48V104h224v304H200v-64h-48v72c0 22.09 17.91 40 40 40h240c22.09 0 40-17.91 40-40V96c0-22.09-17.91-40-40-40H192zM217 217v78h139v-78H217zM64 256l80-80v48h112v64H144v48L64 256z" />
                                                         </svg>
                                                     </i>
                                                 </a>
                                        
                                        
                             </div>

                             <?php } ?>


                             
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>




     
     <div class="pxl-header-mobile d-xl-none">
         <div data-elementor-type="wp-post" data-elementor-id="353" class="elementor elementor-353">
             <div class="elementor-element elementor-element-8a694b8 elementor-hidden-desktop elementor-hidden-laptop e-flex e-con-boxed e-con e-parent" data-id="8a694b8" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;classic&quot;}">
                 <div class="e-con-inner">
                     <div class="elementor-element elementor-element-1abdd95 elementor-absolute e-transform elementor-widget elementor-widget-pxl_image" data-id="1abdd95" data-element_type="widget" data-settings="{&quot;_position&quot;:&quot;absolute&quot;,&quot;_transform_flipY_effect&quot;:&quot;transform&quot;}" data-widget_type="pxl_image.default">
                         <div class="elementor-widget-container">
                             <div id="pxl_image-1abdd95-4845" class="pxl-image-wg d-flex default"> <img loading="lazy" width="1920" height="17" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img15-enrollment-1.webp'); ?>" class="attachment-full size-full wp-image-3070" alt="" srcset="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img15-enrollment-1.webp 1920w'); ?>, <?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img15-enrollment-1-1536x14.webp 1536w'); ?>, <?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img15-enrollment-1-1170x10.webp 1170w'); ?>" sizes="(max-width: 1920px) 100vw, 1920px" /></div>
                         </div>
                     </div>
                     <div class="elementor-element elementor-element-aa91786 e-con-full e-flex e-con e-child" data-id="aa91786" data-element_type="container">
                         <div class="elementor-element elementor-element-e498ced elementor-widget elementor-widget-pxl_logo" data-id="e498ced" data-element_type="widget" data-widget_type="pxl_logo.default">
                             <div class="elementor-widget-container">
                                 <div class="pxl-logo d-flex-wrap align-items-center"> <a href="/"><img src="<?php echo base_url('uploads/frontend/images/' . $cms_setting['logo']); ?>" alt="Champions Montessori Logo"></a></div>
                             </div>
                         </div>
                     </div>
                     <div class="elementor-element elementor-element-82bc534 e-con-full e-flex e-con e-child" data-id="82bc534" data-element_type="container">
                         <div class="elementor-element elementor-element-4ce0e7e anchor-align-end elementor-widget elementor-widget-pxl_anchor" data-id="4ce0e7e" data-element_type="widget" data-widget_type="pxl_anchor.default">
                             <div class="elementor-widget-container">
                                 <div class="pxl-anchor-wrap d-flex-wrap align-items-center align-content-center style-none ">
                                     <div class="pxl-anchor side-panel d-flex-wrap align-items-center relative" data-target=".pxl-hidden-template-8020">
                                         <div class="pxl-anchor-icon icon-custom d-inline-flex header-mobile-nav"><span class="menu-mobile-toggle-nav"><span></span><span></span><span></span></span></div>
                                     </div>
                                 </div>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </header>




		<?php echo $main_contents; ?>



		


<footer id="pxl-footer" class="pxl-footer footer-type-el footer-layout-180">
    <div data-elementor-type="wp-post" data-elementor-id="180" class="elementor elementor-180">
        <div class="elementor-element elementor-element-85aa0d8 e-con-full e-flex e-con e-parent" data-id="85aa0d8" data-element_type="container">
            <div class="elementor-element elementor-element-1ad9fcf elementor-widget elementor-widget-pxl_image" data-id="1ad9fcf" data-element_type="widget" data-settings="{&quot;position&quot;:&quot;absolute&quot;}" data-widget_type="pxl_image.default">
                <div class="elementor-widget-container">
                    <div id="pxl_image-1ad9fcf-5236" class="pxl-image-wg d-flex pxl-bg-parallax default">
                        <div class="parallax-inner" data-parallax="{&quot;x&quot;:-80}" style="--pxl-image-bg: url('<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/img3-footer.webp'); ?>"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="elementor-element elementor-element-5fdec7a e-con-full e-flex e-con e-parent" data-id="5fdec7a" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;classic&quot;}">
            <div class="elementor-element elementor-element-47d3f2c e-flex e-con-boxed e-con e-child" data-id="47d3f2c" data-element_type="container">
                <div class="e-con-inner">
                    <div class="elementor-element elementor-element-f19f7c0 e-con-full e-flex e-con e-child" data-id="f19f7c0" data-element_type="container">
                        <div class="pxl-border-animated num-1">
                            <div class="pxl-border-anm bt w-100" style="border-width: 0px 0 0 0; border-style: dashed; border-color: #FFFFFF26;"></div>
                            <div class="pxl-border-anm br h-100" style="border-width: 0 0px 0 0; border-style: dashed; border-color: #FFFFFF26;"></div>
                            <div class="pxl-border-anm bb w-100" style="border-width: 0 0 1px 0; border-style: dashed; border-color: #FFFFFF26;"></div>
                            <div class="pxl-border-anm bl h-100" style="border-width: 0 0 0 0px; border-style: dashed; border-color: #FFFFFF26;"></div>
                            <div class="elementor-element elementor-element-503872c e-con-full e-flex pxl-border-section-anm e-con e-child" data-id="503872c" data-element_type="container">
                                <div class="elementor-element elementor-element-792b722 e-con-full e-flex e-con e-child" data-id="792b722" data-element_type="container">
                                    <div class="elementor-element elementor-element-a9a14dc elementor-widget elementor-widget-pxl_logo" data-id="a9a14dc" data-element_type="widget" data-widget_type="pxl_logo.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-logo d-flex-wrap align-items-center"> <a href="<?php echo base_url('home') ?>"><img src="<?php echo base_url('uploads/frontend/images/' . $cms_setting['logo']); ?>" alt="CMA Logo"></a></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="elementor-element elementor-element-92b757e e-con-full e-flex e-con e-child" data-id="92b757e" data-element_type="container">
                                    <div class="elementor-element elementor-element-73d3dda elementor-widget elementor-widget-pxl_logo" data-id="73d3dda" data-element_type="widget" data-widget_type="pxl_logo.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-logo d-flex-wrap align-items-center"> <a href="../../www.cambridgeinternational.org/index.html"><img src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/britnig.png'); ?>" alt="British–Nigerian Curriculum"></a></div>
                                        </div>
                                    </div>

                                    <div class="elementor-element elementor-element-73d3dda elementor-widget elementor-widget-pxl_logo" data-id="73d3dda" data-element_type="widget" data-widget_type="pxl_logo.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-logo d-flex-wrap align-items-center"> <a href="../../www.cambridgeinternational.org/index.html"><img src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/bds.png'); ?>" alt="Child-Safe & Caring Environment"></a></div>
                                        </div>
                                    </div>


                                    <div class="elementor-element elementor-element-107b3df elementor-widget elementor-widget-pxl_logo" data-id="107b3df" data-element_type="widget" data-widget_type="pxl_logo.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-logo d-flex-wrap align-items-center"> <a href="../../www.microsoft.com/en-us/education/index.html"><img src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/img2-footer.webp'); ?>" alt="Sprouts"></a></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-9c53e5a e-con-full e-flex e-con e-child" data-id="9c53e5a" data-element_type="container">
                            <div class="elementor-element elementor-element-d201c0c e-con-full e-flex e-con e-child" data-id="d201c0c" data-element_type="container">
                                <div class="elementor-element elementor-element-3e01860 elementor-widget elementor-widget-pxl_heading" data-id="3e01860" data-element_type="widget" data-widget_type="pxl_heading.default">
                                    <div class="elementor-widget-container">
                                        <div id="pxl-pxl_heading-3e01860-9153" class="pxl-heading-wrap d-flex">
                                            <div class="pxl-heading-inner">
                                                <h2 class="heading-title"> About School</h2>
                                                <div class="heading-subtitle">
                                                    <div class="subtitle-text "><?php echo $cms_setting['footer_about_text']; ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="elementor-element elementor-element-f12b01d elementor-shape-circle elementor-grid-0 elementor-widget elementor-widget-social-icons" data-id="f12b01d" data-element_type="widget" data-widget_type="social-icons.default">
                                    <div class="elementor-social-icons-wrapper elementor-grid" role="list">
                                        <?php if (!empty($cms_setting['facebook_url'])) { ?>
                                            <span class="elementor-grid-item" role="listitem"> <a class="elementor-icon elementor-social-icon elementor-social-icon-pxli-facebook-f elementor-animation-grow-rotate elementor-repeater-item-e8350e1" href="<?php echo $cms_setting['facebook_url']; ?>" target="_blank"> <span class="elementor-screen-only">Pxli-facebook-f</span> <i aria-hidden="true" class="pxli pxli-facebook-f"></i> </a> </span>

                                        <?php }
                                        if (!empty($cms_setting['twitter_url'])) { ?>
                                            <span class="elementor-grid-item" role="listitem"> <a class="elementor-icon elementor-social-icon elementor-social-icon-twitter elementor-animation-grow-rotate elementor-repeater-item-13e0a81" href="<?php echo $cms_setting['twitter_url']; ?>" target="_blank"> <span class="elementor-screen-only">Twitter</span>

                                                    <svg aria-hidden="true" class="e-font-icon-svg e-fab-twitter" viewBox="0 0 512 512" xmlns="../../www.w3.org/2000/svg.html">
                                                        <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
                                                    </svg> </a> </span>

                                        <?php }
                                        if (!empty($cms_setting['instagram_url'])) { ?>
                                            <span class="elementor-grid-item" role="listitem"> <a class="elementor-icon elementor-social-icon elementor-social-icon-pxli-instagram1 elementor-animation-grow-rotate elementor-repeater-item-687f452" href="<?php echo $cms_setting['instagram_url']; ?>" target="_blank"> <span class="elementor-screen-only">Pxli-instagram1</span> <i aria-hidden="true" class="pxli pxli-instagram1"></i> </a> </span>
                                        <?php }
                                        if (!empty($cms_setting['youtube_url'])) { ?>
                                            <span class="elementor-grid-item" role="listitem">
                                                <a class="elementor-icon elementor-social-icon elementor-social-icon-youtube elementor-animation-grow-rotate elementor-repeater-item-67bc47b"
                                                    href="<?php echo $cms_setting['youtube_url']; ?>"
                                                    target="_blank"
                                                    aria-label="YouTube">

                                                    <span class="elementor-screen-only">YouTube</span>

                                                    <!-- YouTube SVG Icon -->
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="#FF0000">
                                                        <path d="M23.5 6.2s-.2-1.7-.9-2.4c-.8-.9-1.7-.9-2.1-1C17.6 2.5 12 2.5 12 2.5h0s-5.6 0-8.5.3c-.4 0-1.3.1-2.1 1C.7 4.5.5 6.2.5 6.2S0 8.3 0 10.4v3.2c0 2.1.5 4.2.5 4.2s.2 1.7.9 2.4c.8.9 1.8.9 2.3 1 1.7.1 7.2.3 8.3.3h0s5.6 0 8.5-.3c.4 0 1.3-.1 2.1-1 .7-.7.9-2.4.9-2.4s.5-2.1.5-4.2v-3.2c0-2.1-.5-4.2-.5-4.2zM9.8 15.3V8.7l6.2 3.3-6.2 3.3z" />
                                                    </svg>

                                                </a>
                                            </span>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <div class="elementor-element elementor-element-ed74ad6 e-con-full e-flex e-con e-child" data-id="ed74ad6" data-element_type="container">
                                <div class="elementor-element elementor-element-f2a1320 elementor-widget elementor-widget-pxl_heading" data-id="f2a1320" data-element_type="widget" data-widget_type="pxl_heading.default">
                                    <div class="elementor-widget-container">
                                        <div id="pxl-pxl_heading-f2a1320-9591" class="pxl-heading-wrap d-flex">
                                            <div class="pxl-heading-inner">
                                                <h2 class="heading-title"> Contact Us</h2>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="elementor-element elementor-element-b88ceef e-con-full e-flex e-con e-child" data-id="b88ceef" data-element_type="container">
                                    <div class="elementor-element elementor-element-68b0a52 elementor-widget elementor-widget-pxl_icon" data-id="68b0a52" data-element_type="widget" data-widget_type="pxl_icon.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-icon-wg">
                                                <div class="icon-inner relative pxl-transition"> <span class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 256 256">
                                                            <path d="M128,16a88.1,88.1,0,0,0-88,88c0,75.3,80,132.17,83.41,134.55a8,8,0,0,0,9.18,0C136,236.17,216,179.3,216,104A88.1,88.1,0,0,0,128,16Zm0,56a32,32,0,1,1-32,32A32,32,0,0,1,128,72Z"></path>
                                                        </svg></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="elementor-element elementor-element-46f6b52 elementor-widget elementor-widget-pxl_text_editor" data-id="46f6b52" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                        <div class="elementor-widget-container">
                                            <div id="pxl_text_editor-46f6b52-2853" class="pxl-text-editor-wrap d-flex">
                                                <div class="pxl-text-editor elementor-clearfix">
                                                    <p><a href=""><?php echo $cms_setting['address']; ?></a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="elementor-element elementor-element-1595069 e-con-full e-flex e-con e-child" data-id="1595069" data-element_type="container">
                                    <div class="elementor-element elementor-element-b97caf9 elementor-widget elementor-widget-pxl_icon" data-id="b97caf9" data-element_type="widget" data-widget_type="pxl_icon.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-icon-wg">
                                                <div class="icon-inner relative pxl-transition"> <span class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 256 256">
                                                            <path d="M232,128v56a24,24,0,0,1-24,24H192a24,24,0,0,1-24-24V144a24,24,0,0,1,24-24h23.65a87.71,87.71,0,0,0-87-80H128a88,88,0,0,0-87.64,80H64a24,24,0,0,1,24,24v40a24,24,0,0,1-24,24H48a24,24,0,0,1-24-24V128A104.11,104.11,0,0,1,201.89,54.66,103.41,103.41,0,0,1,232,128Z"></path>
                                                        </svg></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="elementor-element elementor-element-2f0a3d0 elementor-widget elementor-widget-pxl_text_editor" data-id="2f0a3d0" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                        <div class="elementor-widget-container">
                                            <div id="pxl_text_editor-2f0a3d0-7613" class="pxl-text-editor-wrap d-flex">
                                                <div class="pxl-text-editor elementor-clearfix">
                                                    <p>Call Us 24/7<br /><a href="tel:<?php echo $cms_setting['mobile_no']; ?>"><?php echo $cms_setting['mobile_no']; ?></a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="elementor-element elementor-element-c6e42c3 e-con-full e-flex e-con e-child" data-id="c6e42c3" data-element_type="container">
                                    <div class="elementor-element elementor-element-78dccd6 elementor-widget elementor-widget-pxl_icon" data-id="78dccd6" data-element_type="widget" data-widget_type="pxl_icon.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-icon-wg">
                                                <div class="icon-inner relative pxl-transition"> <span class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 256 256">
                                                            <path d="M232,128c0,.51,0,1,0,1.52-.34,14.26-5.63,30.48-28,30.48-23.14,0-28-17.4-28-32V88a8,8,0,0,0-8.53-8A8.17,8.17,0,0,0,160,88.27v4a48,48,0,1,0,6.73,64.05,40.19,40.19,0,0,0,3.38,5C175.48,168,185.71,176,204,176a54.81,54.81,0,0,0,9.22-.75,4,4,0,0,1,4.09,6A104.05,104.05,0,0,1,125.91,232C71.13,230.9,26.2,186.86,24.08,132.11A104,104,0,1,1,232,128ZM96,128a32,32,0,1,0,32-32A32,32,0,0,0,96,128Z"></path>
                                                        </svg></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="elementor-element elementor-element-69966fa elementor-widget elementor-widget-pxl_text_editor" data-id="69966fa" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                        <div class="elementor-widget-container">
                                            <div id="pxl_text_editor-69966fa-5819" class="pxl-text-editor-wrap d-flex">
                                                <div class="pxl-text-editor elementor-clearfix">
                                                    <p>Send Us Mail<br /><a href="mailto:<?php echo $cms_setting['email']; ?>" style="word-wrap: break-word; overflow-wrap: break-word; display: inline-block; max-width: 80%;"><?php echo $cms_setting['email']; ?></a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="elementor-element elementor-element-583808c e-con-full e-flex e-con e-child" data-id="583808c" data-element_type="container">
                                    <div class="elementor-element elementor-element-238b000 elementor-widget elementor-widget-pxl_icon" data-id="238b000" data-element_type="widget" data-widget_type="pxl_icon.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-icon-wg">
                                                <div class="icon-inner relative pxl-transition"> <span class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 256 256">
                                                            <path d="M232,128c0,.51,0,1,0,1.52-.34,14.26-5.63,30.48-28,30.48-23.14,0-28-17.4-28-32V88a8,8,0,0,0-8.53-8A8.17,8.17,0,0,0,160,88.27v4a48,48,0,1,0,6.73,64.05,40.19,40.19,0,0,0,3.38,5C175.48,168,185.71,176,204,176a54.81,54.81,0,0,0,9.22-.75,4,4,0,0,1,4.09,6A104.05,104.05,0,0,1,125.91,232C71.13,230.9,26.2,186.86,24.08,132.11A104,104,0,1,1,232,128ZM96,128a32,32,0,1,0,32-32A32,32,0,0,0,96,128Z"></path>
                                                        </svg></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="elementor-element elementor-element-db1bc2d elementor-widget elementor-widget-pxl_text_editor" data-id="db1bc2d" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                        <div class="elementor-widget-container">
                                            <div id="pxl_text_editor-db1bc2d-1143" class="pxl-text-editor-wrap d-flex">
                                                <div class="pxl-text-editor elementor-clearfix">
                                                    <p>School Time<br /><?php echo $cms_setting['working_hours']; ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="elementor-element elementor-element-6117d51 e-con-full e-flex e-con e-child" data-id="6117d51" data-element_type="container">
                                <div class="elementor-element elementor-element-afc3de2 elementor-widget elementor-widget-pxl_heading" data-id="afc3de2" data-element_type="widget" data-widget_type="pxl_heading.default">
                                    <div class="elementor-widget-container">
                                        <div id="pxl-pxl_heading-afc3de2-9693" class="pxl-heading-wrap d-flex">
                                            <div class="pxl-heading-inner">
                                                <h2 class="heading-title"> Activities</h2>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="elementor-element elementor-element-1673f52 pxl-icon-list--layout--traditional elementor-widget elementor-widget-pxl_icon_list" data-id="1673f52" data-element_type="widget" data-widget_type="pxl_icon_list.default">
                                    <div class="elementor-widget-container">
                                        <div class="pxl-icon-list-wg items-traditional icon-type-icon">

                                            <?php
                                            $school = $this->uri->segment(1);
                                            if (empty($school)) {
                                                $branchID = $this->home_model->getDefaultBranch();
                                                $r = $this->db->select('url_alias')->get_where('front_cms_setting', array('branch_id' => $branchID))->row();
                                                $school = $r->url_alias;
                                            }
                                            $result = web_menu_list(1);
                                            foreach ($result as $row) {
                                                if ($cms_setting['online_admission'] == 0 && $row['alias'] == 'admission') continue;
                                                $url = "#";
                                                if ($row['invisible'] == 0) {
                                                    $url = $this->home_model->genURL($row, $school);
                                            ?>


                                                    <div class="list-item relative d-flex  item-traditional elementor-repeater-item-d36add2 pxl-hover-anm "> <span class="pxl-icon d-inline-flex flex-shrink-0"> <span class="icon-inner none-anm"> <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512">
                                                                    <path d="M246.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 256c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l128-128z"></path>
                                                                </svg> </span> </span>
                                                        <div class="box-content"> <span class="item-ask-icon"></span>
                                                            <div class="item-content"> <span class="item-title"> <a href="<?php echo $url; ?>"><?php echo $row['title']; ?> </a> </span></div>
                                                        </div>
                                                    </div>

                                            <?php }
                                            } ?>







                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="elementor-element elementor-element-56f588d e-con-full e-flex e-con e-child" data-id="56f588d" data-element_type="container">
                                <div class="elementor-element elementor-element-8befa3e elementor-widget elementor-widget-pxl_heading" data-id="8befa3e" data-element_type="widget" data-widget_type="pxl_heading.default">
                                    <div class="elementor-widget-container">
                                        <div id="pxl-pxl_heading-8befa3e-9846" class="pxl-heading-wrap d-flex">
                                            <div class="pxl-heading-inner">
                                                <h2 class="heading-title"> Subscribe News</h2>
                                                <div class="heading-subtitle">
                                                    <div class="subtitle-text ">Stay updated with our latest news, events, and parenting tips — delivered straight to your inbox!</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="elementor-element elementor-element-5252017 elementor-widget-mobile__width-initial elementor-widget elementor-widget-pxl_mailchimp" data-id="5252017" data-element_type="widget" data-widget_type="pxl_mailchimp.default">
                                    <div class="elementor-widget-container">
                                        <div class="pxl-mailchimp relative">
                                            <div class="mc-inner">
                                                <script>
                                                    (function() {
                                                        window.mc4wp = window.mc4wp || {
                                                            listeners: [],
                                                            forms: {
                                                                on: function(evt, cb) {
                                                                    window.mc4wp.listeners.push({
                                                                        event: evt,
                                                                        callback: cb
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    })();
                                                </script>


                                                <form id="newsletterForm" action="<?= base_url('newsletter/subscribe') ?>" method="post">
                                                    <div class="mc4wp-form-fields">
                                                        <p>
                                                            <input type="email" name="email" placeholder="Enter email..." required>
                                                        </p>
                                                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>"
                                                            value="<?= $this->security->get_csrf_hash(); ?>">
                                                        <button type="submit" class="btn-mail pxl-btn btn-second">
                                                            <span class="pxl-button-text" data-text="Subscribe Now!">Subscribe Now!</span>
                                                        </button>
                                                    </div>
                                                </form>

                                                <!-- Response message area -->
                                                <div id="newsletterResponse" style="margin-top: 10px; font-weight: bold;"></div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="pxl-border-animated num-1">
                <div class="pxl-border-anm bt w-100" style="border-width: 1px 0 0 0; border-style: dashed; border-color: #FFFFFF26;"></div>
                <div class="pxl-border-anm br h-100" style="border-width: 0 0px 0 0; border-style: dashed; border-color: #FFFFFF26;"></div>
                <div class="pxl-border-anm bb w-100" style="border-width: 0 0 0px 0; border-style: dashed; border-color: #FFFFFF26;"></div>
                <div class="pxl-border-anm bl h-100" style="border-width: 0 0 0 0px; border-style: dashed; border-color: #FFFFFF26;"></div>
                <div class="elementor-element elementor-element-9654a93 e-flex e-con-boxed pxl-border-section-anm e-con e-child" data-id="9654a93" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;classic&quot;}">
                    <div class="e-con-inner">
                        <div class="elementor-element elementor-element-bcf0b7d elementor-absolute e-transform elementor-hidden-mobile elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="bcf0b7d" data-element_type="widget" data-settings="{&quot;_position&quot;:&quot;absolute&quot;,&quot;_animation&quot;:&quot;fadeInLeft&quot;,&quot;_animation_delay&quot;:400,&quot;_transform_translateY_effect&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:-100,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_laptop&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_tablet_extra&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_tablet&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_mobile_extra&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_mobile&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_laptop&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_tablet_extra&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_tablet&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_mobile_extra&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_mobile&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]}}" data-widget_type="pxl_image.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_image-bcf0b7d-6611" class="pxl-image-wg d-flex default"> <img width="239" height="233" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/07/img4-footer.webp.webp'); ?>" class="attachment-full size-full wp-image-231" alt="" /></div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-a2c4b30 e-flex e-con-boxed e-con e-child" data-id="a2c4b30" data-element_type="container">
                            <div class="e-con-inner">
                                <div class="elementor-element elementor-element-b422ba0 e-con-full e-flex e-con e-child" data-id="b422ba0" data-element_type="container">
                                    <div class="elementor-element elementor-element-ad72134 elementor-widget elementor-widget-pxl_text_editor" data-id="ad72134" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                        <div class="elementor-widget-container">
                                            <div id="pxl_text_editor-ad72134-9348" class="pxl-text-editor-wrap d-flex">
                                                <div class="pxl-text-editor elementor-clearfix">
                                                    <p><?php echo $cms_setting['copyright_text']; ?><br> Developed by <a href="#">Greatcoder Technologies | +234 816-323-8961</a>.</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="elementor-element elementor-element-3667320 e-con-full e-flex e-con e-child" data-id="3667320" data-element_type="container">
                                    <div class="elementor-element elementor-element-ed4b6e0 elementor-widget elementor-widget-pxl_text_editor" data-id="ed4b6e0" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                        <div class="elementor-widget-container">
                                            <div id="pxl_text_editor-ed4b6e0-9137" class="pxl-text-editor-wrap d-flex">
                                                <div class="pxl-text-editor elementor-clearfix">
                                                    <p><a class="hover-underline" href="faqs/index.html">Terms and Conditions</a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="elementor-element elementor-element-f0df297 elementor-widget elementor-widget-pxl_icon" data-id="f0df297" data-element_type="widget" data-widget_type="pxl_icon.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-icon-wg">
                                                <div class="icon-inner relative pxl-transition"> <span class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" height="512" viewBox="0 0 64 64" width="512" data-name="Layer 1">
                                                            <path d="m63 32a10.938 10.938 0 0 0 -11-10.875c-.35 0-.7.02-1.038.052.2-.277.389-.563.564-.863a10.807 10.807 0 0 0 -4.026-14.855 11.069 11.069 0 0 0 -15.026 3.98c-.176.3-.331.606-.474.915-.143-.309-.3-.615-.474-.915a11.069 11.069 0 0 0 -15.026-3.98 10.807 10.807 0 0 0 -4.026 14.855c.175.3.365.586.564.863-.342-.032-.688-.052-1.038-.052a10.876 10.876 0 1 0 0 21.75c.35 0 .7-.02 1.038-.052-.2.277-.389.563-.564.863a10.807 10.807 0 0 0 4.026 14.855 11.069 11.069 0 0 0 15.026-3.98c.176-.3.331-.606.474-.915.143.309.3.615.474.915a11.069 11.069 0 0 0 15.026 3.98 10.807 10.807 0 0 0 4.026-14.855c-.175-.3-.365-.586-.564-.863.342.032.688.052 1.038.052a10.938 10.938 0 0 0 11-10.875zm-31 9a9 9 0 1 1 9-9 9 9 0 0 1 -9 9z"></path>
                                                        </svg></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="elementor-element elementor-element-5658caa elementor-widget elementor-widget-pxl_text_editor" data-id="5658caa" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                        <div class="elementor-widget-container">
                                            <div id="pxl_text_editor-5658caa-4040" class="pxl-text-editor-wrap d-flex">
                                                <div class="pxl-text-editor elementor-clearfix">
                                                    <p><a class="hover-underline" href="#">Privacy Policy</a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="elementor-element elementor-element-8fba36b elementor-widget elementor-widget-pxl_icon" data-id="8fba36b" data-element_type="widget" data-widget_type="pxl_icon.default">
                                        <div class="elementor-widget-container">
                                            <div class="pxl-icon-wg">
                                                <div class="icon-inner relative pxl-transition"> <span class="pxl-icon"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" height="512" viewBox="0 0 64 64" width="512" data-name="Layer 1">
                                                            <path d="m63 32a10.938 10.938 0 0 0 -11-10.875c-.35 0-.7.02-1.038.052.2-.277.389-.563.564-.863a10.807 10.807 0 0 0 -4.026-14.855 11.069 11.069 0 0 0 -15.026 3.98c-.176.3-.331.606-.474.915-.143-.309-.3-.615-.474-.915a11.069 11.069 0 0 0 -15.026-3.98 10.807 10.807 0 0 0 -4.026 14.855c.175.3.365.586.564.863-.342-.032-.688-.052-1.038-.052a10.876 10.876 0 1 0 0 21.75c.35 0 .7-.02 1.038-.052-.2.277-.389.563-.564.863a10.807 10.807 0 0 0 4.026 14.855 11.069 11.069 0 0 0 15.026-3.98c.176-.3.331-.606.474-.915.143.309.3.615.474.915a11.069 11.069 0 0 0 15.026 3.98 10.807 10.807 0 0 0 4.026-14.855c-.175-.3-.365-.586-.564-.863.342.032.688.052 1.038.052a10.938 10.938 0 0 0 11-10.875zm-31 9a9 9 0 1 1 9-9 9 9 0 0 1 -9 9z"></path>
                                                        </svg></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="elementor-element elementor-element-ac542db elementor-widget elementor-widget-pxl_text_editor" data-id="ac542db" data-element_type="widget" data-widget_type="pxl_text_editor.default">
                                        <div class="elementor-widget-container">
                                            <div id="pxl_text_editor-ac542db-1650" class="pxl-text-editor-wrap d-flex">
                                                <div class="pxl-text-editor elementor-clearfix">
                                                    <p><a class="hover-underline" href="#">Manage Cookies</a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</footer>
</div>
<div class="pxl-page-overlay">
    <div class="pxl-cursor-icon"><span class="pxl-icon"></span></div>
</div>
<div class="pxl-hidden-template pxl-hidden-template-5759 el-builder pos-top " style="--tpl-bg-color:rgba(255,255,255,1);">
    <div class="pxl-hidden-template-wrap">
        <div class="pxl-panel-content custom_scroll"> <span class="pxl-close" title="Close"></span>
            <div data-elementor-type="wp-post" data-elementor-id="5759" class="elementor elementor-5759">
                <div class="elementor-element elementor-element-206d545 e-flex e-con-boxed e-con e-parent" data-id="206d545" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;classic&quot;}">
                    <div class="e-con-inner">
                        <div class="elementor-element elementor-element-a0902c8 pxl-anm-pxl_fadeIn elementor-absolute pxl-invisible elementor-widget elementor-widget-pxl_image" data-id="a0902c8" data-element_type="widget" data-settings="{&quot;pxl_animation&quot;:&quot;pxl_fadeIn&quot;,&quot;_position&quot;:&quot;absolute&quot;}" data-widget_type="pxl_image.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_image-a0902c8-3837" class="pxl-image-wg d-flex default" data-parallax="{&quot;x&quot;:&quot;50&quot;}"> <img width="176" height="40" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img5-home1.webp'); ?>" class="attachment-full size-full wp-image-5856" alt="" /></div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-c671ee8 elementor-absolute elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="c671ee8" data-element_type="widget" data-settings="{&quot;_position&quot;:&quot;absolute&quot;,&quot;_animation&quot;:&quot;fadeInDown&quot;}" data-widget_type="pxl_image.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_image-c671ee8-6974" class="pxl-image-wg d-flex default" data-parallax="{&quot;x&quot;:&quot;-80&quot;}"> <img width="528" height="500" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img41-home1.webp'); ?>" class="attachment-full size-full wp-image-6515" alt="" /></div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-96653fe pxl-anm-pxl_fadeIn elementor-absolute pxl-invisible elementor-widget elementor-widget-pxl_image" data-id="96653fe" data-element_type="widget" data-settings="{&quot;pxl_animation&quot;:&quot;pxl_fadeIn&quot;,&quot;_position&quot;:&quot;absolute&quot;}" data-widget_type="pxl_image.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_image-96653fe-3806" class="pxl-image-wg d-flex default" data-parallax="{&quot;x&quot;:&quot;-50&quot;}"> <img width="167" height="135" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img6-home1.webp'); ?>" class="attachment-full size-full wp-image-5855" alt="" /></div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-c78befd elementor-absolute elementor-widget elementor-widget-pxl_image" data-id="c78befd" data-element_type="widget" data-settings="{&quot;_position&quot;:&quot;absolute&quot;}" data-widget_type="pxl_image.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_image-c78befd-9947" class="pxl-image-wg d-flex pxl-draw-from-left default" data-setting-custom="{&quot;custom_animation_delay&quot;:400}"> <img width="490" height="274" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/09/img22-home2.webp'); ?>" class="attachment-full size-full wp-image-7621" alt="" /></div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-27b9e0d pxl-anm-pxl_zoomIn elementor-absolute pxl-invisible elementor-widget elementor-widget-pxl_image" data-id="27b9e0d" data-element_type="widget" data-settings="{&quot;pxl_animation&quot;:&quot;pxl_zoomIn&quot;,&quot;pxl_animation_delay&quot;:0.299999999999999988897769753748434595763683319091796875,&quot;_position&quot;:&quot;absolute&quot;}" data-widget_type="pxl_image.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_image-27b9e0d-4383" class="pxl-image-wg d-flex animated-rotate"> <img width="29" height="29" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img3-home1.webp'); ?>" class="attachment-full size-full wp-image-5861" alt="" /></div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-b77a6c6 pxl-anm-pxl_zoomIn elementor-absolute pxl-invisible elementor-widget elementor-widget-pxl_image" data-id="b77a6c6" data-element_type="widget" data-settings="{&quot;pxl_animation&quot;:&quot;pxl_zoomIn&quot;,&quot;pxl_animation_delay&quot;:0.59999999999999997779553950749686919152736663818359375,&quot;_position&quot;:&quot;absolute&quot;}" data-widget_type="pxl_image.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_image-b77a6c6-9675" class="pxl-image-wg d-flex animated-rotate"> <img width="29" height="29" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img3-home1.webp'); ?>" class="attachment-full size-full wp-image-5861" alt="" /></div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-278556e e-con-full e-flex e-con e-child" data-id="278556e" data-element_type="container">
                            <div class="elementor-element elementor-element-59d247d elementor-widget__width-initial elementor-widget elementor-widget-pxl_search" data-id="59d247d" data-element_type="widget" data-widget_type="pxl_search.default">
                                <div class="elementor-widget-container">
                                    <div class="pxl-search-wrap-wg layout-1">
                                        <form method="get" class="pxl-search-form relative" action=""> <input type="search" class="pxl-search-field" placeholder="Search for items..." value="" name="s" autocomplete="off" /> <button type="submit" class="pxl-search-submit" value=""><span class="pxl-icon pxli-search"></span></button></form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="pxl-hidden-template pxl-hidden-template-8020 el-builder pos-left ">
    <div class="pxl-hidden-template-wrap">
        <div class="pxl-panel-content custom_scroll"> <span class="pxl-close" title="Close"></span>
            <div data-elementor-type="wp-post" data-elementor-id="8020" class="elementor elementor-8020">
                <div class="elementor-element elementor-element-20ea70d e-flex e-con-boxed e-con e-parent" data-id="20ea70d" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;classic&quot;}">
                    <div class="e-con-inner">
                        <div class="elementor-element elementor-element-85d2be2 elementor-absolute elementor-invisible elementor-widget elementor-widget-pxl_image" data-id="85d2be2" data-element_type="widget" data-settings="{&quot;_position&quot;:&quot;absolute&quot;,&quot;_animation&quot;:&quot;fadeInRight&quot;,&quot;_animation_delay&quot;:400}" data-widget_type="pxl_image.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_image-85d2be2-5564" class="pxl-image-wg d-flex default"> <img width="528" height="500" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img41-home1.webp'); ?>" class="attachment-full size-full wp-image-6515" alt="" /></div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-5db6711 e-con-full e-flex elementor-invisible e-con e-child" data-id="5db6711" data-element_type="container" data-settings="{&quot;position&quot;:&quot;absolute&quot;,&quot;animation&quot;:&quot;zoomIn&quot;,&quot;animation_delay&quot;:400}">
                            <div class="elementor-element elementor-element-4282ac6 elementor-widget elementor-widget-pxl_image" data-id="4282ac6" data-element_type="widget" data-widget_type="pxl_image.default">
                                <div class="elementor-widget-container">
                                    <div id="pxl_image-4282ac6-5391" class="pxl-image-wg d-flex animated-rotate"> <img width="124" height="121" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img2-sun.webp'); ?>" class="attachment-full size-full wp-image-5739" alt="" /></div>
                                </div>
                            </div>
                            <div class="elementor-element elementor-element-68f251d elementor-widget__width-inherit elementor-absolute e-transform elementor-widget elementor-widget-pxl_image" data-id="68f251d" data-element_type="widget" data-settings="{&quot;_position&quot;:&quot;absolute&quot;,&quot;_transform_translateY_effect&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:-50,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_laptop&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_tablet_extra&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_tablet&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_mobile_extra&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateY_effect_mobile&quot;:{&quot;unit&quot;:&quot;%&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_laptop&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_tablet_extra&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_tablet&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_mobile_extra&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]},&quot;_transform_translateX_effect_mobile&quot;:{&quot;unit&quot;:&quot;px&quot;,&quot;size&quot;:&quot;&quot;,&quot;sizes&quot;:[]}}" data-widget_type="pxl_image.default">
                                <div class="elementor-widget-container">
                                    <div id="pxl_image-68f251d-4332" class="pxl-image-wg d-flex default"> <img width="84" height="86" src="<?php echo base_url('assets/frontend/wp-content/uploads/2025/08/img1-sun.webp'); ?>" class="attachment-full size-full wp-image-5738" alt="" /></div>
                                </div>
                            </div>
                        </div>
                        <div class="elementor-element elementor-element-4e6d0b9 elementor-widget elementor-widget-pxl_menu" data-id="4e6d0b9" data-element_type="widget" data-widget_type="pxl_menu.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_menu-4e6d0b9-1966" class="pxl-nav-menu pxl-nav-menu-mobile">
                                    <div class="menu-menu-main-container">


                                        <ul id="pxl-mobile-menu" class="pxl-mobile-menu clearfix">
                                            <?php
                                            $school = $this->uri->segment(1);
                                            $result = $this->home_model->menuList($school);
                                            $currentURL = base_url(uri_string());

                                            foreach ($result as $key => $row) {
                                                $active_menu    = '';
                                                $submenu_class  = '';
                                                $submenu_active = '';
                                                $op_new_tab     = '';
                                                $has_children   = '';

                                                // Active state
                                                if ($currentURL == $row['url']) {
                                                    $active_menu = ' current-menu-item current_page_item';
                                                }

                                                // Check for submenu
                                                if (!empty($row['submenu']) && is_array($row['submenu'])) {
                                                    $submenu_class = ' menu-item-has-children';
                                                    $has_children  = '<span class="main-menu-toggle"></span>';
                                                    $arrayURL = array_column($row['submenu'], 'url');
                                                    if (in_array($currentURL, $arrayURL)) {
                                                        $submenu_active = ' current-menu-ancestor current-menu-parent';
                                                    }
                                                }

                                                // Open link in new tab
                                                if (!empty($row['open_new_tab'])) {
                                                    $op_new_tab = "target='_blank'";
                                                }

                                                // Skip hidden admissions (optional)
                                                if (isset($cms_setting['online_admission']) && $cms_setting['online_admission'] == 0 && $row['alias'] == 'admission') continue;
                                            ?>
                                                <li class="menu-item menu-item-type-custom menu-item-object-custom<?php echo $active_menu . $submenu_class . $submenu_active; ?>">
                                                    <a href="<?php echo $row['url']; ?>" <?php echo $op_new_tab; ?>>
                                                        <span class="pxl-menu-title"><?php echo $row['title']; ?></span>
                                                    </a>
                                                    <?php echo $has_children; ?>

                                                    <?php if (!empty($row['submenu'])) { ?>
                                                        <ul class="sub-menu">
                                                            <?php foreach ($row['submenu'] as $row2) {
                                                                $active_sub = ($currentURL == $row2['url']) ? ' current-menu-item' : '';
                                                                $op_new_tab = !empty($row2['open_new_tab']) ? "target='_blank'" : '';
                                                            ?>
                                                                <li class="menu-item<?php echo $active_sub; ?>">
                                                                    <a href="<?php echo $row2['url']; ?>" <?php echo $op_new_tab; ?>>
                                                                        <span class="pxl-menu-title"><?php echo $row2['title']; ?></span>
                                                                    </a>
                                                                </li>
                                                            <?php } ?>
                                                        </ul>
                                                    <?php } ?>
                                                </li>
                                            <?php } ?>
                                        </ul>







                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="elementor-element elementor-element-5956ea4 elementor-widget elementor-widget-pxl_button"
                            data-id="5956ea4" data-element_type="widget" data-widget_type="pxl_button.default">
                            <div class="elementor-widget-container">
                                <div id="pxl_button-5956ea4-4525" class="pxl-button-wrapper d-flex align-items-center"> 
                                    <?php if (!is_loggedin()) { ?>
                                        <a href="<?php echo $authenticationURL; ?>" class="pxl-btn btn-second icon-ps-right">
                                            <span class="pxl-button-text icon-move" data-text="Login">Login</span>
                                        </a>
                                    <?php } else { ?>
                                        <a href="<?php echo base_url('dashboard'); ?>" class="pxl-btn btn-second icon-ps-right">
                                            <span class="pxl-button-text icon-move" data-text="Dashboard">Dashboard</span>
                                        </a>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


</div>
</div> <a href="index.html" class="pxl-scroll-top" data-target="#pxl-page"> <svg class="pxl-scroll-progress-circle" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
    </svg> <span class="pxl-icon pxli-angle-up"></span> </a>

<!-- Tawk.to Chat script  -->
<?php $this->load->view('templates/layout/homepage_layout/chat_script'); ?>    







<!-- Developer :David Abuja- 08163238961 -->

<script type="speculationrules"> {"prefetch":[{"source":"document","where":{"and":[{"href_matches":"\/little-sprouts\/*"},{"not":{"href_matches":["\/little-sprouts\/wp-*.php","\/little-sprouts\/wp-admin\/*","\/little-sprouts\/wp-content\/uploads\/*","\/little-sprouts\/wp-content\/*","\/little-sprouts\/wp-content\/plugins\/*","\/little-sprouts\/wp-content\/themes\/sprouts\/*","\/little-sprouts\/*\\?(.+)"]}},{"not":{"selector_matches":"a[rel~=\"nofollow\"]"}},{"not":{"selector_matches":".no-prefetch, .no-prefetch a"}}]},"eagerness":"conservative"}]} </script>
<script>
    (function() {
        function maybePrefixUrlField() {
            const value = this.value.trim()
            if (value !== '' && value.indexOf('http') !== 0) {
                this.value = 'http://' + value
            }
        }
        const urlFields = document.querySelectorAll('.mc4wp-form input[type="url"]')
        for (let j = 0; j < urlFields.length; j++) {
            urlFields[j].addEventListener('blur', maybePrefixUrlField)
        }
    })();

</script>
<div id="woosw_wishlist" class="woosw-popup woosw-popup-center"></div>
<script>
    const lazyloadRunObserver = () => {
        const lazyloadBackgrounds = document.querySelectorAll(`.e-con.e-parent:not(.e-lazyloaded)`);
        const lazyloadBackgroundObserver = new IntersectionObserver((entries) => {
            entries.forEach((entry) => {
                if (entry.isIntersecting) {
                    let lazyloadBackground = entry.target;
                    if (lazyloadBackground) {
                        lazyloadBackground.classList.add('e-lazyloaded');
                    }
                    lazyloadBackgroundObserver.unobserve(entry.target);
                }
            });
        }, {
            rootMargin: '200px 0px 200px 0px'
        });
        lazyloadBackgrounds.forEach((lazyloadBackground) => {
            lazyloadBackgroundObserver.observe(lazyloadBackground);
        });
    };
    const events = [
        'DOMContentLoaded',
        'elementor/lazyload/observe',
    ]; 
    events.forEach((event) => {
        document.addEventListener(event, lazyloadRunObserver);
    });
</script>
<script type='text/javascript'>
    (function() {
        var c = document.body.className;
        c = c.replace(/woocommerce-no-js/, 'woocommerce-js');
        document.body.className = c;
    })();
</script>

<link rel='stylesheet' id='wc-blocks-style-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks63b3.css?ver=wc-10.1.0'); ?>' type='text/css' media='all' />



<link rel='stylesheet' id='widget-divider-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/css/widget-divider.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />



<link rel='stylesheet' id='e-animation-zoomIn-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/lib/animations/styles/zoomIn.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />


<link rel='stylesheet' id='e-animation-grow-rotate-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/lib/animations/styles/e-animation-grow-rotate.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />



<link rel='stylesheet' id='widget-social-icons-css' href='<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/css/widget-social-icons.min905c.css?ver=3.32.0'); ?>' type='text/css' media='all' />


<link rel='stylesheet' id='e-apple-webkit-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/custom-apple-webkit.min7468.css?ver=1759398840'); ?>' type='text/css' media='all' />


<link rel='stylesheet' id='elementor-post-5759-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/post-57599abb.css?ver=1759398859'); ?>' type='text/css' media='all' />


<link rel='stylesheet' id='elementor-post-8020-css' href='<?php echo base_url('assets/frontend/wp-content/uploads/elementor/css/post-80209abb.css?ver=1759398859'); ?>' type='text/css' media='all' />


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/pxl-core-main.min8a54.js?ver=1.0.0'); ?>" id="pxl-core-main-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-includes/js/dist/hooks.min4fdd.js?ver=4d63a3d491d11ffd8ac6'); ?>" id="wp-hooks-js"></script>

<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-includes/js/dist/i18n.minc33c.js?ver=5e580eb46a90c2b997e6'); ?>" id="wp-i18n-js"></script>


<script type="text/javascript" id="wp-i18n-js-after">
    /* <![CDATA[ */
    wp.i18n.setLocaleData({
        'text direction\u0004ltr': ['ltr']
    });
    /* ]]> */
</script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/swv.min9b2d.js?ver=6.1" id="swv-js'); ?>"></script>






<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/js/webpack.runtime.min905c.js?ver=3.32.0'); ?>" id="elementor-webpack-runtime-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/js/frontend-modules.min905c.js?ver=3.32.0'); ?>" id="elementor-frontend-modules-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-includes/js/jquery/ui/core.minb37e.js?ver=1.13.3'); ?>" id="jquery-ui-core-js"></script>



<script type="text/javascript" id="elementor-frontend-js-before">
    /* <![CDATA[ */
    var elementorFrontendConfig = {
        "environmentMode": {
            "edit": false,
            "wpPreview": false,
            "isScriptDebug": false
        },
        "i18n": {
            "shareOnFacebook": "Share on Facebook",
            "shareOnTwitter": "Share on Twitter",
            "pinIt": "Pin it",
            "download": "Download",
            "downloadImage": "Download image",
            "fullscreen": "Fullscreen",
            "zoom": "Zoom",
            "share": "Share",
            "playVideo": "Play Video",
            "previous": "Previous",
            "next": "Next",
            "close": "Close",
            "a11yCarouselPrevSlideMessage": "Previous slide",
            "a11yCarouselNextSlideMessage": "Next slide",
            "a11yCarouselFirstSlideMessage": "This is the first slide",
            "a11yCarouselLastSlideMessage": "This is the last slide",
            "a11yCarouselPaginationBulletMessage": "Go to slide"
        },
        "is_rtl": false,
        "breakpoints": {
            "xs": 0,
            "sm": 480,
            "md": 576,
            "lg": 992,
            "xl": 1440,
            "xxl": 1600
        },
        "responsive": {
            "breakpoints": {
                "mobile": {
                    "label": "Mobile Portrait",
                    "value": 575,
                    "default_value": 767,
                    "direction": "max",
                    "is_enabled": true
                },
                "mobile_extra": {
                    "label": "Mobile Landscape",
                    "value": 767,
                    "default_value": 880,
                    "direction": "max",
                    "is_enabled": true
                },
                "tablet": {
                    "label": "Tablet Portrait",
                    "value": 991,
                    "default_value": 1024,
                    "direction": "max",
                    "is_enabled": true
                },
                "tablet_extra": {
                    "label": "Tablet Landscape",
                    "value": 1199,
                    "default_value": 1200,
                    "direction": "max",
                    "is_enabled": true
                },
                "laptop": {
                    "label": "Laptop",
                    "value": 1599,
                    "default_value": 1366,
                    "direction": "max",
                    "is_enabled": true
                },
                "widescreen": {
                    "label": "Widescreen",
                    "value": 2400,
                    "default_value": 2400,
                    "direction": "min",
                    "is_enabled": false
                }
            },
            "hasCustomBreakpoints": true
        },
        "version": "3.32.0",
        "is_static": false,
        "experimentalFeatures": {
            "e_font_icon_svg": true,
            "additional_custom_breakpoints": true,
            "container": true,
            "e_optimized_markup": true,
            "home_screen": true,
            "global_classes_should_enforce_capabilities": true,
            "e_variables": true,
            "cloud-library": true,
            "e_opt_in_v4_page": true,
            "import-export-customization": true
        },
        "urls": {
            "assets": "<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/'); ?>",
            "ajaxurl": "<?php echo base_url('assets/frontend/wp-admin/admin-ajax.php'); ?>",
            "uploadUrl": "<?php echo base_url('assets/frontend/wp-content/uploads'); ?>"
        },
        "nonces": {
            "floatingButtonsClickTracking": "db795ded47"
        },
        "swiperClass": "swiper",
        "settings": {
            "page": [],
            "editorPreferences": []
        },
        "kit": {
            "active_breakpoints": ["viewport_mobile", "viewport_mobile_extra", "viewport_tablet", "viewport_tablet_extra", "viewport_laptop"],
            "viewport_mobile": 575,
            "viewport_mobile_extra": 767,
            "viewport_tablet": 991,
            "viewport_tablet_extra": 1199,
            "viewport_laptop": 1599,
            "global_image_lightbox": "yes",
            "lightbox_enable_counter": "yes",
            "lightbox_enable_fullscreen": "yes",
            "lightbox_enable_zoom": "yes",
            "lightbox_enable_share": "yes",
            "lightbox_title_src": "title",
            "lightbox_description_src": "description"
        },
        "post": {
            "id": 5781,
            "title": "Little%20Sprouts",
            "excerpt": "",
            "featuredImage": false
        }
    };
    /* ]]> */
</script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/elementor/assets/js/frontend.min905c.js?ver=3.32.0" id="elementor-frontend-js'); ?>"></script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/pxltheme-core/assets/js/libs/swiper/v8/swiper.min94a4.js?ver=8.4.5'); ?>" id="swiper-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-includes/js/jquery/ui/datepicker.minb37e.js?ver=1.13.3" id="jquery-ui-datepicker-js'); ?>"></script>


<script type="text/javascript" id="jquery-ui-datepicker-js-after">
    /* <![CDATA[ */
    jQuery(function(jQuery) {
        jQuery.datepicker.setDefaults({
            "closeText": "Close",
            "currentText": "Today",
            "monthNames": ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
            "monthNamesShort": ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
            "nextText": "Next",
            "prevText": "Previous",
            "dayNames": ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
            "dayNamesShort": ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
            "dayNamesMin": ["S", "M", "T", "W", "T", "F", "S"],
            "dateFormat": "MM d, yy",
            "firstDay": 1,
            "isRTL": false
        });
    });
    /* ]]> */
</script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/pxltheme-core/assets/js/libs/jquery.timepicker.min5152.js?ver=1.0'); ?>" id="pxl-timepicker-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/woo-smart-wishlist/assets/libs/perfect-scrollbar/js/perfect-scrollbar.jquery.mince52.js?ver=5.0.2'); ?>" id="perfect-scrollbar-js"></script>





<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/woosw-frontend.mince52.js?ver=5.0.2'); ?>" id="woosw-frontend-js"></script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/woocommerce/assets/js/sourcebuster/sourcebuster.min1c61.js?ver=10.1.0'); ?>" id="sourcebuster-js-js"></script>






<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/woocommerce/assets/js/frontend/order-attribution.min1c61.js?ver=10.1.0'); ?>" id="wc-order-attribution-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/js/gsap.min3b71.js?ver=3.5.0'); ?>" id="gsap-js"></script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/pxl-parallax-scroll.min5152.js?ver=1.0'); ?>" id="pxl-parallax-scroll-js"></script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/js/nice-select.min5152.js?ver=1.0'); ?>" id="nice-select-js"></script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/sprouts-cursor.min5152.js?ver=1.0'); ?>" id="sprouts-cursor-js"></script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/js/libs/InertiaPlugin.min03ec.js?ver=3.12.5'); ?>" id="inertiaplugin-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/js/libs/TweenMax.min431f.js?ver=2.1.2'); ?>" id="TweenMax-js"></script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/js/libs/curtains.min8a54.js?ver=1.0.0'); ?>" id="curtains-lib-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/js/libs/magnific-popup.min8a54.js?ver=1.0.0'); ?>" id="magnific-popup-js"></script>



<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/js/libs/vanilla-tilt.mindc98.js?ver=all'); ?>" id="vanilla-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/gsMotionPath.min0f26.js?ver=3.12.7'); ?>" id="gsMotionPath-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/js/ScrollTrigger.min03ec.js?ver=3.12.5'); ?>" id="gsap-scroll-trigger-js"></script>






<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/sprouts-main.min5152.js?ver=1.0'); ?>" id="sprouts-main-js"></script>


<script type="text/javascript" id="sprouts-global-js-extra">
    /* <![CDATA[ */
    var elements_data = {
        "splittext_toggle_actions": "play none none none",
        "animation_toggle_actions": "play none none none"
    };
    /* ]]> */
</script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/sprouts-global.min5152.js?ver=1.0'); ?>" id="sprouts-global-js"></script>
<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/themes/sprouts/assets/js/SplitText.min03ec.js?ver=3.12.5'); ?>" id="gsap-split-text-js"></script>



<script type="text/javascript" id="sprouts-splittext-js-extra">
    /* <![CDATA[ */
    var elements_data = {
        "splittext_toggle_actions": "play none none none",
        "animation_toggle_actions": "play none none none"
    };
    /* ]]> */
</script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/sprouts-splittext.min5152.js?ver=1.0'); ?>" id="sprouts-splittext-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/sprouts-elements.min5152.js?ver=1.0'); ?>" id="sprouts-elements-js"></script>


<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/sprouts-swiper.min5152.js?ver=1.0'); ?>" id="sprouts-swiper-js"></script>

<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/sprouts-countdown.min5152.js?ver=1.0'); ?>" id="sprouts-countdown-js'); ?>"></script>

<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/uploads/siteground-optimizer-assets/sprouts-moving-path.min5152.js?ver=1.0'); ?>" id="sprouts-moving-path-js"></script>

<script type="text/javascript" id="wc-cart-fragments-js-extra">
    /* <![CDATA[ */
    var wc_cart_fragments_params = {
        "ajax_url": "\/little-sprouts\/wp-admin\/admin-ajax.php",
        "wc_ajax_url": "\/little-sprouts\/?wc-ajax=%%endpoint%%",
        "cart_hash_key": "wc_cart_hash_5c23cf5b5a3f1d9d97e72d5e7f18f2aa",
        "fragment_name": "wc_fragments_5c23cf5b5a3f1d9d97e72d5e7f18f2aa",
        "request_timeout": "5000"
    };
    /* ]]> */
</script>

<script type="text/javascript" src="<?php echo base_url('assets/frontend/wp-content/plugins/woocommerce/assets/js/frontend/cart-fragments.min1c61.js?ver=10.1.0'); ?>" id="wc-cart-fragments-js" defer="defer" data-wp-strategy="defer"></script>

<script type="text/javascript" defer src="<?php echo base_url('assets/frontend/wp-content/plugins/mailchimp-for-wp/assets/js/forms00f2.js?ver=4.10.5'); ?>" id="mc4wp-forms-api-js">




</script>



                            <script>
                                document.addEventListener("DOMContentLoaded", () => {
                                    const form = document.getElementById("ajaxCF7Form");
                                    const responseBox = document.getElementById("formResponse");
                                    const submitBtn = document.getElementById("formSubmitBtn");

                                    form.addEventListener("submit", async (e) => {
                                        e.preventDefault();
                                        responseBox.innerHTML = "";

                                        // ✅ Basic client-side validation
                                        const email = document.getElementById("email-298").value.trim();
                                        const name = document.getElementById("text-name").value.trim();
                                        const message = document.getElementById("textarea-797").value.trim();

                                        if (!name || !email || !message || !email.match(/^[^@\s]+@[^@\s]+\.[^@\s]+$/)) {
                                            form.classList.remove("shake");
                                            void form.offsetWidth; // restart animation
                                            form.classList.add("shake");
                                            responseBox.innerHTML = '<div class="alert alert-danger">Please fill all fields correctly.</div>';
                                            return;
                                        }

                                        submitBtn.disabled = true;
                                        submitBtn.innerHTML = 'Sending... <span class="loader"></span>';

                                        const formData = new FormData(form);

                                        try {
                                            const res = await fetch(form.action, {
                                                method: "POST",
                                                body: formData,
                                                headers: {
                                                    "X-Requested-With": "XMLHttpRequest"
                                                },
                                            });

                                            const text = await res.text();
                                            let data;
                                            try {
                                                data = JSON.parse(text);
                                            } catch {
                                                throw new Error("Invalid JSON: " + text.slice(0, 100));
                                            }

                                            document.querySelectorAll(".text-danger").forEach(el => el.textContent = "");

                                            if (data.status === "success") {
                                                responseBox.innerHTML = `
          <div class="alert alert-success" id="fadeMsg">
            ${data.message || "Thank you for contacting us! Champions Montessori Academy will get back to you shortly."}
          </div>
        `;
                                                form.reset();
                                                if (typeof grecaptcha !== "undefined") grecaptcha.reset();

                                                setTimeout(() => {
                                                    const msg = document.getElementById("fadeMsg");
                                                    if (msg) msg.classList.add("fade-out");
                                                    setTimeout(() => msg?.remove(), 1000);
                                                }, 4000);

                                            } else {
                                                responseBox.innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
                                            }
                                        } catch (error) {
                                            console.error("AJAX Error:", error);
                                            responseBox.innerHTML = '<div class="alert alert-danger">Network or server error. Please try again later.</div>';
                                        } finally {
                                            submitBtn.disabled = false;
                                            submitBtn.innerHTML = "Send Message";
                                        }
                                    });
                                });
                            </script>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const form = document.getElementById("newsletterForm");
    const responseBox = document.getElementById("newsletterResponse");

    form.addEventListener("submit", async function(e) {
        e.preventDefault(); // Stop page reload

        const formData = new FormData(form);

        // Show waiting message
        responseBox.style.display = "block";
        responseBox.style.color = "gray";
        responseBox.innerText = "Please wait...";

        try {
            const response = await fetch(form.action, {
                method: "POST",
                body: formData
            });

            const text = await response.text();

            if (text.toLowerCase().includes("successfully")) {
                responseBox.style.color = "#fff";
                responseBox.innerText = text;
                form.reset();
            } else {
                responseBox.style.color = "#ecfc15ff";
                responseBox.innerText = text;
            }

            // Fade out smoothly after a few seconds
            setTimeout(() => {
                responseBox.style.transition = "opacity 1s ease";
                responseBox.style.opacity = "0";
                setTimeout(() => {
                    responseBox.style.display = "none";
                    responseBox.style.opacity = "1"; // reset
                }, 1000);
            }, 4000);

        } catch (error) {
            responseBox.style.color = "red";
            responseBox.innerText = "An error occurred. Please try again.";

            setTimeout(() => {
                responseBox.style.transition = "opacity 1s ease";
                responseBox.style.opacity = "0";
                setTimeout(() => {
                    responseBox.style.display = "none";
                    responseBox.style.opacity = "1"; // reset
                }, 1000);
            }, 4000);
        }
    });
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
  const videoBtns = document.querySelectorAll('.pxl-video-lightbox');

  videoBtns.forEach(btn => {
    btn.addEventListener('click', function() {
      const data = btn.getAttribute('data-elementor-lightbox');
      if (!data) return;

      const opts = JSON.parse(data);
      const videoUrl = opts.url.replace("embed/", "watch?v=");

      const modal = document.createElement('div');
      modal.style.cssText = `
        position: fixed; top: 0; left: 0; width: 100%; height: 100%;
        background: rgba(0,0,0,0.8); display: flex; align-items: center;
        justify-content: center; z-index: 99999;
      `;
      modal.innerHTML = `
        <iframe width="80%" height="70%" src="${opts.url}" frameborder="0" allowfullscreen></iframe>
      `;
      modal.addEventListener('click', () => modal.remove());
      document.body.appendChild(modal);
    });
  });
});
</script>



	</body>
</html>