<?php
$marksheet_template = $this->marksheet_template_model->getTemplate($templateID, $branchID);
if (!$marksheet_template) {
	echo "<div class='alert alert-danger'>No template found for this class/branch.</div>";
	return;
}
$checkmark = '✔';
$emptyCircle = '○';
?>

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Playwrite+US+Trad+Guides&display=swap" rel="stylesheet">

<style>
body {
    font-family: 'Playwrite US Trad Guides', sans-serif;
    font-size: 12px;
    margin: 0;
    padding: 0;
}
.mark-container {
    width: 88%;
    padding: 10px;
	margin-top: 0px;
    border: 2px dotted #000;
    position: relative;
    z-index: 1;
}

@media print {

    html, body {
        width: 210mm;
        height: 297mm;
        margin: 0;
        padding: 0;
        overflow: hidden;
    }

    .mark-container {
        page-break-after: always;
        break-after: page;
    }

    .mark-container:last-child {
        page-break-after: auto;
    }

    table, tr, td, th {
        page-break-inside: avoid !important;
        break-inside: avoid !important;
    }
}

	.stamp-wrapper {
    width: 90px !important;
    height: auto !important;
    max-width: 40px !important;
    max-height: 90px !important;
    
}

	.stamp-wrapper img {
    width: 90px !important;
    height: auto !important;
    max-width: 40px !important;
    max-height: 90px !important;
    opacity: 0.85;
}
.signature-box {
    position: relative;
    width: 180px;
    height: 120px;
    margin: 5px auto 0;
    text-align: center;
}

.signature-box img {
    max-width: 120px !important;
    max-height: 60px !important;
}


table {
    width: 100%;
    border-collapse: collapse;
    font-size: 10px;
    margin-bottom: 0px;
}
th, td {
    border: 1px solid #000;
    padding: 2px;
    text-align: center;
    vertical-align: middle;
}


</style>

<?php
if (!empty($student_array)):

    $studentID = $student_array[0];
    $result = $this->exam_model->getStudentReportCard($studentID, $examID, $sessionID, $class_id, $section_id);

    if (!empty($result['exams'])):

        $student = $result['student'];
        $getMarksList = $result['exams'];

        $rankDetail = $this->db->where(['exam_id'=>$examID,'enroll_id'=>$student['enrollID']])->get('exam_rank')->row();
        $getExam = $this->db->where(['id'=>$examID])->get('exam')->row_array();
        $schoolYear = get_type_name_by_id('schoolyear', $sessionID, 'school_year');

        $extendsData = [
            'print_date' => $print_date,
            'schoolYear' => $schoolYear,
            'exam_name' => $getExam['name'],
            'teacher_comments' => $rankDetail->teacher_comments ?? '',
            'principal_comments' => $rankDetail->principal_comments ?? '',
        ];

        $header_content = $this->marksheet_template_model->tagsReplace($student, $marksheet_template, $extendsData, 'header_content');
        $footer_content = $this->marksheet_template_model->tagsReplace($student, $marksheet_template, $extendsData, 'footer_content');

        // Total students in class and section
        $getTotalClass = $this->db->where(['session_id'=>$sessionID,'class_id'=>$student['class_id'],'is_alumni'=>0])->from('enroll')->count_all_results();
        $getTotalSection = $this->db->where(['session_id'=>$sessionID,'section_id'=>$student['section_id'],'is_alumni'=>0])->from('enroll')->count_all_results();
?>

<div style="position: relative; width: 100%; height: 100%;">
    <div class="background"></div>
    <div class="mark-container">
        <?= $header_content ?>

        <!-- Marks Table -->
        <table>
            <thead>
                <tr>
                    <th>Subjects</th>
                    <?php
                    $markDistribution = json_decode($getExam['mark_distribution'], true) ?? [];
                    foreach ($markDistribution as $id) {
                        echo "<th>" . get_type_name_by_id('exam_mark_distribution',$id) . "</th>";
                    }

                    if ($getExam['type_id'] == 1) echo "<th>Total</th>";
                    elseif ($getExam['type_id'] == 2) echo "<th>Grade</th><th>Average</th><th>Remark</th>";
                    elseif ($getExam['type_id'] == 3) echo "<th>Total</th><th>Average</th><th>Grade</th><th>Remark</th><th>Position</th>";
                    ?>
                </tr>
            </thead>
            <tbody>
                <?php
                $grand_obtain_marks = 0;
                $grand_full_marks = 0;
                $total_grade_point = 0;

                foreach ($getMarksList as $row):
                    $obtainedMarks = is_string($row['get_mark']) ? json_decode($row['get_mark'], true) : ($row['get_mark'] ?? []);
                    $fullMarks = is_string($row['mark_distribution']) ? json_decode($row['mark_distribution'], true) : ($row['mark_distribution'] ?? []);

                    $subject_total = 0;
                    $subject_full = 0;
                ?>
                    <tr>
                        <td><?= $row['subject_name'] ?></td>
                        <?php foreach($fullMarks as $i => $val):
                            $obtained_mark = floatval($obtainedMarks[$i] ?? 0);
                            $fullMark = floatval($val['full_mark'] ?? 0);
                            $passMark = floatval($val['pass_mark'] ?? 0);

                            $subject_total += $obtained_mark;
                            $subject_full += $fullMark;
                            $grand_obtain_marks += $obtained_mark;
                            $grand_full_marks += $fullMark;

                            if ($getExam['type_id'] == 1 || $getExam['type_id'] == 3):
                                $display = ($row['subject_status']=='not_offered') ? 'Absent' : $obtained_mark;
                        ?>
                            <td><?= $display ?></td>
                        <?php
                            elseif ($getExam['type_id'] == 2):
                                $percentage = $fullMark>0?($obtained_mark*100/$fullMark):0;
                                $grade = $this->exam_model->getExam_grade($percentage, $getExam['branch_id']);
                        ?>
                            <td><?= $grade['name'] ?></td>
                        <?php endif; endforeach; ?>

                        <?php if ($getExam['type_id'] == 1 || $getExam['type_id'] == 3) echo "<td>$subject_total</td>";
                        if ($getExam['type_id'] == 2):
                            $percentage_total = $subject_full>0?($subject_total*100/$subject_full):0;
                            $grade = $this->exam_model->getExam_grade($percentage_total,$getExam['branch_id']);
                            $total_grade_point += $grade['grade_point'];
                        ?>
                            <td><?= number_format($percentage_total,2) ?></td>
                            <td><?= $grade['name'] ?></td>
                            <td><?= $grade['remark'] ?></td>
                        <?php endif; ?>

                        <?php if ($getExam['type_id'] == 3):
                            $percentage_total = $subject_full>0?($subject_total*100/$subject_full):0;
                            $grade = $this->exam_model->getExam_grade($percentage_total,$getExam['branch_id']);
                        ?>
                            <td><?= number_format($percentage_total,2) ?></td>
                            <td><?= $grade['name'] ?></td>
                            <td><?= $grade['remark'] ?></td>
                            <td><?= $this->exam_model->getSubjectPosition($student['class_id'],$student['section_id'],$getExam,$sessionID,$row['subject_id'],$subject_total) ?></td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; ?>
                <tr>
                    <td><b>GRAND TOTAL</b></td>
                    <td colspan="<?= count($markDistribution)+1 ?>"><?= $grand_obtain_marks ?></td>
                </tr>
            </tbody>
        </table>

        <!-- Progressive Evaluation -->
        <table class="table table-bordered">
            <tr>
                <td colspan="3">PROGRESSIVE CUMMULATIVE EVALUATION: <?= $grand_obtain_marks ?></td>
                <td>Average: <?= ($grand_full_marks>0)?number_format(($grand_obtain_marks*100)/$grand_full_marks,2):0 ?>%</td>
                <?php if ($marksheet_template['class_position'] == 1) { ?>
                <td colspan="4">POSITION IN CLASS: <?= $student['clrank'] ?> / <?= $getTotalClass ?></td>
                <?php } ?>
                <?php if ($marksheet_template['section_position'] == 1) { ?>
                <td colspan="4">POSITION IN SECTION: <?= $student['secrank'] ?> / <?= $getTotalSection ?></td>
                <?php } ?>
                <td>Subject Enrolled: <?= count($getMarksList) ?></td>
            </tr>
           
        </table>

        <!-- Skills & Behaviour -->
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th colspan="3">SKILLS</th>
                    <th colspan="5">BEHAVIOUR</th>
                    <th colspan="5">BEHAVIOUR CONT'D</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $skills = [
                    ['label'=>'Handwriting','key'=>'behav_cmaskill1'],
                    ['label'=>'Helping Others','key'=>'behav_cmaskill2'],
                    ['label'=>'Emotional Stability','key'=>'behav_cmaskill3'],
                    ['label'=>'Nonverbal Skill','key'=>'behav_cmaskill4'],
                    ['label'=>'Perseverance','key'=>'behav_cmaskill5'],
                    ['label'=>'Attitude to Work','key'=>'behav_cmaskill6']
                ];
                $behaviour = [
                    ['label'=>'Material/Tool Handling','key'=>'behav_cmabehav1'],
                    ['label'=>'Neatness','key'=>'behav_cmabehav2'],
                    ['label'=>'Orderliness','key'=>'behav_cmabehav3'],
                    ['label'=>'Punctuality','key'=>'behav_cmabehav4'],
                    ['label'=>'Honesty','key'=>'behav_cmabehav5'],
                    ['label'=>'Politeness','key'=>'behav_cmabehav6']
                ];
                $behaviour_contd = [
                    ['label'=>'Cooperation','key'=>'behav_behavcontd1'],
                    ['label'=>'Leadership','key'=>'behav_behavcontd2'],
                    ['label'=>'Speaking','key'=>'behav_behavcontd3']
                ];
                $levels = ['5','4','3','2','1'];
                $maxRows = max(count($skills), count($behaviour), count($behaviour_contd));

                for($i=0;$i<$maxRows;$i++):
                    echo "<tr>";
                    // Skills
                    if(isset($skills[$i])):
                        echo "<td colspan='3'>{$skills[$i]['label']}</td>";
                        foreach($levels as $lvl):
                            $val = $student[$skills[$i]['key']] ?? '';
                            echo "<td>".($val==$lvl?$checkmark:$emptyCircle)."</td>";
                        endforeach;
                    else:
                        echo "<td colspan='8'></td>";
                    endif;

                    // Behaviour
                    if(isset($behaviour[$i])):
                        echo "<td colspan='5'>{$behaviour[$i]['label']}</td>";
                        foreach($levels as $lvl):
                            $val = $student[$behaviour[$i]['key']] ?? '';
                            echo "<td>".($val==$lvl?$checkmark:$emptyCircle)."</td>";
                        endforeach;
                    else:
                        echo "<td colspan='6'></td>";
                    endif;

                    // Behaviour Contd
                    if(isset($behaviour_contd[$i])):
                        echo "<td colspan='5'>{$behaviour_contd[$i]['label']}</td>";
                        foreach($levels as $lvl):
                            $val = $student[$behaviour_contd[$i]['key']] ?? '';
                            echo "<td>".($val==$lvl?$checkmark:$emptyCircle)."</td>";
                        endforeach;
                    else:
                        echo "<td colspan='6'></td>";
                    endif;
                    echo "</tr>";
                endfor;
                ?>
            </tbody>
        </table>

        <!-- KEY TO SUBJECT GRADING -->
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th colspan="4">KEY TO SUBJECT GRADING:</th>
                </tr>
                <tr>
                    <th>From</th><th>To</th><th>Grade</th><th>Remark</th>
                </tr>
            </thead>
            <tbody>
                <tr><td>0%</td><td>39%</td><td>F</td><td>FAIL</td></tr>
                <tr><td>40%</td><td>44%</td><td>E</td><td>FAIR</td></tr>
                <tr><td>45%</td><td>49%</td><td>D</td><td>PASS</td></tr>
                <tr><td>50%</td><td>69%</td><td>C</td><td>GOOD</td></tr>
                <tr><td>70%</td><td>79%</td><td>B</td><td>VERY GOOD</td></tr>
                <tr><td>80%</td><td>100%</td><td>A</td><td>EXCELLENT</td></tr>
            </tbody>
        </table>

        <?= $footer_content ?>
    </div>
</div>

<?php
    else:
        echo '<div class="alert alert-danger text-center">No report card data found.</div>';
    endif;
else:
    echo '<div class="alert alert-danger text-center">No student data provided.</div>';
endif;
?>
<script>
function fitSingleStudentToPage() {
    const container = document.querySelector('.mark-container');
    if (!container) return;

    const A4_HEIGHT = 1122; // px for printable area

    container.style.transform = 'scale(1)';
    container.style.transformOrigin = 'top left';

    const contentHeight = container.scrollHeight;

    if (contentHeight > A4_HEIGHT) {
        let scale = A4_HEIGHT / contentHeight;
        scale = Math.max(scale, 0.75); // prevent unreadable shrink
        container.style.transform = `scale(${scale})`;
    }
}
</script>
