<section class="panel">
	<div class="tabs-custom">
		<ul class="nav nav-tabs">
			<li class="active">
				<a href="#deposit" data-toggle="tab"><i class="fas fa-wallet"></i> <?= translate('Deposit Money') ?></a>
			</li>
		</ul>

		<div class="tab-content">
			<div id="deposit" class="tab-pane active">
				<div class="mb-xlg">
					<h4>Current Wallet Balance: <?= isset($walletbalance) ? $walletbalance : 0 ?></h4>

					<?php echo form_open('depositpayment/topupcheckout', ['class' => 'form-horizontal frm-submit']); ?>

					<div class="form-group">
						<label class="col-md-3 control-label text-danger font-weight-bold">
							<?= translate('Notice - Deposit is Non Refundable') ?>
						</label>
						<div class="col-md-6"></div>
					</div>

					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('Amount') ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<input type="text" class="form-control" name="deposit_amount" placeholder="Enter Amount from 5000"required onkeypress="return event.charCode >= 48 && event.charCode <= 57" oninput="this.value = this.value.replace(/[^0-9]/g, '');">

							<span class="error"></span>
						</div>
					</div>

					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('Payment Method') ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<?php
							$payvia_list = ['' => translate('select_payment_method')];
							if (!empty($config)) {
								if ($config['paypal_status'] == 1) $payvia_list['paypal'] = 'Paypal';
								if ($config['stripe_status'] == 1) $payvia_list['stripe'] = 'Stripe';
								if ($config['paystack_status'] == 1) $payvia_list['paystack'] = 'Paystack';
								if ($config['flutterwave_status'] == 1) $payvia_list['flutterwave'] = 'Flutterwave';
							}
							echo form_dropdown("pay_via", $payvia_list, set_value('pay_via'), "class='form-control' id='pay_via'");
							?>
							<span class="error"></span>
						</div>
					</div>

					<!-- Submit -->
					<footer class="panel-footer">
						<div class="row">
							<div class="col-md-offset-3 col-md-3">
								<button type="submit" class="btn btn-default" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
									<i class="fas fa-credit-card"></i> <?= translate('Deposit Now') ?>
								</button>
							</div>
						</div>
					</footer>

					<?php echo form_close(); ?>
				</div>
			</div>
		</div>
	</div>
</section>